/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;
import net.minecraft.world.level.material.Material;

public class HugeFungusFeature
extends Feature<HugeFungusConfiguration> {
    private static final float HUGE_PROBABILITY = 0.06f;

    public HugeFungusFeature(Codec<HugeFungusConfiguration> p_65922_) {
        super(p_65922_);
    }

    @Override
    public boolean place(FeaturePlaceContext<HugeFungusConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        Random random = pContext.random();
        ChunkGenerator chunkgenerator = pContext.chunkGenerator();
        HugeFungusConfiguration hugefungusconfiguration = pContext.config();
        Block block = hugefungusconfiguration.validBaseState.getBlock();
        BlockPos blockpos1 = null;
        BlockState blockstate = worldgenlevel.getBlockState(blockpos.below());
        if (blockstate.is(block)) {
            blockpos1 = blockpos;
        }
        if (blockpos1 == null) {
            return false;
        }
        int i = Mth.nextInt(random, 4, 13);
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        if (!hugefungusconfiguration.planted) {
            int j = chunkgenerator.getGenDepth();
            if (blockpos1.getY() + i + 1 >= j) {
                return false;
            }
        }
        boolean flag = !hugefungusconfiguration.planted && random.nextFloat() < 0.06f;
        worldgenlevel.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 4);
        this.placeStem(worldgenlevel, random, hugefungusconfiguration, blockpos1, i, flag);
        this.placeHat(worldgenlevel, random, hugefungusconfiguration, blockpos1, i, flag);
        return true;
    }

    private static boolean isReplaceable(LevelAccessor pLevel, BlockPos pPos, boolean pReplacePlants) {
        return pLevel.isStateAtPosition(pPos, p_65966_ -> {
            Material material = p_65966_.getMaterial();
            return p_65966_.getMaterial().isReplaceable() || pReplacePlants && material == Material.PLANT;
        });
    }

    private void placeStem(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos pPos, int pHeight, boolean pDoubleWide) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockState blockstate = pConfig.stemState;
        int i = pDoubleWide ? 1 : 0;
        int j = -i;
        while (j <= i) {
            int k = -i;
            while (k <= i) {
                boolean flag = pDoubleWide && Mth.abs(j) == i && Mth.abs(k) == i;
                int l = 0;
                while (l < pHeight) {
                    blockpos$mutableblockpos.setWithOffset(pPos, j, l, k);
                    if (HugeFungusFeature.isReplaceable(pLevel, blockpos$mutableblockpos, true)) {
                        if (pConfig.planted) {
                            if (!pLevel.getBlockState(blockpos$mutableblockpos.below()).isAir()) {
                                pLevel.destroyBlock(blockpos$mutableblockpos, true);
                            }
                            pLevel.setBlock(blockpos$mutableblockpos, blockstate, 3);
                        } else if (flag) {
                            if (pRandom.nextFloat() < 0.1f) {
                                this.setBlock(pLevel, blockpos$mutableblockpos, blockstate);
                            }
                        } else {
                            this.setBlock(pLevel, blockpos$mutableblockpos, blockstate);
                        }
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
    }

    private void placeHat(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos pPos, int pHeight, boolean pDoubleWide) {
        int j;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean flag = pConfig.hatState.is(Blocks.NETHER_WART_BLOCK);
        int i = Math.min(pRandom.nextInt(1 + pHeight / 3) + 5, pHeight);
        int k = j = pHeight - i;
        while (k <= pHeight) {
            int l;
            int n = l = k < pHeight - pRandom.nextInt(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (pDoubleWide) {
                ++l;
            }
            int i1 = -l;
            while (i1 <= l) {
                int j1 = -l;
                while (j1 <= l) {
                    boolean flag1 = i1 == -l || i1 == l;
                    boolean flag2 = j1 == -l || j1 == l;
                    boolean flag3 = !flag1 && !flag2 && k != pHeight;
                    boolean flag4 = flag1 && flag2;
                    boolean flag5 = k < j + 3;
                    blockpos$mutableblockpos.setWithOffset(pPos, i1, k, j1);
                    if (HugeFungusFeature.isReplaceable(pLevel, blockpos$mutableblockpos, false)) {
                        if (pConfig.planted && !pLevel.getBlockState(blockpos$mutableblockpos.below()).isAir()) {
                            pLevel.destroyBlock(blockpos$mutableblockpos, true);
                        }
                        if (flag5) {
                            if (!flag3) {
                                this.placeHatDropBlock(pLevel, pRandom, blockpos$mutableblockpos, pConfig.hatState, flag);
                            }
                        } else if (flag3) {
                            this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 0.1f, 0.2f, flag ? 0.1f : 0.0f);
                        } else if (flag4) {
                            this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 0.01f, 0.7f, flag ? 0.083f : 0.0f);
                        } else {
                            this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 5.0E-4f, 0.98f, flag ? 0.07f : 0.0f);
                        }
                    }
                    ++j1;
                }
                ++i1;
            }
            ++k;
        }
    }

    private void placeHatBlock(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos.MutableBlockPos pPos, float pDecorationChance, float pHatChance, float pWeepingVineChance) {
        if (pRandom.nextFloat() < pDecorationChance) {
            this.setBlock(pLevel, pPos, pConfig.decorState);
        } else if (pRandom.nextFloat() < pHatChance) {
            this.setBlock(pLevel, pPos, pConfig.hatState);
            if (pRandom.nextFloat() < pWeepingVineChance) {
                HugeFungusFeature.tryPlaceWeepingVines(pPos, pLevel, pRandom);
            }
        }
    }

    private void placeHatDropBlock(LevelAccessor pLevel, Random pRandom, BlockPos pPos, BlockState pState, boolean pWeepingVines) {
        if (pLevel.getBlockState(pPos.below()).is(pState.getBlock())) {
            this.setBlock(pLevel, pPos, pState);
        } else if ((double)pRandom.nextFloat() < 0.15) {
            this.setBlock(pLevel, pPos, pState);
            if (pWeepingVines && pRandom.nextInt(11) == 0) {
                HugeFungusFeature.tryPlaceWeepingVines(pPos, pLevel, pRandom);
            }
        }
    }

    private static void tryPlaceWeepingVines(BlockPos pPos, LevelAccessor pLevel, Random pRandom) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable().move(Direction.DOWN);
        if (pLevel.isEmptyBlock(blockpos$mutableblockpos)) {
            int i = Mth.nextInt(pRandom, 1, 5);
            if (pRandom.nextInt(7) == 0) {
                i *= 2;
            }
            int j = 23;
            int k = 25;
            WeepingVinesFeature.placeWeepingVinesColumn(pLevel, pRandom, blockpos$mutableblockpos, i, 23, 25);
        }
    }
}

