/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.material.Material;

public class IcebergFeature
extends Feature<BlockStateConfiguration> {
    public IcebergFeature(Codec<BlockStateConfiguration> p_66017_) {
        super(p_66017_);
    }

    @Override
    public boolean place(FeaturePlaceContext<BlockStateConfiguration> pContext) {
        boolean flag2;
        int l;
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        blockpos = new BlockPos(blockpos.getX(), pContext.chunkGenerator().getSeaLevel(), blockpos.getZ());
        Random random = pContext.random();
        boolean flag = random.nextDouble() > 0.7;
        BlockState blockstate = pContext.config().state;
        double d0 = random.nextDouble() * 2.0 * Math.PI;
        int i = 11 - random.nextInt(5);
        int j = 3 + random.nextInt(3);
        boolean flag1 = random.nextDouble() > 0.7;
        int k = 11;
        int n = l = flag1 ? random.nextInt(6) + 6 : random.nextInt(15) + 3;
        if (!flag1 && random.nextDouble() > 0.9) {
            l += random.nextInt(19) + 7;
        }
        int i1 = Math.min(l + random.nextInt(11), 18);
        int j1 = Math.min(l + random.nextInt(7) - random.nextInt(5), 11);
        int k1 = flag1 ? i : 11;
        int l1 = -k1;
        while (l1 < k1) {
            int i2 = -k1;
            while (i2 < k1) {
                int j2 = 0;
                while (j2 < l) {
                    int k2;
                    int n2 = k2 = flag1 ? this.heightDependentRadiusEllipse(j2, l, j1) : this.heightDependentRadiusRound(random, j2, l, j1);
                    if (flag1 || l1 < k2) {
                        this.generateIcebergBlock(worldgenlevel, random, blockpos, l, l1, j2, i2, k2, k1, flag1, j, d0, flag, blockstate);
                    }
                    ++j2;
                }
                ++i2;
            }
            ++l1;
        }
        this.smooth(worldgenlevel, blockpos, j1, l, flag1, i);
        int i3 = -k1;
        while (i3 < k1) {
            int j3 = -k1;
            while (j3 < k1) {
                int k3 = -1;
                while (k3 > -i1) {
                    int l3 = flag1 ? Mth.ceil((float)k1 * (1.0f - (float)Math.pow(k3, 2.0) / ((float)i1 * 8.0f))) : k1;
                    int l2 = this.heightDependentRadiusSteep(random, -k3, i1, j1);
                    if (i3 < l2) {
                        this.generateIcebergBlock(worldgenlevel, random, blockpos, i1, i3, k3, j3, l2, l3, flag1, j, d0, flag, blockstate);
                    }
                    --k3;
                }
                ++j3;
            }
            ++i3;
        }
        boolean bl = flag1 ? random.nextDouble() > 0.1 : (flag2 = random.nextDouble() > 0.7);
        if (flag2) {
            this.generateCutOut(random, worldgenlevel, j1, l, blockpos, flag1, i, d0, j);
        }
        return true;
    }

    private void generateCutOut(Random pRandom, LevelAccessor pLevel, int pMajorAxis, int pHeight, BlockPos pPos, boolean pElliptical, int pEllipseRadius, double pAngle, int p_66108_) {
        int i = pRandom.nextBoolean() ? -1 : 1;
        int j = pRandom.nextBoolean() ? -1 : 1;
        int k = pRandom.nextInt(Math.max(pMajorAxis / 2 - 2, 1));
        if (pRandom.nextBoolean()) {
            k = pMajorAxis / 2 + 1 - pRandom.nextInt(Math.max(pMajorAxis - pMajorAxis / 2 - 1, 1));
        }
        int l = pRandom.nextInt(Math.max(pMajorAxis / 2 - 2, 1));
        if (pRandom.nextBoolean()) {
            l = pMajorAxis / 2 + 1 - pRandom.nextInt(Math.max(pMajorAxis - pMajorAxis / 2 - 1, 1));
        }
        if (pElliptical) {
            k = l = pRandom.nextInt(Math.max(pEllipseRadius - 5, 1));
        }
        BlockPos blockpos = new BlockPos(i * k, 0, j * l);
        double d0 = pElliptical ? pAngle + 1.5707963267948966 : pRandom.nextDouble() * 2.0 * Math.PI;
        int i1 = 0;
        while (i1 < pHeight - 3) {
            int j1 = this.heightDependentRadiusRound(pRandom, i1, pHeight, pMajorAxis);
            this.carve(j1, i1, pPos, pLevel, false, d0, blockpos, pEllipseRadius, p_66108_);
            ++i1;
        }
        int k1 = -1;
        while (k1 > -pHeight + pRandom.nextInt(5)) {
            int l1 = this.heightDependentRadiusSteep(pRandom, -k1, pHeight, pMajorAxis);
            this.carve(l1, k1, pPos, pLevel, true, d0, blockpos, pEllipseRadius, p_66108_);
            --k1;
        }
    }

    private void carve(int pRadius, int pLocalY, BlockPos pPos, LevelAccessor pLevel, boolean pPlaceWater, double pPerpendicularAngle, BlockPos p_66042_, int pEllipseOrigin, int pMajorRadius) {
        int i = pRadius + 1 + pEllipseOrigin / 3;
        int j = Math.min(pRadius - 3, 3) + pMajorRadius / 2 - 1;
        int k = -i;
        while (k < i) {
            int l = -i;
            while (l < i) {
                BlockPos blockpos;
                BlockState blockstate;
                double d0 = this.signedDistanceEllipse(k, l, p_66042_, i, j, pPerpendicularAngle);
                if (d0 < 0.0 && (IcebergFeature.isIcebergState(blockstate = pLevel.getBlockState(blockpos = pPos.offset(k, pLocalY, l))) || blockstate.is(Blocks.SNOW_BLOCK))) {
                    if (pPlaceWater) {
                        this.setBlock(pLevel, blockpos, Blocks.WATER.defaultBlockState());
                    } else {
                        this.setBlock(pLevel, blockpos, Blocks.AIR.defaultBlockState());
                        this.removeFloatingSnowLayer(pLevel, blockpos);
                    }
                }
                ++l;
            }
            ++k;
        }
    }

    private void removeFloatingSnowLayer(LevelAccessor pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos.above()).is(Blocks.SNOW)) {
            this.setBlock(pLevel, pPos.above(), Blocks.AIR.defaultBlockState());
        }
    }

    private void generateIcebergBlock(LevelAccessor pLevel, Random pRandom, BlockPos pPos, int pHeight, int pLocalX, int pLocalY, int pLocalZ, int pRadius, int pMajorRadius, boolean pElliptical, int pMinorRadius, double pAngle, boolean p_66071_, BlockState pPlaceSnow) {
        double d0;
        double d = d0 = pElliptical ? this.signedDistanceEllipse(pLocalX, pLocalZ, BlockPos.ZERO, pMajorRadius, this.getEllipseC(pLocalY, pHeight, pMinorRadius), pAngle) : this.signedDistanceCircle(pLocalX, pLocalZ, BlockPos.ZERO, pRadius, pRandom);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos = pPos.offset(pLocalX, pLocalY, pLocalZ);
            double d2 = d1 = pElliptical ? -0.5 : (double)(-6 - pRandom.nextInt(3));
            if (d0 > d1 && pRandom.nextDouble() > 0.9) {
                return;
            }
            this.setIcebergBlock(blockpos, pLevel, pRandom, pHeight - pLocalY, pHeight, pElliptical, p_66071_, pPlaceSnow);
        }
    }

    private void setIcebergBlock(BlockPos pPos, LevelAccessor pLevel, Random pRandom, int pHeightRemaining, int pHeight, boolean pElliptical, boolean pPlaceSnow, BlockState pState) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.getMaterial() == Material.AIR || blockstate.is(Blocks.SNOW_BLOCK) || blockstate.is(Blocks.ICE) || blockstate.is(Blocks.WATER)) {
            int i;
            boolean flag = !pElliptical || pRandom.nextDouble() > 0.05;
            int n = i = pElliptical ? 3 : 2;
            if (pPlaceSnow && !blockstate.is(Blocks.WATER) && (double)pHeightRemaining <= (double)pRandom.nextInt(Math.max(1, pHeight / i)) + (double)pHeight * 0.6 && flag) {
                this.setBlock(pLevel, pPos, Blocks.SNOW_BLOCK.defaultBlockState());
            } else {
                this.setBlock(pLevel, pPos, pState);
            }
        }
    }

    private int getEllipseC(int pY, int pHeight, int pMinorAxis) {
        int i = pMinorAxis;
        if (pY > 0 && pHeight - pY <= 3) {
            i = pMinorAxis - (4 - (pHeight - pY));
        }
        return i;
    }

    private double signedDistanceCircle(int pX, int pZ, BlockPos pCenter, int pRadius, Random pRandom) {
        float f = 10.0f * Mth.clamp(pRandom.nextFloat(), 0.2f, 0.8f) / (float)pRadius;
        return (double)f + Math.pow(pX - pCenter.getX(), 2.0) + Math.pow(pZ - pCenter.getZ(), 2.0) - Math.pow(pRadius, 2.0);
    }

    private double signedDistanceEllipse(int pX, int pZ, BlockPos pCenter, int pMajorRadius, int pMinorRadius, double pAngle) {
        return Math.pow(((double)(pX - pCenter.getX()) * Math.cos(pAngle) - (double)(pZ - pCenter.getZ()) * Math.sin(pAngle)) / (double)pMajorRadius, 2.0) + Math.pow(((double)(pX - pCenter.getX()) * Math.sin(pAngle) + (double)(pZ - pCenter.getZ()) * Math.cos(pAngle)) / (double)pMinorRadius, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(Random pRandom, int pY, int pHeight, int pMajorAxis) {
        float f = 3.5f - pRandom.nextFloat();
        float f1 = (1.0f - (float)Math.pow(pY, 2.0) / ((float)pHeight * f)) * (float)pMajorAxis;
        if (pHeight > 15 + pRandom.nextInt(5)) {
            int i = pY < 3 + pRandom.nextInt(6) ? pY / 2 : pY;
            f1 = (1.0f - (float)i / ((float)pHeight * f * 0.4f)) * (float)pMajorAxis;
        }
        return Mth.ceil(f1 / 2.0f);
    }

    private int heightDependentRadiusEllipse(int pY, int pHeight, int pMaxRadius) {
        float f = 1.0f;
        float f1 = (1.0f - (float)Math.pow(pY, 2.0) / ((float)pHeight * 1.0f)) * (float)pMaxRadius;
        return Mth.ceil(f1 / 2.0f);
    }

    private int heightDependentRadiusSteep(Random pRandom, int pY, int pHeight, int pMaxRadius) {
        float f = 1.0f + pRandom.nextFloat() / 2.0f;
        float f1 = (1.0f - (float)pY / ((float)pHeight * f)) * (float)pMaxRadius;
        return Mth.ceil(f1 / 2.0f);
    }

    private static boolean isIcebergState(BlockState pState) {
        return pState.is(Blocks.PACKED_ICE) || pState.is(Blocks.SNOW_BLOCK) || pState.is(Blocks.BLUE_ICE);
    }

    private boolean belowIsAir(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).getMaterial() == Material.AIR;
    }

    private void smooth(LevelAccessor pLevel, BlockPos pPos, int pMajorRadius, int pHeight, boolean pElliptical, int pMinorRadius) {
        int i = pElliptical ? pMinorRadius : pMajorRadius / 2;
        int j = -i;
        while (j <= i) {
            int k = -i;
            while (k <= i) {
                int l = 0;
                while (l <= pHeight) {
                    BlockPos blockpos = pPos.offset(j, l, k);
                    BlockState blockstate = pLevel.getBlockState(blockpos);
                    if (IcebergFeature.isIcebergState(blockstate) || blockstate.is(Blocks.SNOW)) {
                        if (this.belowIsAir(pLevel, blockpos)) {
                            this.setBlock(pLevel, blockpos, Blocks.AIR.defaultBlockState());
                            this.setBlock(pLevel, blockpos.above(), Blocks.AIR.defaultBlockState());
                        } else if (IcebergFeature.isIcebergState(blockstate)) {
                            BlockState[] ablockstate = new BlockState[]{pLevel.getBlockState(blockpos.west()), pLevel.getBlockState(blockpos.east()), pLevel.getBlockState(blockpos.north()), pLevel.getBlockState(blockpos.south())};
                            int i1 = 0;
                            BlockState[] blockStateArray = ablockstate;
                            int n = ablockstate.length;
                            int n2 = 0;
                            while (n2 < n) {
                                BlockState blockstate1 = blockStateArray[n2];
                                if (!IcebergFeature.isIcebergState(blockstate1)) {
                                    ++i1;
                                }
                                ++n2;
                            }
                            if (i1 >= 3) {
                                this.setBlock(pLevel, blockpos, Blocks.AIR.defaultBlockState());
                            }
                        }
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
    }
}

