/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Material;

@Deprecated
public class LakeFeature
extends Feature<Configuration> {
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public LakeFeature(Codec<Configuration> p_66259_) {
        super(p_66259_);
    }

    @Override
    public boolean place(FeaturePlaceContext<Configuration> p_159958_) {
        BlockPos blockpos = p_159958_.origin();
        WorldGenLevel worldgenlevel = p_159958_.level();
        Random random = p_159958_.random();
        Configuration lakefeature$configuration = p_159958_.config();
        if (blockpos.getY() <= worldgenlevel.getMinBuildHeight() + 4) {
            return false;
        }
        blockpos = blockpos.below(4);
        boolean[] aboolean = new boolean[2048];
        int i = random.nextInt(4) + 4;
        int j = 0;
        while (j < i) {
            double d0 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            int l = 1;
            while (l < 15) {
                int i1 = 1;
                while (i1 < 15) {
                    int j1 = 1;
                    while (j1 < 7) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (d9 < 1.0) {
                            aboolean[(l * 16 + i1) * 8 + j1] = true;
                        }
                        ++j1;
                    }
                    ++i1;
                }
                ++l;
            }
            ++j;
        }
        BlockState blockstate1 = lakefeature$configuration.fluid().getState(random, blockpos);
        int k1 = 0;
        while (k1 < 16) {
            int k = 0;
            while (k < 16) {
                int l2 = 0;
                while (l2 < 8) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && aboolean[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && aboolean[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && aboolean[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && aboolean[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && aboolean[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && aboolean[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (flag) {
                        Material material = worldgenlevel.getBlockState(blockpos.offset(k1, l2, k)).getMaterial();
                        if (l2 >= 4 && material.isLiquid()) {
                            return false;
                        }
                        if (l2 < 4 && !material.isSolid() && worldgenlevel.getBlockState(blockpos.offset(k1, l2, k)) != blockstate1) {
                            return false;
                        }
                    }
                    ++l2;
                }
                ++k;
            }
            ++k1;
        }
        int l1 = 0;
        while (l1 < 16) {
            int i2 = 0;
            while (i2 < 16) {
                int i3 = 0;
                while (i3 < 8) {
                    BlockPos blockpos1;
                    if (aboolean[(l1 * 16 + i2) * 8 + i3] && this.canReplaceBlock(worldgenlevel.getBlockState(blockpos1 = blockpos.offset(l1, i3, i2)))) {
                        boolean flag1 = i3 >= 4;
                        worldgenlevel.setBlock(blockpos1, flag1 ? AIR : blockstate1, 2);
                        if (flag1) {
                            worldgenlevel.scheduleTick(blockpos1, AIR.getBlock(), 0);
                            this.markAboveForPostProcessing(worldgenlevel, blockpos1);
                        }
                    }
                    ++i3;
                }
                ++i2;
            }
            ++l1;
        }
        BlockState blockstate2 = lakefeature$configuration.barrier().getState(random, blockpos);
        if (!blockstate2.isAir()) {
            int j2 = 0;
            while (j2 < 16) {
                int j3 = 0;
                while (j3 < 16) {
                    int l3 = 0;
                    while (l3 < 8) {
                        BlockState blockstate;
                        boolean flag2;
                        boolean bl = flag2 = !aboolean[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && aboolean[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && aboolean[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && aboolean[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && aboolean[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && aboolean[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && aboolean[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                        if (flag2 && (l3 < 4 || random.nextInt(2) != 0) && (blockstate = worldgenlevel.getBlockState(blockpos.offset(j2, l3, j3))).getMaterial().isSolid() && !blockstate.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) {
                            BlockPos blockpos3 = blockpos.offset(j2, l3, j3);
                            worldgenlevel.setBlock(blockpos3, blockstate2, 2);
                            this.markAboveForPostProcessing(worldgenlevel, blockpos3);
                        }
                        ++l3;
                    }
                    ++j3;
                }
                ++j2;
            }
        }
        if (blockstate1.getFluidState().is(FluidTags.WATER)) {
            int k2 = 0;
            while (k2 < 16) {
                int k3 = 0;
                while (k3 < 16) {
                    int i4 = 4;
                    BlockPos blockpos2 = blockpos.offset(k2, 4, k3);
                    if (worldgenlevel.getBiome(blockpos2).value().shouldFreeze(worldgenlevel, blockpos2, false) && this.canReplaceBlock(worldgenlevel.getBlockState(blockpos2))) {
                        worldgenlevel.setBlock(blockpos2, Blocks.ICE.defaultBlockState(), 2);
                    }
                    ++k3;
                }
                ++k2;
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState p_190952_) {
        return !p_190952_.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    public record Configuration(BlockStateProvider fluid, BlockStateProvider barrier) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(p_190962_ -> p_190962_.group((App)BlockStateProvider.CODEC.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.CODEC.fieldOf("barrier").forGetter(Configuration::barrier)).apply((Applicative)p_190962_, Configuration::new));
    }
}

