/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3;

public class LargeDripstoneFeature
extends Feature<LargeDripstoneConfiguration> {
    public LargeDripstoneFeature(Codec<LargeDripstoneConfiguration> p_159960_) {
        super(p_159960_);
    }

    @Override
    public boolean place(FeaturePlaceContext<LargeDripstoneConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        LargeDripstoneConfiguration largedripstoneconfiguration = pContext.config();
        Random random = pContext.random();
        if (!DripstoneUtils.isEmptyOrWater(worldgenlevel, blockpos)) {
            return false;
        }
        Optional<Column> optional = Column.scan(worldgenlevel, blockpos, largedripstoneconfiguration.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof Column.Range) {
            Column.Range column$range = (Column.Range)optional.get();
            if (column$range.height() < 4) {
                return false;
            }
            int i = (int)((float)column$range.height() * largedripstoneconfiguration.maxColumnRadiusToCaveHeightRatio);
            int j = Mth.clamp(i, largedripstoneconfiguration.columnRadius.getMinValue(), largedripstoneconfiguration.columnRadius.getMaxValue());
            int k = Mth.randomBetweenInclusive(random, largedripstoneconfiguration.columnRadius.getMinValue(), j);
            LargeDripstone largedripstonefeature$largedripstone = LargeDripstoneFeature.makeDripstone(blockpos.atY(column$range.ceiling() - 1), false, random, k, largedripstoneconfiguration.stalactiteBluntness, largedripstoneconfiguration.heightScale);
            LargeDripstone largedripstonefeature$largedripstone1 = LargeDripstoneFeature.makeDripstone(blockpos.atY(column$range.floor() + 1), true, random, k, largedripstoneconfiguration.stalagmiteBluntness, largedripstoneconfiguration.heightScale);
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.getY(), random, largedripstoneconfiguration.windSpeed) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos pRoot, boolean pPointingUp, Random pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargeDripstone(pRoot, pPointingUp, pRadius, pBluntnessBase.sample(pRandom), pScaleBase.sample(pRandom));
    }

    private void placeDebugMarkers(WorldGenLevel pLevel, BlockPos pPos, Column.Range pRange, WindOffsetter pWindOffsetter) {
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.ceiling() - 1)), Blocks.DIAMOND_BLOCK.defaultBlockState(), 2);
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.floor() + 1)), Blocks.GOLD_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.atY(pRange.floor() + 2).mutable();
        while (blockpos$mutableblockpos.getY() < pRange.ceiling() - 1) {
            BlockPos blockpos = pWindOffsetter.offset(blockpos$mutableblockpos);
            if (DripstoneUtils.isEmptyOrWater(pLevel, blockpos) || pLevel.getBlockState(blockpos).is(Blocks.DRIPSTONE_BLOCK)) {
                pLevel.setBlock(blockpos, Blocks.CREEPER_HEAD.defaultBlockState(), 2);
            }
            blockpos$mutableblockpos.move(Direction.UP);
        }
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double p_197120_) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = p_197120_;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.getY() : this.root.getY() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.getY() : this.root.getY() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.mutable();
                int i = Math.min(10, this.getHeight());
                int j = 0;
                while (j < i) {
                    if (pLevel.getBlockState(blockpos$mutableblockpos).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone(pLevel, pWindOffsetter.offset(blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                    ++j;
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)DripstoneUtils.getDripstoneHeight(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, Random pRandom, WindOffsetter pWindOffsetter) {
            int i = -this.radius;
            while (i <= this.radius) {
                int j = -this.radius;
                while (j <= this.radius) {
                    int k;
                    float f = Mth.sqrt(i * i + j * j);
                    if (!(f > (float)this.radius) && (k = this.getHeightAtRadius(f)) > 0) {
                        if ((double)pRandom.nextFloat() < 0.2) {
                            k = (int)((float)k * Mth.randomBetween(pRandom, 0.8f, 1.0f));
                        }
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.offset(i, 0, j).mutable();
                        boolean flag = false;
                        int l = this.pointingUp ? pLevel.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getZ()) : Integer.MAX_VALUE;
                        int i1 = 0;
                        while (i1 < k && blockpos$mutableblockpos.getY() < l) {
                            BlockPos blockpos = pWindOffsetter.offset(blockpos$mutableblockpos);
                            if (DripstoneUtils.isEmptyOrWaterOrLava(pLevel, blockpos)) {
                                flag = true;
                                Block block = Blocks.DRIPSTONE_BLOCK;
                                pLevel.setBlock(blockpos, block.defaultBlockState(), 2);
                            } else if (flag && pLevel.getBlockState(blockpos).is(BlockTags.BASE_STONE_OVERWORLD)) break;
                            blockpos$mutableblockpos.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                            ++i1;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration pConfig) {
            return this.radius >= pConfig.minRadiusForWind && this.bluntness >= (double)pConfig.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, Random pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float f = pMagnitude.sample(pRandom);
            float f1 = Mth.randomBetween(pRandom, 0.0f, (float)Math.PI);
            this.windSpeed = new Vec3(Mth.cos(f1) * f, 0.0, Mth.sin(f1) * f);
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int i = this.originY - pPos.getY();
            Vec3 vec3 = this.windSpeed.scale(i);
            return pPos.offset(vec3.x, 0.0, vec3.z);
        }
    }
}

