/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class OreFeature
extends Feature<OreConfiguration> {
    public OreFeature(Codec<OreConfiguration> p_66531_) {
        super(p_66531_);
    }

    @Override
    public boolean place(FeaturePlaceContext<OreConfiguration> pContext) {
        Random random = pContext.random();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        OreConfiguration oreconfiguration = pContext.config();
        float f = random.nextFloat() * (float)Math.PI;
        float f1 = (float)oreconfiguration.size / 8.0f;
        int i = Mth.ceil(((float)oreconfiguration.size / 16.0f * 2.0f + 1.0f) / 2.0f);
        double d0 = (double)blockpos.getX() + Math.sin(f) * (double)f1;
        double d1 = (double)blockpos.getX() - Math.sin(f) * (double)f1;
        double d2 = (double)blockpos.getZ() + Math.cos(f) * (double)f1;
        double d3 = (double)blockpos.getZ() - Math.cos(f) * (double)f1;
        int j = 2;
        double d4 = blockpos.getY() + random.nextInt(3) - 2;
        double d5 = blockpos.getY() + random.nextInt(3) - 2;
        int k = blockpos.getX() - Mth.ceil(f1) - i;
        int l = blockpos.getY() - 2 - i;
        int i1 = blockpos.getZ() - Mth.ceil(f1) - i;
        int j1 = 2 * (Mth.ceil(f1) + i);
        int k1 = 2 * (2 + i);
        int l1 = k;
        while (l1 <= k + j1) {
            int i2 = i1;
            while (i2 <= i1 + j1) {
                if (l <= worldgenlevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, l1, i2)) {
                    return this.doPlace(worldgenlevel, random, oreconfiguration, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
                }
                ++i2;
            }
            ++l1;
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel pLevel, Random pRandom, OreConfiguration pConfig, double pMinX, double p_66537_, double pMaxX, double p_66539_, double pMinZ, double p_66541_, int pMaxZ, int p_66543_, int pMinY, int p_66545_, int pMaxY) {
        int i = 0;
        BitSet bitset = new BitSet(p_66545_ * pMaxY * p_66545_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = pConfig.size;
        double[] adouble = new double[j * 4];
        int k = 0;
        while (k < j) {
            float f = (float)k / (float)j;
            double d0 = Mth.lerp((double)f, pMinX, p_66537_);
            double d1 = Mth.lerp((double)f, pMinZ, p_66541_);
            double d2 = Mth.lerp((double)f, pMaxX, p_66539_);
            double d3 = pRandom.nextDouble() * (double)j / 16.0;
            double d4 = ((double)(Mth.sin((float)Math.PI * f) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4 + 0] = d0;
            adouble[k * 4 + 1] = d1;
            adouble[k * 4 + 2] = d2;
            adouble[k * 4 + 3] = d4;
            ++k;
        }
        int l3 = 0;
        while (l3 < j - 1) {
            if (!(adouble[l3 * 4 + 3] <= 0.0)) {
                int i4 = l3 + 1;
                while (i4 < j) {
                    double d12;
                    double d10;
                    double d8;
                    double d14;
                    if (!(adouble[i4 * 4 + 3] <= 0.0) && (d14 = adouble[l3 * 4 + 3] - adouble[i4 * 4 + 3]) * d14 > (d8 = adouble[l3 * 4 + 0] - adouble[i4 * 4 + 0]) * d8 + (d10 = adouble[l3 * 4 + 1] - adouble[i4 * 4 + 1]) * d10 + (d12 = adouble[l3 * 4 + 2] - adouble[i4 * 4 + 2]) * d12) {
                        if (d14 > 0.0) {
                            adouble[i4 * 4 + 3] = -1.0;
                        } else {
                            adouble[l3 * 4 + 3] = -1.0;
                        }
                    }
                    ++i4;
                }
            }
            ++l3;
        }
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess(pLevel);){
            int j4 = 0;
            while (j4 < j) {
                double d9 = adouble[j4 * 4 + 3];
                if (!(d9 < 0.0)) {
                    double d11 = adouble[j4 * 4 + 0];
                    double d13 = adouble[j4 * 4 + 1];
                    double d15 = adouble[j4 * 4 + 2];
                    int k4 = Math.max(Mth.floor(d11 - d9), pMaxZ);
                    int l = Math.max(Mth.floor(d13 - d9), p_66543_);
                    int i1 = Math.max(Mth.floor(d15 - d9), pMinY);
                    int j1 = Math.max(Mth.floor(d11 + d9), k4);
                    int k1 = Math.max(Mth.floor(d13 + d9), l);
                    int l1 = Math.max(Mth.floor(d15 + d9), i1);
                    int i2 = k4;
                    while (i2 <= j1) {
                        double d5 = ((double)i2 + 0.5 - d11) / d9;
                        if (d5 * d5 < 1.0) {
                            int j2 = l;
                            while (j2 <= k1) {
                                double d6 = ((double)j2 + 0.5 - d13) / d9;
                                if (d5 * d5 + d6 * d6 < 1.0) {
                                    int k2 = i1;
                                    while (k2 <= l1) {
                                        int l2;
                                        double d7 = ((double)k2 + 0.5 - d15) / d9;
                                        if (d5 * d5 + d6 * d6 + d7 * d7 < 1.0 && !pLevel.isOutsideBuildHeight(j2) && !bitset.get(l2 = i2 - pMaxZ + (j2 - p_66543_) * p_66545_ + (k2 - pMinY) * p_66545_ * pMaxY)) {
                                            LevelChunkSection levelchunksection;
                                            bitset.set(l2);
                                            blockpos$mutableblockpos.set(i2, j2, k2);
                                            if (pLevel.ensureCanWrite(blockpos$mutableblockpos) && (levelchunksection = bulksectionaccess.getSection(blockpos$mutableblockpos)) != null) {
                                                int i3 = SectionPos.sectionRelative(i2);
                                                int j3 = SectionPos.sectionRelative(j2);
                                                int k3 = SectionPos.sectionRelative(k2);
                                                BlockState blockstate = levelchunksection.getBlockState(i3, j3, k3);
                                                for (OreConfiguration.TargetBlockState oreconfiguration$targetblockstate : pConfig.targetStates) {
                                                    if (!OreFeature.canPlaceOre(blockstate, bulksectionaccess::getBlockState, pRandom, pConfig, oreconfiguration$targetblockstate, blockpos$mutableblockpos)) continue;
                                                    levelchunksection.setBlockState(i3, j3, k3, oreconfiguration$targetblockstate.state, false);
                                                    ++i;
                                                    break;
                                                }
                                            }
                                        }
                                        ++k2;
                                    }
                                }
                                ++j2;
                            }
                        }
                        ++i2;
                    }
                }
                ++j4;
            }
        }
        return i > 0;
    }

    public static boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, Random pRandom, OreConfiguration pConfig, OreConfiguration.TargetBlockState pTargetState, BlockPos.MutableBlockPos pMatablePos) {
        if (!pTargetState.target.test(pState, pRandom)) {
            return false;
        }
        if (OreFeature.shouldSkipAirCheck(pRandom, pConfig.discardChanceOnAirExposure)) {
            return true;
        }
        return !OreFeature.isAdjacentToAir(pAdjacentStateAccessor, pMatablePos);
    }

    protected static boolean shouldSkipAirCheck(Random pRandom, float pChance) {
        if (pChance <= 0.0f) {
            return true;
        }
        if (pChance >= 1.0f) {
            return false;
        }
        return pRandom.nextFloat() >= pChance;
    }
}

