/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalFeature
extends StructureFeature<RuinedPortalConfiguration> {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final float PROBABILITY_OF_AIR_POCKET = 0.5f;
    private static final float PROBABILITY_OF_UNDERGROUND = 0.5f;
    private static final float UNDERWATER_MOSSINESS = 0.8f;
    private static final float JUNGLE_MOSSINESS = 0.8f;
    private static final float SWAMP_MOSSINESS = 0.5f;
    private static final int MIN_Y_INDEX = 15;

    public RuinedPortalFeature(Codec<RuinedPortalConfiguration> p_66668_) {
        super(p_66668_, RuinedPortalFeature::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<RuinedPortalConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.Context<RuinedPortalConfiguration> p_197153_) {
        RuinedPortalPiece.VerticalPlacement ruinedportalpiece$verticalplacement;
        RuinedPortalPiece.Properties ruinedportalpiece$properties = new RuinedPortalPiece.Properties();
        RuinedPortalConfiguration ruinedportalconfiguration = p_197153_.config();
        WorldgenRandom worldgenrandom = new WorldgenRandom(new LegacyRandomSource(0L));
        worldgenrandom.setLargeFeatureSeed(p_197153_.seed(), p_197153_.chunkPos().x, p_197153_.chunkPos().z);
        if (ruinedportalconfiguration.portalType == Type.DESERT) {
            ruinedportalpiece$verticalplacement = RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED;
            ruinedportalpiece$properties.airPocket = false;
            ruinedportalpiece$properties.mossiness = 0.0f;
        } else if (ruinedportalconfiguration.portalType == Type.JUNGLE) {
            ruinedportalpiece$verticalplacement = RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            ruinedportalpiece$properties.airPocket = worldgenrandom.nextFloat() < 0.5f;
            ruinedportalpiece$properties.mossiness = 0.8f;
            ruinedportalpiece$properties.overgrown = true;
            ruinedportalpiece$properties.vines = true;
        } else if (ruinedportalconfiguration.portalType == Type.SWAMP) {
            ruinedportalpiece$verticalplacement = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
            ruinedportalpiece$properties.airPocket = false;
            ruinedportalpiece$properties.mossiness = 0.5f;
            ruinedportalpiece$properties.vines = true;
        } else if (ruinedportalconfiguration.portalType == Type.MOUNTAIN) {
            boolean flag = worldgenrandom.nextFloat() < 0.5f;
            ruinedportalpiece$verticalplacement = flag ? RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            ruinedportalpiece$properties.airPocket = flag || worldgenrandom.nextFloat() < 0.5f;
        } else if (ruinedportalconfiguration.portalType == Type.OCEAN) {
            ruinedportalpiece$verticalplacement = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
            ruinedportalpiece$properties.airPocket = false;
            ruinedportalpiece$properties.mossiness = 0.8f;
        } else if (ruinedportalconfiguration.portalType == Type.NETHER) {
            ruinedportalpiece$verticalplacement = RuinedPortalPiece.VerticalPlacement.IN_NETHER;
            ruinedportalpiece$properties.airPocket = worldgenrandom.nextFloat() < 0.5f;
            ruinedportalpiece$properties.mossiness = 0.0f;
            ruinedportalpiece$properties.replaceWithBlackstone = true;
        } else {
            boolean flag1 = worldgenrandom.nextFloat() < 0.5f;
            ruinedportalpiece$verticalplacement = flag1 ? RuinedPortalPiece.VerticalPlacement.UNDERGROUND : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            ruinedportalpiece$properties.airPocket = flag1 || worldgenrandom.nextFloat() < 0.5f;
        }
        ResourceLocation resourcelocation = worldgenrandom.nextFloat() < 0.05f ? new ResourceLocation(STRUCTURE_LOCATION_GIANT_PORTALS[worldgenrandom.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : new ResourceLocation(STRUCTURE_LOCATION_PORTALS[worldgenrandom.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structuretemplate = p_197153_.structureManager().getOrCreate(resourcelocation);
        Rotation rotation = Util.a(Rotation.values(), (Random)worldgenrandom);
        Mirror mirror = worldgenrandom.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockpos = new BlockPos(structuretemplate.getSize().getX() / 2, 0, structuretemplate.getSize().getZ() / 2);
        BlockPos blockpos1 = p_197153_.chunkPos().getWorldPosition();
        BoundingBox boundingbox = structuretemplate.getBoundingBox(blockpos1, rotation, blockpos, mirror);
        BlockPos blockpos2 = boundingbox.getCenter();
        int i = p_197153_.chunkGenerator().getBaseHeight(blockpos2.getX(), blockpos2.getZ(), RuinedPortalPiece.getHeightMapType(ruinedportalpiece$verticalplacement), p_197153_.heightAccessor()) - 1;
        int j = RuinedPortalFeature.findSuitableY(worldgenrandom, p_197153_.chunkGenerator(), ruinedportalpiece$verticalplacement, ruinedportalpiece$properties.airPocket, i, boundingbox.getYSpan(), boundingbox, p_197153_.heightAccessor());
        BlockPos blockpos3 = new BlockPos(blockpos1.getX(), j, blockpos1.getZ());
        return !p_197153_.validBiome().test(p_197153_.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(blockpos3.getX()), QuartPos.fromBlock(blockpos3.getY()), QuartPos.fromBlock(blockpos3.getZ()))) ? Optional.empty() : Optional.of((p_197150_, p_197151_) -> {
            if (ruinedPortalConfiguration.portalType == Type.MOUNTAIN || ruinedPortalConfiguration.portalType == Type.OCEAN || ruinedPortalConfiguration.portalType == Type.STANDARD) {
                properties.cold = RuinedPortalFeature.isCold(blockpos3, p_197153_.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(blockpos3.getX()), QuartPos.fromBlock(blockpos3.getY()), QuartPos.fromBlock(blockpos3.getZ())));
            }
            p_197150_.addPiece(new RuinedPortalPiece(p_197151_.structureManager(), blockpos3, ruinedportalpiece$verticalplacement, ruinedportalpiece$properties, resourcelocation, structuretemplate, rotation, mirror, blockpos));
        });
    }

    private static boolean isCold(BlockPos pPos, Holder<Biome> pBiome) {
        return pBiome.value().coldEnoughToSnow(pPos);
    }

    private static int findSuitableY(Random pRandom, ChunkGenerator pChunkGenerator, RuinedPortalPiece.VerticalPlacement pVerticalPlacement, boolean pAirPocket, int pBaseHeight, int pYSpan, BoundingBox pBoundingBox, LevelHeightAccessor pLevel) {
        int i;
        int j = pLevel.getMinBuildHeight() + 15;
        if (pVerticalPlacement == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            i = pAirPocket ? Mth.randomBetweenInclusive(pRandom, 32, 100) : (pRandom.nextFloat() < 0.5f ? Mth.randomBetweenInclusive(pRandom, 27, 29) : Mth.randomBetweenInclusive(pRandom, 29, 100));
        } else if (pVerticalPlacement == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            int k = pBaseHeight - pYSpan;
            i = RuinedPortalFeature.getRandomWithinInterval(pRandom, 70, k);
        } else if (pVerticalPlacement == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            int j1 = pBaseHeight - pYSpan;
            i = RuinedPortalFeature.getRandomWithinInterval(pRandom, j, j1);
        } else {
            i = pVerticalPlacement == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? pBaseHeight - pYSpan + Mth.randomBetweenInclusive(pRandom, 2, 8) : pBaseHeight;
        }
        ImmutableList list1 = ImmutableList.of((Object)new BlockPos(pBoundingBox.minX(), 0, pBoundingBox.minZ()), (Object)new BlockPos(pBoundingBox.maxX(), 0, pBoundingBox.minZ()), (Object)new BlockPos(pBoundingBox.minX(), 0, pBoundingBox.maxZ()), (Object)new BlockPos(pBoundingBox.maxX(), 0, pBoundingBox.maxZ()));
        List list = list1.stream().map(p_197138_ -> pChunkGenerator.getBaseColumn(p_197138_.getX(), p_197138_.getZ(), pLevel)).collect(Collectors.toList());
        Heightmap.Types heightmap$types = pVerticalPlacement == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        int l = i;
        while (l > j) {
            int i1 = 0;
            for (NoiseColumn noisecolumn : list) {
                BlockState blockstate = noisecolumn.getBlock(l);
                if (!heightmap$types.isOpaque().test(blockstate) || ++i1 != 3) continue;
                return l;
            }
            --l;
        }
        return l;
    }

    private static int getRandomWithinInterval(Random pRandom, int pMin, int pMax) {
        return pMin < pMax ? Mth.randomBetweenInclusive(pRandom, pMin, pMax) : pMax;
    }

    public static enum Type implements StringRepresentable
    {
        STANDARD("standard"),
        DESERT("desert"),
        JUNGLE("jungle"),
        SWAMP("swamp"),
        MOUNTAIN("mountain"),
        OCEAN("ocean"),
        NETHER("nether");

        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;

        static {
            CODEC = StringRepresentable.fromEnum(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_66746_ -> p_66746_));
        }

        private Type(String p_66743_) {
            this.name = p_66743_;
        }

        public String getName() {
            return this.name;
        }

        public static Type byName(String p_66748_) {
            return BY_NAME.get(p_66748_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

