/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;

public class SpikeFeature
extends Feature<SpikeConfiguration> {
    public static final int NUMBER_OF_SPIKES = 10;
    private static final int SPIKE_DISTANCE = 42;
    private static final LoadingCache<Long, List<EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());

    public SpikeFeature(Codec<SpikeConfiguration> p_66852_) {
        super(p_66852_);
    }

    public static List<EndSpike> getSpikesForLevel(WorldGenLevel pLevel) {
        Random random = new Random(pLevel.getSeed());
        long i = random.nextLong() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)i);
    }

    @Override
    public boolean place(FeaturePlaceContext<SpikeConfiguration> pContext) {
        SpikeConfiguration spikeconfiguration = pContext.config();
        WorldGenLevel worldgenlevel = pContext.level();
        Random random = pContext.random();
        BlockPos blockpos = pContext.origin();
        List<EndSpike> list = spikeconfiguration.getSpikes();
        if (list.isEmpty()) {
            list = SpikeFeature.getSpikesForLevel(worldgenlevel);
        }
        for (EndSpike spikefeature$endspike : list) {
            if (!spikefeature$endspike.isCenterWithinChunk(blockpos)) continue;
            this.placeSpike(worldgenlevel, random, spikeconfiguration, spikefeature$endspike);
        }
        return true;
    }

    private void placeSpike(ServerLevelAccessor pLevel, Random pRandom, SpikeConfiguration pConfig, EndSpike pSpike) {
        int i = pSpike.getRadius();
        for (BlockPos blockpos : BlockPos.betweenClosed(new BlockPos(pSpike.getCenterX() - i, pLevel.getMinBuildHeight(), pSpike.getCenterZ() - i), new BlockPos(pSpike.getCenterX() + i, pSpike.getHeight() + 10, pSpike.getCenterZ() + i))) {
            if (blockpos.distToLowCornerSqr(pSpike.getCenterX(), blockpos.getY(), pSpike.getCenterZ()) <= (double)(i * i + 1) && blockpos.getY() < pSpike.getHeight()) {
                this.setBlock(pLevel, blockpos, Blocks.OBSIDIAN.defaultBlockState());
                continue;
            }
            if (blockpos.getY() <= 65) continue;
            this.setBlock(pLevel, blockpos, Blocks.AIR.defaultBlockState());
        }
        if (pSpike.isGuarded()) {
            int j1 = -2;
            int k1 = 2;
            int j = 3;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int k = -2;
            while (k <= 2) {
                int l = -2;
                while (l <= 2) {
                    int i1 = 0;
                    while (i1 <= 3) {
                        boolean flag2;
                        boolean flag = Mth.abs(k) == 2;
                        boolean flag1 = Mth.abs(l) == 2;
                        boolean bl = flag2 = i1 == 3;
                        if (flag || flag1 || flag2) {
                            boolean flag3 = k == -2 || k == 2 || flag2;
                            boolean flag4 = l == -2 || l == 2 || flag2;
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, flag3 && l != -2)).setValue(IronBarsBlock.SOUTH, flag3 && l != 2)).setValue(IronBarsBlock.WEST, flag4 && k != -2)).setValue(IronBarsBlock.EAST, flag4 && k != 2);
                            this.setBlock(pLevel, blockpos$mutableblockpos.set(pSpike.getCenterX() + k, pSpike.getHeight() + i1, pSpike.getCenterZ() + l), blockstate);
                        }
                        ++i1;
                    }
                    ++l;
                }
                ++k;
            }
        }
        EndCrystal endcrystal = EntityType.END_CRYSTAL.create(pLevel.getLevel());
        endcrystal.setBeamTarget(pConfig.getCrystalBeamTarget());
        endcrystal.setInvulnerable(pConfig.isCrystalInvulnerable());
        endcrystal.moveTo((double)pSpike.getCenterX() + 0.5, pSpike.getHeight() + 1, (double)pSpike.getCenterZ() + 0.5, pRandom.nextFloat() * 360.0f, 0.0f);
        pLevel.addFreshEntity(endcrystal);
        this.setBlock(pLevel, new BlockPos(pSpike.getCenterX(), pSpike.getHeight(), pSpike.getCenterZ()), Blocks.BEDROCK.defaultBlockState());
    }

    public static class EndSpike {
        public static final Codec<EndSpike> CODEC = RecordCodecBuilder.create(p_66890_ -> p_66890_.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(p_160382_ -> p_160382_.centerX), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(p_160380_ -> p_160380_.centerZ), (App)Codec.INT.fieldOf("radius").orElse((Object)0).forGetter(p_160378_ -> p_160378_.radius), (App)Codec.INT.fieldOf("height").orElse((Object)0).forGetter(p_160376_ -> p_160376_.height), (App)Codec.BOOL.fieldOf("guarded").orElse((Object)false).forGetter(p_160374_ -> p_160374_.guarded)).apply((Applicative)p_66890_, EndSpike::new));
        private final int centerX;
        private final int centerZ;
        private final int radius;
        private final int height;
        private final boolean guarded;
        private final AABB topBoundingBox;

        public EndSpike(int p_66881_, int p_66882_, int p_66883_, int p_66884_, boolean p_66885_) {
            this.centerX = p_66881_;
            this.centerZ = p_66882_;
            this.radius = p_66883_;
            this.height = p_66884_;
            this.guarded = p_66885_;
            this.topBoundingBox = new AABB(p_66881_ - p_66883_, DimensionType.MIN_Y, p_66882_ - p_66883_, p_66881_ + p_66883_, DimensionType.MAX_Y, p_66882_ + p_66883_);
        }

        public boolean isCenterWithinChunk(BlockPos pPos) {
            return SectionPos.blockToSectionCoord(pPos.getX()) == SectionPos.blockToSectionCoord(this.centerX) && SectionPos.blockToSectionCoord(pPos.getZ()) == SectionPos.blockToSectionCoord(this.centerZ);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public int getCenterZ() {
            return this.centerZ;
        }

        public int getRadius() {
            return this.radius;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isGuarded() {
            return this.guarded;
        }

        public AABB getTopBoundingBox() {
            return this.topBoundingBox;
        }
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, List<EndSpike>> {
        SpikeCacheLoader() {
        }

        public List<EndSpike> load(Long p_66910_) {
            List list = IntStream.range(0, 10).boxed().collect(Collectors.toList());
            Collections.shuffle(list, new Random(p_66910_));
            ArrayList list1 = Lists.newArrayList();
            int i = 0;
            while (i < 10) {
                int j = Mth.floor(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int k = Mth.floor(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int l = (Integer)list.get(i);
                int i1 = 2 + l / 3;
                int j1 = 76 + l * 3;
                boolean flag = l == 1 || l == 2;
                list1.add(new EndSpike(j, k, i1, j1, flag));
                ++i;
            }
            return list1;
        }
    }
}

