/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeFeature
extends Feature<TreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public TreeFeature(Codec<TreeConfiguration> p_67201_) {
        super(p_67201_);
    }

    public static boolean isFree(LevelSimulatedReader pLevel, BlockPos pPos) {
        return TreeFeature.validTreePos(pLevel, pPos) || pLevel.isStateAtPosition(pPos, p_67281_ -> p_67281_.is(BlockTags.LOGS));
    }

    private static boolean isVine(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, p_67276_ -> p_67276_.is(Blocks.VINE));
    }

    private static boolean isBlockWater(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, p_67271_ -> p_67271_.is(Blocks.WATER));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, p_67266_ -> p_67266_.isAir() || p_67266_.is(BlockTags.LEAVES));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, p_160551_ -> {
            Material material = p_160551_.getMaterial();
            return material == Material.REPLACEABLE_PLANT;
        });
    }

    private static void setBlockKnownShape(LevelWriter pLevel, BlockPos pPos, BlockState pState) {
        pLevel.setBlock(pPos, pState, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return TreeFeature.isAirOrLeaves(pLevel, pPos) || TreeFeature.isReplaceablePlant(pLevel, pPos) || TreeFeature.isBlockWater(pLevel, pPos);
    }

    private boolean doPlace(WorldGenLevel pLevel, Random pRandom, BlockPos pPos, BiConsumer<BlockPos, BlockState> pTrunkBlockSetter, BiConsumer<BlockPos, BlockState> pFoliageBlockSetter, TreeConfiguration pConfig) {
        int i = pConfig.trunkPlacer.getTreeHeight(pRandom);
        int j = pConfig.foliagePlacer.foliageHeight(pRandom, i, pConfig);
        int k = i - j;
        int l = pConfig.foliagePlacer.foliageRadius(pRandom, k);
        if (pPos.getY() >= pLevel.getMinBuildHeight() + 1 && pPos.getY() + i + 1 <= pLevel.getMaxBuildHeight()) {
            OptionalInt optionalint = pConfig.minimumSize.minClippedHeight();
            int i1 = this.getMaxFreeTreeHeight(pLevel, i, pPos, pConfig);
            if (i1 >= i || optionalint.isPresent() && i1 >= optionalint.getAsInt()) {
                List<FoliagePlacer.FoliageAttachment> list = pConfig.trunkPlacer.placeTrunk(pLevel, pTrunkBlockSetter, pRandom, i1, pPos, pConfig);
                list.forEach(p_160539_ -> treeConfiguration.foliagePlacer.createFoliage(pLevel, pFoliageBlockSetter, pRandom, pConfig, i1, (FoliagePlacer.FoliageAttachment)p_160539_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader pLevel, int pTrunkHeight, BlockPos pTopPosition, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 0;
        while (i <= pTrunkHeight + 1) {
            int j = pConfig.minimumSize.getSizeAtHeight(pTrunkHeight, i);
            int k = -j;
            while (k <= j) {
                int l = -j;
                while (l <= j) {
                    blockpos$mutableblockpos.setWithOffset(pTopPosition, k, i, l);
                    if (!TreeFeature.isFree(pLevel, blockpos$mutableblockpos) || !pConfig.ignoreVines && TreeFeature.isVine(pLevel, blockpos$mutableblockpos)) {
                        return i - 2;
                    }
                    ++l;
                }
                ++k;
            }
            ++i;
        }
        return pTrunkHeight;
    }

    @Override
    protected void setBlock(LevelWriter pLevel, BlockPos pPos, BlockState pState) {
        TreeFeature.setBlockKnownShape(pLevel, pPos, pState);
    }

    @Override
    public final boolean place(FeaturePlaceContext<TreeConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        Random random = pContext.random();
        BlockPos blockpos = pContext.origin();
        TreeConfiguration treeconfiguration = pContext.config();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.immutable());
            worldgenlevel.setBlock((BlockPos)p_160555_, (BlockState)p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.immutable());
            worldgenlevel.setBlock((BlockPos)p_160548_, (BlockState)p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer2 = (p_160543_, p_160544_) -> {
            set2.add(p_160543_.immutable());
            worldgenlevel.setBlock((BlockPos)p_160543_, (BlockState)p_160544_, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, random, blockpos, biconsumer, biconsumer1, treeconfiguration);
        if (!(!flag || set.isEmpty() && set1.isEmpty())) {
            if (!treeconfiguration.decorators.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vec3i::getY));
                list1.sort(Comparator.comparingInt(Vec3i::getY));
                treeconfiguration.decorators.forEach(p_160528_ -> p_160528_.place(worldgenlevel, biconsumer2, random, list, list1));
            }
            return BoundingBox.encapsulatingPositions(Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                DiscreteVoxelShape discretevoxelshape = TreeFeature.updateLeaves(worldgenlevel, p_160521_, set, set2);
                StructureTemplate.updateShapeAtEdge(worldgenlevel, 3, discretevoxelshape, p_160521_.minX(), p_160521_.minY(), p_160521_.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor pLevel, BoundingBox pBoundingBox, Set<BlockPos> pLogPositions, Set<BlockPos> pFoliagePositions) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(pBoundingBox.getXSpan(), pBoundingBox.getYSpan(), pBoundingBox.getZSpan());
        int i = 6;
        int j = 0;
        while (j < 6) {
            list.add(Sets.newHashSet());
            ++j;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(pFoliagePositions)) {
            if (!pBoundingBox.isInside(blockpos)) continue;
            ((DiscreteVoxelShape)discretevoxelshape).fill(blockpos.getX() - pBoundingBox.minX(), blockpos.getY() - pBoundingBox.minY(), blockpos.getZ() - pBoundingBox.minZ());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(pLogPositions)) {
            if (pBoundingBox.isInside(blockpos1)) {
                ((DiscreteVoxelShape)discretevoxelshape).fill(blockpos1.getX() - pBoundingBox.minX(), blockpos1.getY() - pBoundingBox.minY(), blockpos1.getZ() - pBoundingBox.minZ());
            }
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                BlockState blockstate;
                Direction direction = directionArray[n2];
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, direction);
                if (!pLogPositions.contains(blockpos$mutableblockpos) && (blockstate = pLevel.getBlockState(blockpos$mutableblockpos)).hasProperty(BlockStateProperties.DISTANCE)) {
                    ((Set)list.get(0)).add(blockpos$mutableblockpos.immutable());
                    TreeFeature.setBlockKnownShape(pLevel, blockpos$mutableblockpos, (BlockState)blockstate.setValue(BlockStateProperties.DISTANCE, 1));
                    if (pBoundingBox.isInside(blockpos$mutableblockpos)) {
                        ((DiscreteVoxelShape)discretevoxelshape).fill(blockpos$mutableblockpos.getX() - pBoundingBox.minX(), blockpos$mutableblockpos.getY() - pBoundingBox.minY(), blockpos$mutableblockpos.getZ() - pBoundingBox.minZ());
                    }
                }
                ++n2;
            }
        }
        int l = 1;
        while (l < 6) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (pBoundingBox.isInside(blockpos2)) {
                    ((DiscreteVoxelShape)discretevoxelshape).fill(blockpos2.getX() - pBoundingBox.minX(), blockpos2.getY() - pBoundingBox.minY(), blockpos2.getZ() - pBoundingBox.minZ());
                }
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int k;
                    BlockState blockstate1;
                    Direction direction1 = directionArray[n3];
                    blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos2, direction1);
                    if (!set.contains(blockpos$mutableblockpos) && !set1.contains(blockpos$mutableblockpos) && (blockstate1 = pLevel.getBlockState(blockpos$mutableblockpos)).hasProperty(BlockStateProperties.DISTANCE) && (k = blockstate1.getValue(BlockStateProperties.DISTANCE).intValue()) > l + 1) {
                        BlockState blockstate2 = (BlockState)blockstate1.setValue(BlockStateProperties.DISTANCE, l + 1);
                        TreeFeature.setBlockKnownShape(pLevel, blockpos$mutableblockpos, blockstate2);
                        if (pBoundingBox.isInside(blockpos$mutableblockpos)) {
                            ((DiscreteVoxelShape)discretevoxelshape).fill(blockpos$mutableblockpos.getX() - pBoundingBox.minX(), blockpos$mutableblockpos.getY() - pBoundingBox.minY(), blockpos$mutableblockpos.getZ() - pBoundingBox.minZ());
                        }
                        set1.add(blockpos$mutableblockpos.immutable());
                    }
                    ++n3;
                }
            }
            ++l;
        }
        return discretevoxelshape;
    }
}

