/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class VegetationPatchFeature
extends Feature<VegetationPatchConfiguration> {
    public VegetationPatchFeature(Codec<VegetationPatchConfiguration> p_160588_) {
        super(p_160588_);
    }

    @Override
    public boolean place(FeaturePlaceContext<VegetationPatchConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        VegetationPatchConfiguration vegetationpatchconfiguration = pContext.config();
        Random random = pContext.random();
        BlockPos blockpos = pContext.origin();
        Predicate<BlockState> predicate = p_204782_ -> p_204782_.is(vegetationPatchConfiguration.replaceable);
        int i = vegetationpatchconfiguration.xzRadius.sample(random) + 1;
        int j = vegetationpatchconfiguration.xzRadius.sample(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, vegetationpatchconfiguration, random, blockpos, predicate, i, j);
        this.distributeVegetation(pContext, worldgenlevel, vegetationpatchconfiguration, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, Random pRandom, BlockPos pPos, Predicate<BlockState> pState, int pXRadius, int pZRadius) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.mutable();
        Direction direction = pConfig.surface.getDirection();
        Direction direction1 = direction.getOpposite();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int i = -pXRadius;
        while (i <= pXRadius) {
            boolean flag = i == -pXRadius || i == pXRadius;
            int j = -pZRadius;
            while (j <= pZRadius) {
                boolean flag4;
                boolean flag1 = j == -pZRadius || j == pZRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (!(flag3 || flag4 && (pConfig.extraEdgeColumnChance == 0.0f || pRandom.nextFloat() > pConfig.extraEdgeColumnChance))) {
                    blockpos$mutableblockpos.setWithOffset(pPos, i, 0, j);
                    int k = 0;
                    while (pLevel.isStateAtPosition(blockpos$mutableblockpos, BlockBehaviour.BlockStateBase::isAir) && k < pConfig.verticalRange) {
                        blockpos$mutableblockpos.move(direction);
                        ++k;
                    }
                    int i1 = 0;
                    while (pLevel.isStateAtPosition(blockpos$mutableblockpos, p_204784_ -> !p_204784_.isAir()) && i1 < pConfig.verticalRange) {
                        blockpos$mutableblockpos.move(direction1);
                        ++i1;
                    }
                    blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos$mutableblockpos, pConfig.surface.getDirection());
                    BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos1);
                    if (pLevel.isEmptyBlock(blockpos$mutableblockpos) && blockstate.isFaceSturdy(pLevel, blockpos$mutableblockpos1, pConfig.surface.getDirection().getOpposite())) {
                        int l = pConfig.depth.sample(pRandom) + (pConfig.extraBottomBlockChance > 0.0f && pRandom.nextFloat() < pConfig.extraBottomBlockChance ? 1 : 0);
                        BlockPos blockpos = blockpos$mutableblockpos1.immutable();
                        boolean flag5 = this.placeGround(pLevel, pConfig, pState, pRandom, blockpos$mutableblockpos1, l);
                        if (flag5) {
                            set.add(blockpos);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return set;
    }

    protected void distributeVegetation(FeaturePlaceContext<VegetationPatchConfiguration> pContext, WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, Random pRandom, Set<BlockPos> pPossiblePositions, int pXRadius, int pZRadius) {
        for (BlockPos blockpos : pPossiblePositions) {
            if (!(pConfig.vegetationChance > 0.0f) || !(pRandom.nextFloat() < pConfig.vegetationChance)) continue;
            this.placeVegetation(pLevel, pConfig, pContext.chunkGenerator(), pRandom, blockpos);
        }
    }

    protected boolean placeVegetation(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, ChunkGenerator pChunkGenerator, Random pRandom, BlockPos pPos) {
        return pConfig.vegetationFeature.value().place(pLevel, pChunkGenerator, pRandom, pPos.relative(pConfig.surface.getDirection().getOpposite()));
    }

    protected boolean placeGround(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, Predicate<BlockState> pReplaceableBlocks, Random pRandom, BlockPos.MutableBlockPos pMutablePos, int pMaxDistance) {
        int i = 0;
        while (i < pMaxDistance) {
            BlockState blockstate1;
            BlockState blockstate = pConfig.groundState.getState(pRandom, pMutablePos);
            if (!blockstate.is((blockstate1 = pLevel.getBlockState(pMutablePos)).getBlock())) {
                if (!pReplaceableBlocks.test(blockstate1)) {
                    return i != 0;
                }
                pLevel.setBlock(pMutablePos, blockstate, 2);
                pMutablePos.move(pConfig.surface.getDirection());
            }
            ++i;
        }
        return true;
    }
}

