/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class WaterloggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterloggedVegetationPatchFeature(Codec<VegetationPatchConfiguration> p_160635_) {
        super(p_160635_);
    }

    @Override
    protected Set<BlockPos> placeGroundPatch(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, Random pRandom, BlockPos pPos, Predicate<BlockState> pState, int pXRadius, int pZRadius) {
        Set<BlockPos> set = super.placeGroundPatch(pLevel, pConfig, pRandom, pPos, pState, pXRadius, pZRadius);
        HashSet<BlockPos> set1 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : set) {
            if (WaterloggedVegetationPatchFeature.isExposed(pLevel, set, blockpos, blockpos$mutableblockpos)) continue;
            set1.add(blockpos);
        }
        for (BlockPos blockpos1 : set1) {
            pLevel.setBlock(blockpos1, Blocks.WATER.defaultBlockState(), 2);
        }
        return set1;
    }

    private static boolean isExposed(WorldGenLevel pLevel, Set<BlockPos> pPositions, BlockPos pPos, BlockPos.MutableBlockPos pMutablePos) {
        return WaterloggedVegetationPatchFeature.isExposedDirection(pLevel, pPos, pMutablePos, Direction.NORTH) || WaterloggedVegetationPatchFeature.isExposedDirection(pLevel, pPos, pMutablePos, Direction.EAST) || WaterloggedVegetationPatchFeature.isExposedDirection(pLevel, pPos, pMutablePos, Direction.SOUTH) || WaterloggedVegetationPatchFeature.isExposedDirection(pLevel, pPos, pMutablePos, Direction.WEST) || WaterloggedVegetationPatchFeature.isExposedDirection(pLevel, pPos, pMutablePos, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel pLevel, BlockPos pPos, BlockPos.MutableBlockPos pMutablePos, Direction pDirection) {
        pMutablePos.setWithOffset((Vec3i)pPos, pDirection);
        return !pLevel.getBlockState(pMutablePos).isFaceSturdy(pLevel, pMutablePos, pDirection.getOpposite());
    }

    @Override
    protected boolean placeVegetation(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, ChunkGenerator pChunkGenerator, Random pRandom, BlockPos pPos) {
        if (super.placeVegetation(pLevel, pConfig, pChunkGenerator, pRandom, pPos.below())) {
            BlockState blockstate = pLevel.getBlockState(pPos);
            if (blockstate.hasProperty(BlockStateProperties.WATERLOGGED) && !blockstate.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                pLevel.setBlock(pPos, (BlockState)blockstate.setValue(BlockStateProperties.WATERLOGGED, true), 2);
            }
            return true;
        }
        return false;
    }
}

