/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WeepingVinesFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public WeepingVinesFeature(Codec<NoneFeatureConfiguration> p_67375_) {
        super(p_67375_);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        Random random = pContext.random();
        if (!worldgenlevel.isEmptyBlock(blockpos)) {
            return false;
        }
        BlockState blockstate = worldgenlevel.getBlockState(blockpos.above());
        if (!blockstate.is(Blocks.NETHERRACK) && !blockstate.is(Blocks.NETHER_WART_BLOCK)) {
            return false;
        }
        this.placeRoofNetherWart(worldgenlevel, random, blockpos);
        this.placeRoofWeepingVines(worldgenlevel, random, blockpos);
        return true;
    }

    private void placeRoofNetherWart(LevelAccessor pLevel, Random pRandom, BlockPos pPos) {
        pLevel.setBlock(pPos, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
        int i = 0;
        while (i < 200) {
            blockpos$mutableblockpos.setWithOffset(pPos, pRandom.nextInt(6) - pRandom.nextInt(6), pRandom.nextInt(2) - pRandom.nextInt(5), pRandom.nextInt(6) - pRandom.nextInt(6));
            if (pLevel.isEmptyBlock(blockpos$mutableblockpos)) {
                int j = 0;
                Direction[] directionArray = DIRECTIONS;
                int n = DIRECTIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    Direction direction = directionArray[n2];
                    BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos$mutableblockpos, direction));
                    if (blockstate.is(Blocks.NETHERRACK) || blockstate.is(Blocks.NETHER_WART_BLOCK)) {
                        ++j;
                    }
                    if (j > 1) break;
                    ++n2;
                }
                if (j == 1) {
                    pLevel.setBlock(blockpos$mutableblockpos, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
                }
            }
            ++i;
        }
    }

    private void placeRoofWeepingVines(LevelAccessor pLevel, Random pRandom, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 0;
        while (i < 100) {
            BlockState blockstate;
            blockpos$mutableblockpos.setWithOffset(pPos, pRandom.nextInt(8) - pRandom.nextInt(8), pRandom.nextInt(2) - pRandom.nextInt(7), pRandom.nextInt(8) - pRandom.nextInt(8));
            if (pLevel.isEmptyBlock(blockpos$mutableblockpos) && ((blockstate = pLevel.getBlockState(blockpos$mutableblockpos.above())).is(Blocks.NETHERRACK) || blockstate.is(Blocks.NETHER_WART_BLOCK))) {
                int j = Mth.nextInt(pRandom, 1, 8);
                if (pRandom.nextInt(6) == 0) {
                    j *= 2;
                }
                if (pRandom.nextInt(5) == 0) {
                    j = 1;
                }
                int k = 17;
                int l = 25;
                WeepingVinesFeature.placeWeepingVinesColumn(pLevel, pRandom, blockpos$mutableblockpos, j, 17, 25);
            }
            ++i;
        }
    }

    public static void placeWeepingVinesColumn(LevelAccessor pLevel, Random pRandom, BlockPos.MutableBlockPos pPos, int pHeight, int pMinAge, int pMaxAge) {
        int i = 0;
        while (i <= pHeight) {
            if (pLevel.isEmptyBlock(pPos)) {
                if (i == pHeight || !pLevel.isEmptyBlock(pPos.below())) {
                    pLevel.setBlock(pPos, (BlockState)Blocks.WEEPING_VINES.defaultBlockState().setValue(GrowingPlantHeadBlock.AGE, Mth.nextInt(pRandom, pMinAge, pMaxAge)), 2);
                    break;
                }
                pLevel.setBlock(pPos, Blocks.WEEPING_VINES_PLANT.defaultBlockState(), 2);
            }
            pPos.move(Direction.DOWN);
            ++i;
        }
    }
}

