/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.featuresize;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;

public class TwoLayersFeatureSize
extends FeatureSize {
    public static final Codec<TwoLayersFeatureSize> CODEC = RecordCodecBuilder.create(p_68356_ -> p_68356_.group((App)Codec.intRange((int)0, (int)81).fieldOf("limit").orElse((Object)1).forGetter(p_161341_ -> p_161341_.limit), (App)Codec.intRange((int)0, (int)16).fieldOf("lower_size").orElse((Object)0).forGetter(p_161339_ -> p_161339_.lowerSize), (App)Codec.intRange((int)0, (int)16).fieldOf("upper_size").orElse((Object)1).forGetter(p_161337_ -> p_161337_.upperSize), TwoLayersFeatureSize.minClippedHeightCodec()).apply((Applicative)p_68356_, TwoLayersFeatureSize::new));
    private final int limit;
    private final int lowerSize;
    private final int upperSize;

    public TwoLayersFeatureSize(int pLimit, int pLowerSize, int pUpperSize) {
        this(pLimit, pLowerSize, pUpperSize, OptionalInt.empty());
    }

    public TwoLayersFeatureSize(int p_68346_, int p_68347_, int p_68348_, OptionalInt p_68349_) {
        super(p_68349_);
        this.limit = p_68346_;
        this.lowerSize = p_68347_;
        this.upperSize = p_68348_;
    }

    @Override
    protected FeatureSizeType<?> type() {
        return FeatureSizeType.TWO_LAYERS_FEATURE_SIZE;
    }

    @Override
    public int getSizeAtHeight(int pHeight, int pMidpoint) {
        return pMidpoint < this.limit ? this.lowerSize : this.upperSize;
    }
}

