/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public abstract class FoliagePlacer {
    public static final Codec<FoliagePlacer> CODEC = Registry.FOLIAGE_PLACER_TYPES.byNameCodec().dispatch(FoliagePlacer::type, FoliagePlacerType::codec);
    protected final IntProvider radius;
    protected final IntProvider offset;

    protected static <P extends FoliagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> foliagePlacerParts(RecordCodecBuilder.Instance<P> pInstance) {
        return pInstance.group((App)IntProvider.codec(0, 16).fieldOf("radius").forGetter(p_161449_ -> p_161449_.radius), (App)IntProvider.codec(0, 16).fieldOf("offset").forGetter(p_161447_ -> p_161447_.offset));
    }

    public FoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        this.radius = pRadius;
        this.offset = pOffset;
    }

    protected abstract FoliagePlacerType<?> type();

    public void createFoliage(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius) {
        this.createFoliage(pLevel, pBlockSetter, pRandom, pConfig, pMaxFreeTreeHeight, pAttachment, pFoliageHeight, pFoliageRadius, this.offset(pRandom));
    }

    protected abstract void createFoliage(LevelSimulatedReader var1, BiConsumer<BlockPos, BlockState> var2, Random var3, TreeConfiguration var4, int var5, FoliageAttachment var6, int var7, int var8, int var9);

    public abstract int foliageHeight(Random var1, int var2, TreeConfiguration var3);

    public int foliageRadius(Random pRandom, int pRadius) {
        return this.radius.sample(pRandom);
    }

    private int offset(Random pRandom) {
        return this.offset.sample(pRandom);
    }

    protected abstract boolean shouldSkipLocation(Random var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean shouldSkipLocationSigned(Random pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        int j;
        int i;
        if (pLarge) {
            i = Math.min(Math.abs(pLocalX), Math.abs(pLocalX - 1));
            j = Math.min(Math.abs(pLocalZ), Math.abs(pLocalZ - 1));
        } else {
            i = Math.abs(pLocalX);
            j = Math.abs(pLocalZ);
        }
        return this.shouldSkipLocation(pRandom, i, pLocalY, j, pRange, pLarge);
    }

    protected void placeLeavesRow(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, TreeConfiguration pConfig, BlockPos pPos, int pRange, int pYOffset, boolean pLarge) {
        int i = pLarge ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = -pRange;
        while (j <= pRange + i) {
            int k = -pRange;
            while (k <= pRange + i) {
                if (!this.shouldSkipLocationSigned(pRandom, j, pYOffset, k, pRange, pLarge)) {
                    blockpos$mutableblockpos.setWithOffset(pPos, j, pYOffset, k);
                    FoliagePlacer.tryPlaceLeaf(pLevel, pBlockSetter, pRandom, pConfig, blockpos$mutableblockpos);
                }
                ++k;
            }
            ++j;
        }
    }

    protected static void tryPlaceLeaf(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, TreeConfiguration pConfig, BlockPos pPos) {
        if (TreeFeature.validTreePos(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pConfig.foliageProvider.getState(pRandom, pPos));
        }
    }

    public static final class FoliageAttachment {
        private final BlockPos pos;
        private final int radiusOffset;
        private final boolean doubleTrunk;

        public FoliageAttachment(BlockPos pPos, int pRadiusOffset, boolean pDoubleTrunk) {
            this.pos = pPos;
            this.radiusOffset = pRadiusOffset;
            this.doubleTrunk = pDoubleTrunk;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public int radiusOffset() {
            return this.radiusOffset;
        }

        public boolean doubleTrunk() {
            return this.doubleTrunk;
        }
    }
}

