/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DualNoiseProvider
extends NoiseProvider {
    public static final Codec<DualNoiseProvider> CODEC = RecordCodecBuilder.create(p_191414_ -> p_191414_.group((App)InclusiveRange.codec(Codec.INT, 1, 64).fieldOf("variety").forGetter(p_191416_ -> p_191416_.variety), (App)NormalNoise.NoiseParameters.DIRECT_CODEC.fieldOf("slow_noise").forGetter(p_191412_ -> p_191412_.slowNoiseParameters), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("slow_scale").forGetter(p_191405_ -> Float.valueOf(p_191405_.slowScale))).and(DualNoiseProvider.noiseProviderCodec(p_191414_)).apply((Applicative)p_191414_, DualNoiseProvider::new));
    private final InclusiveRange<Integer> variety;
    private final NormalNoise.NoiseParameters slowNoiseParameters;
    private final float slowScale;
    private final NormalNoise slowNoise;

    public DualNoiseProvider(InclusiveRange<Integer> p_191396_, NormalNoise.NoiseParameters p_191397_, float p_191398_, long p_191399_, NormalNoise.NoiseParameters p_191400_, float p_191401_, List<BlockState> p_191402_) {
        super(p_191399_, p_191400_, p_191401_, p_191402_);
        this.variety = p_191396_;
        this.slowNoiseParameters = p_191397_;
        this.slowScale = p_191398_;
        this.slowNoise = NormalNoise.create(new WorldgenRandom(new LegacyRandomSource(p_191399_)), p_191397_);
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.DUAL_NOISE_PROVIDER;
    }

    @Override
    public BlockState getState(Random p_191409_, BlockPos p_191410_) {
        double d0 = this.getSlowNoiseValue(p_191410_);
        int i = (int)Mth.clampedMap(d0, -1.0, 1.0, (double)this.variety.minInclusive().intValue(), (double)(this.variety.maxInclusive() + 1));
        ArrayList list = Lists.newArrayListWithCapacity((int)i);
        int j = 0;
        while (j < i) {
            list.add(this.getRandomState(this.states, this.getSlowNoiseValue(p_191410_.offset(j * 54545, 0, j * 34234))));
            ++j;
        }
        return this.getRandomState(list, p_191410_, this.scale);
    }

    protected double getSlowNoiseValue(BlockPos p_191407_) {
        return this.slowNoise.getValue((float)p_191407_.getX() * this.slowScale, (float)p_191407_.getY() * this.slowScale, (float)p_191407_.getZ() * this.slowScale);
    }
}

