/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class RandomizedIntStateProvider
extends BlockStateProvider {
    public static final Codec<RandomizedIntStateProvider> CODEC = RecordCodecBuilder.create(p_161576_ -> p_161576_.group((App)BlockStateProvider.CODEC.fieldOf("source").forGetter(p_161592_ -> p_161592_.source), (App)Codec.STRING.fieldOf("property").forGetter(p_161590_ -> p_161590_.propertyName), (App)IntProvider.CODEC.fieldOf("values").forGetter(p_161578_ -> p_161578_.values)).apply((Applicative)p_161576_, RandomizedIntStateProvider::new));
    private final BlockStateProvider source;
    private final String propertyName;
    @Nullable
    private IntegerProperty property;
    private final IntProvider values;

    public RandomizedIntStateProvider(BlockStateProvider pSource, IntegerProperty pProperty, IntProvider pValues) {
        this.source = pSource;
        this.property = pProperty;
        this.propertyName = pProperty.getName();
        this.values = pValues;
        Collection<Integer> collection = pProperty.getPossibleValues();
        int i = pValues.getMinValue();
        while (i <= pValues.getMaxValue()) {
            if (!collection.contains(i)) {
                throw new IllegalArgumentException("Property value out of range: " + pProperty.getName() + ": " + i);
            }
            ++i;
        }
    }

    public RandomizedIntStateProvider(BlockStateProvider pSource, String pProperty, IntProvider pValues) {
        this.source = pSource;
        this.propertyName = pProperty;
        this.values = pValues;
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.RANDOMIZED_INT_STATE_PROVIDER;
    }

    @Override
    public BlockState getState(Random pRandom, BlockPos pPos) {
        BlockState blockstate = this.source.getState(pRandom, pPos);
        if (this.property == null || !blockstate.hasProperty(this.property)) {
            this.property = RandomizedIntStateProvider.findProperty(blockstate, this.propertyName);
        }
        return (BlockState)blockstate.setValue(this.property, this.values.sample(pRandom));
    }

    private static IntegerProperty findProperty(BlockState pState, String pPropertyName) {
        Collection<Property> collection = pState.getProperties();
        Optional<IntegerProperty> optional = collection.stream().filter(p_161583_ -> p_161583_.getName().equals(pPropertyName)).filter(p_161588_ -> p_161588_ instanceof IntegerProperty).map(p_161574_ -> (IntegerProperty)p_161574_).findAny();
        return optional.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + pPropertyName));
    }
}

