/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class WeightedStateProvider
extends BlockStateProvider {
    public static final Codec<WeightedStateProvider> CODEC = SimpleWeightedRandomList.wrappedCodec(BlockState.CODEC).comapFlatMap(WeightedStateProvider::create, p_161600_ -> p_161600_.weightedList).fieldOf("entries").codec();
    private final SimpleWeightedRandomList<BlockState> weightedList;

    private static DataResult<WeightedStateProvider> create(SimpleWeightedRandomList<BlockState> p_161598_) {
        return p_161598_.isEmpty() ? DataResult.error((String)"WeightedStateProvider with no states") : DataResult.success((Object)new WeightedStateProvider(p_161598_));
    }

    public WeightedStateProvider(SimpleWeightedRandomList<BlockState> pBuilder) {
        this.weightedList = pBuilder;
    }

    public WeightedStateProvider(SimpleWeightedRandomList.Builder<BlockState> pBuilder) {
        this(pBuilder.build());
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.WEIGHTED_STATE_PROVIDER;
    }

    @Override
    public BlockState getState(Random pRandom, BlockPos pBlockPos) {
        return this.weightedList.getRandomValue(pRandom).orElseThrow(IllegalStateException::new);
    }
}

