/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final Codec<LeaveVineDecorator> CODEC = Codec.unit(() -> INSTANCE);
    public static final LeaveVineDecorator INSTANCE = new LeaveVineDecorator();

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    @Override
    public void place(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        pLeafPositions.forEach(p_161744_ -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (pRandom.nextInt(4) == 0 && Feature.isAir(pLevel, blockpos = p_161744_.west())) {
                LeaveVineDecorator.addHangingVine(pLevel, blockpos, VineBlock.EAST, pBlockSetter);
            }
            if (pRandom.nextInt(4) == 0 && Feature.isAir(pLevel, blockpos1 = p_161744_.east())) {
                LeaveVineDecorator.addHangingVine(pLevel, blockpos1, VineBlock.WEST, pBlockSetter);
            }
            if (pRandom.nextInt(4) == 0 && Feature.isAir(pLevel, blockpos2 = p_161744_.north())) {
                LeaveVineDecorator.addHangingVine(pLevel, blockpos2, VineBlock.SOUTH, pBlockSetter);
            }
            if (pRandom.nextInt(4) == 0 && Feature.isAir(pLevel, blockpos3 = p_161744_.south())) {
                LeaveVineDecorator.addHangingVine(pLevel, blockpos3, VineBlock.NORTH, pBlockSetter);
            }
        });
    }

    private static void addHangingVine(LevelSimulatedReader pLevel, BlockPos pPos, BooleanProperty pSideProperty, BiConsumer<BlockPos, BlockState> pBlockSetter) {
        LeaveVineDecorator.placeVine(pBlockSetter, pPos, pSideProperty);
        int i = 4;
        BlockPos blockpos = pPos.below();
        while (Feature.isAir(pLevel, blockpos) && i > 0) {
            LeaveVineDecorator.placeVine(pBlockSetter, blockpos, pSideProperty);
            blockpos = blockpos.below();
            --i;
        }
    }
}

