/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TrunkVineDecorator
extends TreeDecorator {
    public static final Codec<TrunkVineDecorator> CODEC = Codec.unit(() -> INSTANCE);
    public static final TrunkVineDecorator INSTANCE = new TrunkVineDecorator();

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.TRUNK_VINE;
    }

    @Override
    public void place(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        pLogPositions.forEach(p_161764_ -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (pRandom.nextInt(3) > 0 && Feature.isAir(pLevel, blockpos = p_161764_.west())) {
                TrunkVineDecorator.placeVine(pBlockSetter, blockpos, VineBlock.EAST);
            }
            if (pRandom.nextInt(3) > 0 && Feature.isAir(pLevel, blockpos1 = p_161764_.east())) {
                TrunkVineDecorator.placeVine(pBlockSetter, blockpos1, VineBlock.WEST);
            }
            if (pRandom.nextInt(3) > 0 && Feature.isAir(pLevel, blockpos2 = p_161764_.north())) {
                TrunkVineDecorator.placeVine(pBlockSetter, blockpos2, VineBlock.SOUTH);
            }
            if (pRandom.nextInt(3) > 0 && Feature.isAir(pLevel, blockpos3 = p_161764_.south())) {
                TrunkVineDecorator.placeVine(pBlockSetter, blockpos3, VineBlock.NORTH);
            }
        });
    }
}

