/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ForkingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ForkingTrunkPlacer> CODEC = RecordCodecBuilder.create(p_70161_ -> ForkingTrunkPlacer.trunkPlacerParts(p_70161_).apply((Applicative)p_70161_, ForkingTrunkPlacer::new));

    public ForkingTrunkPlacer(int p_70148_, int p_70149_, int p_70150_) {
        super(p_70148_, p_70149_, p_70150_);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.FORKING_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader p_161828_, BiConsumer<BlockPos, BlockState> p_161829_, Random p_161830_, int p_161831_, BlockPos p_161832_, TreeConfiguration p_161833_) {
        ForkingTrunkPlacer.setDirtAt(p_161828_, p_161829_, p_161830_, p_161832_.below(), p_161833_);
        ArrayList list = Lists.newArrayList();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(p_161830_);
        int i = p_161831_ - p_161830_.nextInt(4) - 1;
        int j = 3 - p_161830_.nextInt(3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = p_161832_.getX();
        int l = p_161832_.getZ();
        OptionalInt optionalint = OptionalInt.empty();
        int i1 = 0;
        while (i1 < p_161831_) {
            int j1 = p_161832_.getY() + i1;
            if (i1 >= i && j > 0) {
                k += direction.getStepX();
                l += direction.getStepZ();
                --j;
            }
            if (ForkingTrunkPlacer.placeLog(p_161828_, p_161829_, p_161830_, blockpos$mutableblockpos.set(k, j1, l), p_161833_)) {
                optionalint = OptionalInt.of(j1 + 1);
            }
            ++i1;
        }
        if (optionalint.isPresent()) {
            list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(k, optionalint.getAsInt(), l), 1, false));
        }
        k = p_161832_.getX();
        l = p_161832_.getZ();
        Direction direction1 = Direction.Plane.HORIZONTAL.getRandomDirection(p_161830_);
        if (direction1 != direction) {
            int j2 = i - p_161830_.nextInt(2) - 1;
            int k1 = 1 + p_161830_.nextInt(3);
            optionalint = OptionalInt.empty();
            int l1 = j2;
            while (l1 < p_161831_ && k1 > 0) {
                if (l1 >= 1) {
                    int i2 = p_161832_.getY() + l1;
                    if (ForkingTrunkPlacer.placeLog(p_161828_, p_161829_, p_161830_, blockpos$mutableblockpos.set(k += direction1.getStepX(), i2, l += direction1.getStepZ()), p_161833_)) {
                        optionalint = OptionalInt.of(i2 + 1);
                    }
                }
                ++l1;
                --k1;
            }
            if (optionalint.isPresent()) {
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(k, optionalint.getAsInt(), l), 0, false));
            }
        }
        return list;
    }
}

