/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightmapPlacement
extends PlacementModifier {
    public static final Codec<HeightmapPlacement> CODEC = RecordCodecBuilder.create(p_191701_ -> p_191701_.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(p_191705_ -> p_191705_.heightmap)).apply((Applicative)p_191701_, HeightmapPlacement::new));
    private final Heightmap.Types heightmap;

    private HeightmapPlacement(Heightmap.Types p_191699_) {
        this.heightmap = p_191699_;
    }

    public static HeightmapPlacement onHeightmap(Heightmap.Types p_191703_) {
        return new HeightmapPlacement(p_191703_);
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext p_191707_, Random p_191708_, BlockPos p_191709_) {
        int j;
        int i = p_191709_.getX();
        int k = p_191707_.getHeight(this.heightmap, i, j = p_191709_.getZ());
        return k > p_191707_.getMinBuildHeight() ? Stream.of(new BlockPos(i, k, j)) : Stream.of(new BlockPos[0]);
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.HEIGHTMAP;
    }
}

