/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SurfaceRelativeThresholdFilter
extends PlacementFilter {
    public static final Codec<SurfaceRelativeThresholdFilter> CODEC = RecordCodecBuilder.create(p_191929_ -> p_191929_.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(p_191944_ -> p_191944_.heightmap), (App)Codec.INT.optionalFieldOf("min_inclusive", (Object)Integer.MIN_VALUE).forGetter(p_191942_ -> p_191942_.minInclusive), (App)Codec.INT.optionalFieldOf("max_inclusive", (Object)Integer.MAX_VALUE).forGetter(p_191939_ -> p_191939_.maxInclusive)).apply((Applicative)p_191929_, SurfaceRelativeThresholdFilter::new));
    private final Heightmap.Types heightmap;
    private final int minInclusive;
    private final int maxInclusive;

    private SurfaceRelativeThresholdFilter(Heightmap.Types p_191925_, int p_191926_, int p_191927_) {
        this.heightmap = p_191925_;
        this.minInclusive = p_191926_;
        this.maxInclusive = p_191927_;
    }

    public static SurfaceRelativeThresholdFilter of(Heightmap.Types p_191931_, int p_191932_, int p_191933_) {
        return new SurfaceRelativeThresholdFilter(p_191931_, p_191932_, p_191933_);
    }

    @Override
    protected boolean shouldPlace(PlacementContext p_191935_, Random p_191936_, BlockPos p_191937_) {
        long i = p_191935_.getHeight(this.heightmap, p_191937_.getX(), p_191937_.getZ());
        long j = i + (long)this.minInclusive;
        long k = i + (long)this.maxInclusive;
        return j <= (long)p_191937_.getY() && (long)p_191937_.getY() <= k;
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.SURFACE_RELATIVE_THRESHOLD_FILTER;
    }
}

