/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SurfaceWaterDepthFilter
extends PlacementFilter {
    public static final Codec<SurfaceWaterDepthFilter> CODEC = RecordCodecBuilder.create(p_191953_ -> p_191953_.group((App)Codec.INT.fieldOf("max_water_depth").forGetter(p_191959_ -> p_191959_.maxWaterDepth)).apply((Applicative)p_191953_, SurfaceWaterDepthFilter::new));
    private final int maxWaterDepth;

    private SurfaceWaterDepthFilter(int p_191949_) {
        this.maxWaterDepth = p_191949_;
    }

    public static SurfaceWaterDepthFilter forMaxDepth(int p_191951_) {
        return new SurfaceWaterDepthFilter(p_191951_);
    }

    @Override
    protected boolean shouldPlace(PlacementContext p_191955_, Random p_191956_, BlockPos p_191957_) {
        int i = p_191955_.getHeight(Heightmap.Types.OCEAN_FLOOR, p_191957_.getX(), p_191957_.getZ());
        int j = p_191955_.getHeight(Heightmap.Types.WORLD_SURFACE, p_191957_.getX(), p_191957_.getZ());
        return j - i <= this.maxWaterDepth;
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.SURFACE_WATER_DEPTH_FILTER;
    }
}

