/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class EndCityPieces {
    private static final int MAX_GEN_DEPTH = 8;
    static final SectionGenerator HOUSE_TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureManager p_71161_, int p_71162_, EndCityPiece p_71163_, BlockPos p_71164_, List<StructurePiece> p_71165_, Random p_71166_) {
            if (p_71162_ > 8) {
                return false;
            }
            Rotation rotation = p_71163_.placeSettings.getRotation();
            EndCityPiece endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, p_71163_, p_71164_, "base_floor", rotation, true));
            int i = p_71166_.nextInt(3);
            if (i == 0) {
                EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 4, -1), "base_roof", rotation, true));
            } else if (i == 1) {
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 8, -1), "second_roof", rotation, false));
                EndCityPieces.recursiveChildren(p_71161_, TOWER_GENERATOR, p_71162_ + 1, endcitypieces$endcitypiece, null, p_71165_, p_71166_);
            } else if (i == 2) {
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 4, -1), "third_floor_2", rotation, false));
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71165_, EndCityPieces.addPiece(p_71161_, endcitypieces$endcitypiece, new BlockPos(-1, 8, -1), "third_roof", rotation, true));
                EndCityPieces.recursiveChildren(p_71161_, TOWER_GENERATOR, p_71162_ + 1, endcitypieces$endcitypiece, null, p_71165_, p_71166_);
            }
            return true;
        }
    };
    static final List<Tuple<Rotation, BlockPos>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(1, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(6, -1, 1)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 5)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(5, -1, 6))});
    static final SectionGenerator TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureManager p_71170_, int p_71171_, EndCityPiece p_71172_, BlockPos p_71173_, List<StructurePiece> p_71174_, Random p_71175_) {
            Rotation rotation = p_71172_.placeSettings.getRotation();
            EndCityPiece $$7 = EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, p_71172_, new BlockPos(3 + p_71175_.nextInt(2), -3, 3 + p_71175_.nextInt(2)), "tower_base", rotation, true));
            $$7 = EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, $$7, new BlockPos(0, 7, 0), "tower_piece", rotation, true));
            EndCityPiece endcitypieces$endcitypiece1 = p_71175_.nextInt(3) == 0 ? $$7 : null;
            int i = 1 + p_71175_.nextInt(3);
            int j = 0;
            while (j < i) {
                $$7 = EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, $$7, new BlockPos(0, 4, 0), "tower_piece", rotation, true));
                if (j < i - 1 && p_71175_.nextBoolean()) {
                    endcitypieces$endcitypiece1 = $$7;
                }
                ++j;
            }
            if (endcitypieces$endcitypiece1 != null) {
                for (Tuple<Rotation, BlockPos> tuple : TOWER_BRIDGES) {
                    if (!p_71175_.nextBoolean()) continue;
                    EndCityPiece endcitypieces$endcitypiece2 = EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, endcitypieces$endcitypiece1, tuple.getB(), "bridge_end", rotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(p_71170_, TOWER_BRIDGE_GENERATOR, p_71171_ + 1, endcitypieces$endcitypiece2, null, p_71174_, p_71175_);
                }
                EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, $$7, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            } else {
                if (p_71171_ != 7) {
                    return EndCityPieces.recursiveChildren(p_71170_, FAT_TOWER_GENERATOR, p_71171_ + 1, $$7, null, p_71174_, p_71175_);
                }
                EndCityPieces.addHelper(p_71174_, EndCityPieces.addPiece(p_71170_, $$7, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            }
            return true;
        }
    };
    static final SectionGenerator TOWER_BRIDGE_GENERATOR = new SectionGenerator(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(StructureManager p_71180_, int p_71181_, EndCityPiece p_71182_, BlockPos p_71183_, List<StructurePiece> p_71184_, Random p_71185_) {
            Rotation rotation = p_71182_.placeSettings.getRotation();
            int i = p_71185_.nextInt(4) + 1;
            EndCityPiece endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, p_71182_, new BlockPos(0, 0, -4), "bridge_piece", rotation, true));
            endcitypieces$endcitypiece.genDepth = -1;
            int j = 0;
            int k = 0;
            while (k < i) {
                if (p_71185_.nextBoolean()) {
                    endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, endcitypieces$endcitypiece, new BlockPos(0, j, -4), "bridge_piece", rotation, true));
                    j = 0;
                } else {
                    endcitypieces$endcitypiece = p_71185_.nextBoolean() ? EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, endcitypieces$endcitypiece, new BlockPos(0, j, -4), "bridge_steep_stairs", rotation, true)) : EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, endcitypieces$endcitypiece, new BlockPos(0, j, -8), "bridge_gentle_stairs", rotation, true));
                    j = 4;
                }
                ++k;
            }
            if (!this.shipCreated && p_71185_.nextInt(10 - p_71181_) == 0) {
                EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, endcitypieces$endcitypiece, new BlockPos(-8 + p_71185_.nextInt(8), j, -70 + p_71185_.nextInt(10)), "ship", rotation, true));
                this.shipCreated = true;
            } else if (!EndCityPieces.recursiveChildren(p_71180_, HOUSE_TOWER_GENERATOR, p_71181_ + 1, endcitypieces$endcitypiece, new BlockPos(-3, j + 1, -11), p_71184_, p_71185_)) {
                return false;
            }
            endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71184_, EndCityPieces.addPiece(p_71180_, endcitypieces$endcitypiece, new BlockPos(4, j, 0), "bridge_end", rotation.getRotated(Rotation.CLOCKWISE_180), true));
            endcitypieces$endcitypiece.genDepth = -1;
            return true;
        }
    };
    static final List<Tuple<Rotation, BlockPos>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(4, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(12, -1, 4)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 8)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(8, -1, 12))});
    static final SectionGenerator FAT_TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureManager p_71189_, int p_71190_, EndCityPiece p_71191_, BlockPos p_71192_, List<StructurePiece> p_71193_, Random p_71194_) {
            Rotation rotation = p_71191_.placeSettings.getRotation();
            EndCityPiece endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71193_, EndCityPieces.addPiece(p_71189_, p_71191_, new BlockPos(-3, 4, -3), "fat_tower_base", rotation, true));
            endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71193_, EndCityPieces.addPiece(p_71189_, endcitypieces$endcitypiece, new BlockPos(0, 4, 0), "fat_tower_middle", rotation, true));
            int i = 0;
            while (i < 2 && p_71194_.nextInt(3) != 0) {
                endcitypieces$endcitypiece = EndCityPieces.addHelper(p_71193_, EndCityPieces.addPiece(p_71189_, endcitypieces$endcitypiece, new BlockPos(0, 8, 0), "fat_tower_middle", rotation, true));
                for (Tuple<Rotation, BlockPos> tuple : FAT_TOWER_BRIDGES) {
                    if (!p_71194_.nextBoolean()) continue;
                    EndCityPiece endcitypieces$endcitypiece1 = EndCityPieces.addHelper(p_71193_, EndCityPieces.addPiece(p_71189_, endcitypieces$endcitypiece, tuple.getB(), "bridge_end", rotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(p_71189_, TOWER_BRIDGE_GENERATOR, p_71190_ + 1, endcitypieces$endcitypiece1, null, p_71193_, p_71194_);
                }
                ++i;
            }
            EndCityPieces.addHelper(p_71193_, EndCityPieces.addPiece(p_71189_, endcitypieces$endcitypiece, new BlockPos(-2, 8, -2), "fat_tower_top", rotation, true));
            return true;
        }
    };

    static EndCityPiece addPiece(StructureManager pStructureManager, EndCityPiece pPiece, BlockPos pPos, String pName, Rotation pRotation, boolean pOverwrite) {
        EndCityPiece endcitypieces$endcitypiece = new EndCityPiece(pStructureManager, pName, pPiece.templatePosition, pRotation, pOverwrite);
        BlockPos blockpos = pPiece.template.calculateConnectedPosition(pPiece.placeSettings, pPos, endcitypieces$endcitypiece.placeSettings, BlockPos.ZERO);
        endcitypieces$endcitypiece.move(blockpos.getX(), blockpos.getY(), blockpos.getZ());
        return endcitypieces$endcitypiece;
    }

    public static void startHouseTower(StructureManager pStructureManager, BlockPos pPos, Rotation pRotation, List<StructurePiece> pPieces, Random pRandom) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        EndCityPiece endcitypieces$endcitypiece = EndCityPieces.addHelper(pPieces, new EndCityPiece(pStructureManager, "base_floor", pPos, pRotation, true));
        endcitypieces$endcitypiece = EndCityPieces.addHelper(pPieces, EndCityPieces.addPiece(pStructureManager, endcitypieces$endcitypiece, new BlockPos(-1, 0, -1), "second_floor_1", pRotation, false));
        endcitypieces$endcitypiece = EndCityPieces.addHelper(pPieces, EndCityPieces.addPiece(pStructureManager, endcitypieces$endcitypiece, new BlockPos(-1, 4, -1), "third_floor_1", pRotation, false));
        endcitypieces$endcitypiece = EndCityPieces.addHelper(pPieces, EndCityPieces.addPiece(pStructureManager, endcitypieces$endcitypiece, new BlockPos(-1, 8, -1), "third_roof", pRotation, true));
        EndCityPieces.recursiveChildren(pStructureManager, TOWER_GENERATOR, 1, endcitypieces$endcitypiece, null, pPieces, pRandom);
    }

    static EndCityPiece addHelper(List<StructurePiece> pPieces, EndCityPiece pPiece) {
        pPieces.add(pPiece);
        return pPiece;
    }

    static boolean recursiveChildren(StructureManager pStructureManager, SectionGenerator pSectionGenerator, int pCounter, EndCityPiece pPiece, BlockPos pStartPos, List<StructurePiece> pPieces, Random pRandom) {
        if (pCounter > 8) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        if (pSectionGenerator.generate(pStructureManager, pCounter, pPiece, pStartPos, list, pRandom)) {
            boolean flag = false;
            int i = pRandom.nextInt();
            for (StructurePiece structurepiece : list) {
                structurepiece.genDepth = i;
                StructurePiece structurepiece1 = StructurePiece.findCollisionPiece(pPieces, structurepiece.getBoundingBox());
                if (structurepiece1 == null || structurepiece1.genDepth == pPiece.genDepth) continue;
                flag = true;
                break;
            }
            if (!flag) {
                pPieces.addAll(list);
                return true;
            }
        }
        return false;
    }

    public static class EndCityPiece
    extends TemplateStructurePiece {
        public EndCityPiece(StructureManager p_71199_, String p_71200_, BlockPos p_71201_, Rotation p_71202_, boolean p_71203_) {
            super(StructurePieceType.END_CITY_PIECE, 0, p_71199_, EndCityPiece.makeResourceLocation(p_71200_), p_71200_, EndCityPiece.makeSettings(p_71203_, p_71202_), p_71201_);
        }

        public EndCityPiece(StructureManager p_191992_, CompoundTag p_191993_) {
            super(StructurePieceType.END_CITY_PIECE, p_191993_, p_191992_, p_162428_ -> EndCityPiece.makeSettings(p_191993_.getBoolean("OW"), Rotation.valueOf(p_191993_.getString("Rot"))));
        }

        private static StructurePlaceSettings makeSettings(boolean p_162430_, Rotation p_162431_) {
            BlockIgnoreProcessor blockignoreprocessor = p_162430_ ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
            return new StructurePlaceSettings().setIgnoreEntities(true).addProcessor(blockignoreprocessor).setRotation(p_162431_);
        }

        @Override
        protected ResourceLocation makeTemplateLocation() {
            return EndCityPiece.makeResourceLocation(this.templateName);
        }

        private static ResourceLocation makeResourceLocation(String pName) {
            return new ResourceLocation("end_city/" + pName);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_191995_, CompoundTag p_191996_) {
            super.addAdditionalSaveData(p_191995_, p_191996_);
            p_191996_.putString("Rot", this.placeSettings.getRotation().name());
            p_191996_.putBoolean("OW", this.placeSettings.getProcessors().get(0) == BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        @Override
        protected void handleDataMarker(String pMarker, BlockPos pPos, ServerLevelAccessor pLevel, Random pRandom, BoundingBox pBox) {
            if (pMarker.startsWith("Chest")) {
                BlockPos blockpos = pPos.below();
                if (pBox.isInside(blockpos)) {
                    RandomizableContainerBlockEntity.setLootTable(pLevel, pRandom, blockpos, BuiltInLootTables.END_CITY_TREASURE);
                }
            } else if (pBox.isInside(pPos) && Level.isInSpawnableBounds(pPos)) {
                if (pMarker.startsWith("Sentry")) {
                    Shulker shulker = EntityType.SHULKER.create(pLevel.getLevel());
                    shulker.setPos((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5);
                    pLevel.addFreshEntity(shulker);
                } else if (pMarker.startsWith("Elytra")) {
                    ItemFrame itemframe = new ItemFrame(pLevel.getLevel(), pPos, this.placeSettings.getRotation().rotate(Direction.SOUTH));
                    itemframe.setItem(new ItemStack(Items.ELYTRA), false);
                    pLevel.addFreshEntity(itemframe);
                }
            }
        }
    }

    static interface SectionGenerator {
        public void init();

        public boolean generate(StructureManager var1, int var2, EndCityPiece var3, BlockPos var4, List<StructurePiece> var5, Random var6);
    }
}

