/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.OceanRuinConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.OceanRuinFeature;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class OceanRuinPieces {
    private static final ResourceLocation[] WARM_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/warm_1"), new ResourceLocation("underwater_ruin/warm_2"), new ResourceLocation("underwater_ruin/warm_3"), new ResourceLocation("underwater_ruin/warm_4"), new ResourceLocation("underwater_ruin/warm_5"), new ResourceLocation("underwater_ruin/warm_6"), new ResourceLocation("underwater_ruin/warm_7"), new ResourceLocation("underwater_ruin/warm_8")};
    private static final ResourceLocation[] RUINS_BRICK = new ResourceLocation[]{new ResourceLocation("underwater_ruin/brick_1"), new ResourceLocation("underwater_ruin/brick_2"), new ResourceLocation("underwater_ruin/brick_3"), new ResourceLocation("underwater_ruin/brick_4"), new ResourceLocation("underwater_ruin/brick_5"), new ResourceLocation("underwater_ruin/brick_6"), new ResourceLocation("underwater_ruin/brick_7"), new ResourceLocation("underwater_ruin/brick_8")};
    private static final ResourceLocation[] RUINS_CRACKED = new ResourceLocation[]{new ResourceLocation("underwater_ruin/cracked_1"), new ResourceLocation("underwater_ruin/cracked_2"), new ResourceLocation("underwater_ruin/cracked_3"), new ResourceLocation("underwater_ruin/cracked_4"), new ResourceLocation("underwater_ruin/cracked_5"), new ResourceLocation("underwater_ruin/cracked_6"), new ResourceLocation("underwater_ruin/cracked_7"), new ResourceLocation("underwater_ruin/cracked_8")};
    private static final ResourceLocation[] RUINS_MOSSY = new ResourceLocation[]{new ResourceLocation("underwater_ruin/mossy_1"), new ResourceLocation("underwater_ruin/mossy_2"), new ResourceLocation("underwater_ruin/mossy_3"), new ResourceLocation("underwater_ruin/mossy_4"), new ResourceLocation("underwater_ruin/mossy_5"), new ResourceLocation("underwater_ruin/mossy_6"), new ResourceLocation("underwater_ruin/mossy_7"), new ResourceLocation("underwater_ruin/mossy_8")};
    private static final ResourceLocation[] BIG_RUINS_BRICK = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_brick_1"), new ResourceLocation("underwater_ruin/big_brick_2"), new ResourceLocation("underwater_ruin/big_brick_3"), new ResourceLocation("underwater_ruin/big_brick_8")};
    private static final ResourceLocation[] BIG_RUINS_MOSSY = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_mossy_1"), new ResourceLocation("underwater_ruin/big_mossy_2"), new ResourceLocation("underwater_ruin/big_mossy_3"), new ResourceLocation("underwater_ruin/big_mossy_8")};
    private static final ResourceLocation[] BIG_RUINS_CRACKED = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_cracked_1"), new ResourceLocation("underwater_ruin/big_cracked_2"), new ResourceLocation("underwater_ruin/big_cracked_3"), new ResourceLocation("underwater_ruin/big_cracked_8")};
    private static final ResourceLocation[] BIG_WARM_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_warm_4"), new ResourceLocation("underwater_ruin/big_warm_5"), new ResourceLocation("underwater_ruin/big_warm_6"), new ResourceLocation("underwater_ruin/big_warm_7")};

    private static ResourceLocation getSmallWarmRuin(Random pRandom) {
        return Util.a(WARM_RUINS, pRandom);
    }

    private static ResourceLocation getBigWarmRuin(Random pRandom) {
        return Util.a(BIG_WARM_RUINS, pRandom);
    }

    public static void addPieces(StructureManager pStructureManager, BlockPos pPos, Rotation pRotation, StructurePieceAccessor pPieces, Random pRandom, OceanRuinConfiguration pConfig) {
        boolean flag = pRandom.nextFloat() <= pConfig.largeProbability;
        float f = flag ? 0.9f : 0.8f;
        OceanRuinPieces.addPiece(pStructureManager, pPos, pRotation, pPieces, pRandom, pConfig, flag, f);
        if (flag && pRandom.nextFloat() <= pConfig.clusterProbability) {
            OceanRuinPieces.addClusterRuins(pStructureManager, pRandom, pRotation, pPos, pConfig, pPieces);
        }
    }

    private static void addClusterRuins(StructureManager pStructureManager, Random pRandom, Rotation pRotation, BlockPos pPos, OceanRuinConfiguration pConfig, StructurePieceAccessor pPieces) {
        BlockPos blockpos = new BlockPos(pPos.getX(), 90, pPos.getZ());
        BlockPos blockpos1 = StructureTemplate.transform(new BlockPos(15, 0, 15), Mirror.NONE, pRotation, BlockPos.ZERO).offset(blockpos);
        BoundingBox boundingbox = BoundingBox.fromCorners(blockpos, blockpos1);
        BlockPos blockpos2 = new BlockPos(Math.min(blockpos.getX(), blockpos1.getX()), blockpos.getY(), Math.min(blockpos.getZ(), blockpos1.getZ()));
        List<BlockPos> list = OceanRuinPieces.allPositions(pRandom, blockpos2);
        int i = Mth.nextInt(pRandom, 4, 8);
        int j = 0;
        while (j < i) {
            Rotation rotation;
            BlockPos blockpos4;
            int k;
            BlockPos blockpos3;
            BoundingBox boundingbox1;
            if (!list.isEmpty() && !(boundingbox1 = BoundingBox.fromCorners(blockpos3 = list.remove(k = pRandom.nextInt(list.size())), blockpos4 = StructureTemplate.transform(new BlockPos(5, 0, 6), Mirror.NONE, rotation = Rotation.getRandom(pRandom), BlockPos.ZERO).offset(blockpos3))).intersects(boundingbox)) {
                OceanRuinPieces.addPiece(pStructureManager, blockpos3, rotation, pPieces, pRandom, pConfig, false, 0.8f);
            }
            ++j;
        }
    }

    private static List<BlockPos> allPositions(Random pRandom, BlockPos pPos) {
        ArrayList list = Lists.newArrayList();
        list.add(pPos.offset(-16 + Mth.nextInt(pRandom, 1, 8), 0, 16 + Mth.nextInt(pRandom, 1, 7)));
        list.add(pPos.offset(-16 + Mth.nextInt(pRandom, 1, 8), 0, Mth.nextInt(pRandom, 1, 7)));
        list.add(pPos.offset(-16 + Mth.nextInt(pRandom, 1, 8), 0, -16 + Mth.nextInt(pRandom, 4, 8)));
        list.add(pPos.offset(Mth.nextInt(pRandom, 1, 7), 0, 16 + Mth.nextInt(pRandom, 1, 7)));
        list.add(pPos.offset(Mth.nextInt(pRandom, 1, 7), 0, -16 + Mth.nextInt(pRandom, 4, 6)));
        list.add(pPos.offset(16 + Mth.nextInt(pRandom, 1, 7), 0, 16 + Mth.nextInt(pRandom, 3, 8)));
        list.add(pPos.offset(16 + Mth.nextInt(pRandom, 1, 7), 0, Mth.nextInt(pRandom, 1, 7)));
        list.add(pPos.offset(16 + Mth.nextInt(pRandom, 1, 7), 0, -16 + Mth.nextInt(pRandom, 4, 8)));
        return list;
    }

    private static void addPiece(StructureManager pStructureManager, BlockPos pPos, Rotation pRotation, StructurePieceAccessor pPieces, Random pRandom, OceanRuinConfiguration pConfig, boolean pIsLarge, float pIntegrity) {
        switch (pConfig.biomeTemp) {
            default: {
                ResourceLocation resourcelocation = pIsLarge ? OceanRuinPieces.getBigWarmRuin(pRandom) : OceanRuinPieces.getSmallWarmRuin(pRandom);
                pPieces.addPiece(new OceanRuinPiece(pStructureManager, resourcelocation, pPos, pRotation, pIntegrity, pConfig.biomeTemp, pIsLarge));
                break;
            }
            case COLD: {
                ResourceLocation[] aresourcelocation = pIsLarge ? BIG_RUINS_BRICK : RUINS_BRICK;
                ResourceLocation[] aresourcelocation1 = pIsLarge ? BIG_RUINS_CRACKED : RUINS_CRACKED;
                ResourceLocation[] aresourcelocation2 = pIsLarge ? BIG_RUINS_MOSSY : RUINS_MOSSY;
                int i = pRandom.nextInt(aresourcelocation.length);
                pPieces.addPiece(new OceanRuinPiece(pStructureManager, aresourcelocation[i], pPos, pRotation, pIntegrity, pConfig.biomeTemp, pIsLarge));
                pPieces.addPiece(new OceanRuinPiece(pStructureManager, aresourcelocation1[i], pPos, pRotation, 0.7f, pConfig.biomeTemp, pIsLarge));
                pPieces.addPiece(new OceanRuinPiece(pStructureManager, aresourcelocation2[i], pPos, pRotation, 0.5f, pConfig.biomeTemp, pIsLarge));
            }
        }
    }

    public static class OceanRuinPiece
    extends TemplateStructurePiece {
        private final OceanRuinFeature.Type biomeType;
        private final float integrity;
        private final boolean isLarge;

        public OceanRuinPiece(StructureManager pStructureManager, ResourceLocation pLocation, BlockPos pPos, Rotation pRotation, float pIntegrity, OceanRuinFeature.Type pBiomeType, boolean pIsLarge) {
            super(StructurePieceType.OCEAN_RUIN, 0, pStructureManager, pLocation, pLocation.toString(), OceanRuinPiece.makeSettings(pRotation), pPos);
            this.integrity = pIntegrity;
            this.biomeType = pBiomeType;
            this.isLarge = pIsLarge;
        }

        public OceanRuinPiece(StructureManager p_192392_, CompoundTag p_192393_) {
            super(StructurePieceType.OCEAN_RUIN, p_192393_, p_192392_, p_163116_ -> OceanRuinPiece.makeSettings(Rotation.valueOf(p_192393_.getString("Rot"))));
            this.integrity = p_192393_.getFloat("Integrity");
            this.biomeType = OceanRuinFeature.Type.valueOf(p_192393_.getString("BiomeType"));
            this.isLarge = p_192393_.getBoolean("IsLarge");
        }

        private static StructurePlaceSettings makeSettings(Rotation pRotation) {
            return new StructurePlaceSettings().setRotation(pRotation).setMirror(Mirror.NONE).addProcessor(BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192403_, CompoundTag p_192404_) {
            super.addAdditionalSaveData(p_192403_, p_192404_);
            p_192404_.putString("Rot", this.placeSettings.getRotation().name());
            p_192404_.putFloat("Integrity", this.integrity);
            p_192404_.putString("BiomeType", this.biomeType.toString());
            p_192404_.putBoolean("IsLarge", this.isLarge);
        }

        @Override
        protected void handleDataMarker(String pMarker, BlockPos pPos, ServerLevelAccessor pLevel, Random pRandom, BoundingBox pBox) {
            if ("chest".equals(pMarker)) {
                pLevel.setBlock(pPos, (BlockState)Blocks.CHEST.defaultBlockState().setValue(ChestBlock.WATERLOGGED, pLevel.getFluidState(pPos).is(FluidTags.WATER)), 2);
                BlockEntity blockentity = pLevel.getBlockEntity(pPos);
                if (blockentity instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)blockentity).setLootTable(this.isLarge ? BuiltInLootTables.UNDERWATER_RUIN_BIG : BuiltInLootTables.UNDERWATER_RUIN_SMALL, pRandom.nextLong());
                }
            } else if ("drowned".equals(pMarker)) {
                Drowned drowned = EntityType.DROWNED.create(pLevel.getLevel());
                drowned.setPersistenceRequired();
                drowned.moveTo(pPos, 0.0f, 0.0f);
                drowned.finalizeSpawn(pLevel, pLevel.getCurrentDifficultyAt(pPos), MobSpawnType.STRUCTURE, null, null);
                pLevel.addFreshEntityWithPassengers(drowned);
                if (pPos.getY() > pLevel.getSeaLevel()) {
                    pLevel.setBlock(pPos, Blocks.AIR.defaultBlockState(), 2);
                } else {
                    pLevel.setBlock(pPos, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }

        @Override
        public void postProcess(WorldGenLevel p_192395_, StructureFeatureManager p_192396_, ChunkGenerator p_192397_, Random p_192398_, BoundingBox p_192399_, ChunkPos p_192400_, BlockPos p_192401_) {
            this.placeSettings.clearProcessors().addProcessor(new BlockRotProcessor(this.integrity)).addProcessor(BlockIgnoreProcessor.STRUCTURE_AND_AIR);
            int i = p_192395_.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = new BlockPos(this.templatePosition.getX(), i, this.templatePosition.getZ());
            BlockPos blockpos = StructureTemplate.transform(new BlockPos(this.template.getSize().getX() - 1, 0, this.template.getSize().getZ() - 1), Mirror.NONE, this.placeSettings.getRotation(), BlockPos.ZERO).offset(this.templatePosition);
            this.templatePosition = new BlockPos(this.templatePosition.getX(), this.getHeight(this.templatePosition, p_192395_, blockpos), this.templatePosition.getZ());
            super.postProcess(p_192395_, p_192396_, p_192397_, p_192398_, p_192399_, p_192400_, p_192401_);
        }

        private int getHeight(BlockPos pTemplatePos, BlockGetter pLevel, BlockPos pPos) {
            int i = pTemplatePos.getY();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (BlockPos blockpos : BlockPos.betweenClosed(pTemplatePos, pPos)) {
                int i1 = blockpos.getX();
                int j1 = blockpos.getZ();
                int k1 = pTemplatePos.getY() - 1;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i1, k1, j1);
                BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos);
                FluidState fluidstate = pLevel.getFluidState(blockpos$mutableblockpos);
                while ((blockstate.isAir() || fluidstate.is(FluidTags.WATER) || blockstate.is(BlockTags.ICE)) && k1 > pLevel.getMinBuildHeight() + 1) {
                    blockpos$mutableblockpos.set(i1, --k1, j1);
                    blockstate = pLevel.getBlockState(blockpos$mutableblockpos);
                    fluidstate = pLevel.getFluidState(blockpos$mutableblockpos);
                }
                j = Math.min(j, k1);
                if (k1 >= k - 2) continue;
                ++l;
            }
            int l1 = Math.abs(pTemplatePos.getX() - pPos.getX());
            if (k - j > 2 && l > l1 - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

