/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PROBABILITY_OF_GOLD_GONE = 0.3f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_NETHERRACK = 0.07f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_LAVA = 0.2f;
    private static final float DEFAULT_MOSSINESS = 0.2f;
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public RuinedPortalPiece(StructureManager pStructureManager, BlockPos pTemplatePosition, VerticalPlacement pVerticalPlacement, Properties pProperties, ResourceLocation pLocation, StructureTemplate pTemplate, Rotation pRotation, Mirror pMirror, BlockPos pPivotPos) {
        super(StructurePieceType.RUINED_PORTAL, 0, pStructureManager, pLocation, pLocation.toString(), RuinedPortalPiece.makeSettings(pMirror, pRotation, pVerticalPlacement, pPivotPos, pProperties), pTemplatePosition);
        this.verticalPlacement = pVerticalPlacement;
        this.properties = pProperties;
    }

    public RuinedPortalPiece(StructureManager p_192446_, CompoundTag p_192447_) {
        super(StructurePieceType.RUINED_PORTAL, p_192447_, p_192446_, p_192466_ -> RuinedPortalPiece.makeSettings(p_192446_, p_192447_, p_192466_));
        this.verticalPlacement = VerticalPlacement.byName(p_192447_.getString("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_192447_.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext p_192457_, CompoundTag p_192458_) {
        super.addAdditionalSaveData(p_192457_, p_192458_);
        p_192458_.putString("Rotation", this.placeSettings.getRotation().name());
        p_192458_.putString("Mirror", this.placeSettings.getMirror().name());
        p_192458_.putString("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_163169_ -> p_192458_.put("Properties", (Tag)p_163169_));
    }

    private static StructurePlaceSettings makeSettings(StructureManager p_192460_, CompoundTag p_192461_, ResourceLocation p_192462_) {
        StructureTemplate structuretemplate = p_192460_.getOrCreate(p_192462_);
        BlockPos blockpos = new BlockPos(structuretemplate.getSize().getX() / 2, 0, structuretemplate.getSize().getZ() / 2);
        return RuinedPortalPiece.makeSettings(Mirror.valueOf(p_192461_.getString("Mirror")), Rotation.valueOf(p_192461_.getString("Rotation")), VerticalPlacement.byName(p_192461_.getString("VerticalPlacement")), blockpos, (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_192461_.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    private static StructurePlaceSettings makeSettings(Mirror pMirror, Rotation pRotation, VerticalPlacement pPlacement, BlockPos pPivotPos, Properties pProperties) {
        BlockIgnoreProcessor blockignoreprocessor = pProperties.airPocket ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
        ArrayList list = Lists.newArrayList();
        list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.GOLD_BLOCK, 0.3f, Blocks.AIR));
        list.add(RuinedPortalPiece.getLavaProcessorRule(pPlacement, pProperties));
        if (!pProperties.cold) {
            list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.NETHERRACK, 0.07f, Blocks.MAGMA_BLOCK));
        }
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setRotation(pRotation).setMirror(pMirror).setRotationPivot(pPivotPos).addProcessor(blockignoreprocessor).addProcessor(new RuleProcessor(list)).addProcessor(new BlockAgeProcessor(pProperties.mossiness)).addProcessor(new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)).addProcessor(new LavaSubmergedBlockProcessor());
        if (pProperties.replaceWithBlackstone) {
            structureplacesettings.addProcessor(BlackstoneReplaceProcessor.INSTANCE);
        }
        return structureplacesettings;
    }

    private static ProcessorRule getLavaProcessorRule(VerticalPlacement pPlacement, Properties pProperties) {
        if (pPlacement == VerticalPlacement.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.MAGMA_BLOCK);
        }
        return pProperties.cold ? RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.NETHERRACK) : RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, 0.2f, Blocks.MAGMA_BLOCK);
    }

    @Override
    public void postProcess(WorldGenLevel p_192449_, StructureFeatureManager p_192450_, ChunkGenerator p_192451_, Random p_192452_, BoundingBox p_192453_, ChunkPos p_192454_, BlockPos p_192455_) {
        BoundingBox boundingbox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (p_192453_.isInside(boundingbox.getCenter())) {
            p_192453_.encapsulate(boundingbox);
            super.postProcess(p_192449_, p_192450_, p_192451_, p_192452_, p_192453_, p_192454_, p_192455_);
            this.spreadNetherrack(p_192452_, p_192449_);
            this.addNetherrackDripColumnsBelowPortal(p_192452_, p_192449_);
            if (this.properties.vines || this.properties.overgrown) {
                BlockPos.betweenClosedStream(this.getBoundingBox()).forEach(p_163166_ -> {
                    if (this.properties.vines) {
                        this.maybeAddVines(p_192452_, p_192449_, (BlockPos)p_163166_);
                    }
                    if (this.properties.overgrown) {
                        this.maybeAddLeavesAbove(p_192452_, p_192449_, (BlockPos)p_163166_);
                    }
                });
            }
        }
    }

    @Override
    protected void handleDataMarker(String pMarker, BlockPos pPos, ServerLevelAccessor pLevel, Random pRandom, BoundingBox pBox) {
    }

    private void maybeAddVines(Random pRandom, LevelAccessor pLevel, BlockPos pPos) {
        Direction direction;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (!blockstate.isAir() && !blockstate.is(Blocks.VINE) && (blockstate1 = pLevel.getBlockState(blockpos = pPos.relative(direction = RuinedPortalPiece.getRandomHorizontalDirection(pRandom)))).isAir() && Block.isFaceFull(blockstate.getCollisionShape(pLevel, pPos), direction)) {
            BooleanProperty booleanproperty = VineBlock.getPropertyForFace(direction.getOpposite());
            pLevel.setBlock(blockpos, (BlockState)Blocks.VINE.defaultBlockState().setValue(booleanproperty, true), 3);
        }
    }

    private void maybeAddLeavesAbove(Random pRandom, LevelAccessor pLevel, BlockPos pPos) {
        if (pRandom.nextFloat() < 0.5f && pLevel.getBlockState(pPos).is(Blocks.NETHERRACK) && pLevel.getBlockState(pPos.above()).isAir()) {
            pLevel.setBlock(pPos.above(), (BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue(LeavesBlock.PERSISTENT, true), 3);
        }
    }

    private void addNetherrackDripColumnsBelowPortal(Random pRandom, LevelAccessor pLevel) {
        int i = this.boundingBox.minX() + 1;
        while (i < this.boundingBox.maxX()) {
            int j = this.boundingBox.minZ() + 1;
            while (j < this.boundingBox.maxZ()) {
                BlockPos blockpos = new BlockPos(i, this.boundingBox.minY(), j);
                if (pLevel.getBlockState(blockpos).is(Blocks.NETHERRACK)) {
                    this.addNetherrackDripColumn(pRandom, pLevel, blockpos.below());
                }
                ++j;
            }
            ++i;
        }
    }

    private void addNetherrackDripColumn(Random pRandom, LevelAccessor pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        this.placeNetherrackOrMagma(pRandom, pLevel, blockpos$mutableblockpos);
        int i = 8;
        while (i > 0 && pRandom.nextFloat() < 0.5f) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            --i;
            this.placeNetherrackOrMagma(pRandom, pLevel, blockpos$mutableblockpos);
        }
    }

    private void spreadNetherrack(Random pRandom, LevelAccessor pLevel) {
        boolean flag = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos blockpos = this.boundingBox.getCenter();
        int i = blockpos.getX();
        int j = blockpos.getZ();
        float[] afloat = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = afloat.length;
        int l = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int i1 = pRandom.nextInt(Math.max(1, 8 - l / 2));
        int j1 = 3;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = BlockPos.ZERO.mutable();
        int k1 = i - k;
        while (k1 <= i + k) {
            int l1 = j - k;
            while (l1 <= j + k) {
                int i2 = Math.abs(k1 - i) + Math.abs(l1 - j);
                int j2 = Math.max(0, i2 + i1);
                if (j2 < k) {
                    float f = afloat[j2];
                    if (pRandom.nextDouble() < (double)f) {
                        int k2 = RuinedPortalPiece.getSurfaceY(pLevel, k1, l1, this.verticalPlacement);
                        int l2 = flag ? k2 : Math.min(this.boundingBox.minY(), k2);
                        blockpos$mutableblockpos.set(k1, l2, l1);
                        if (Math.abs(l2 - this.boundingBox.minY()) <= 3 && this.canBlockBeReplacedByNetherrackOrMagma(pLevel, blockpos$mutableblockpos)) {
                            this.placeNetherrackOrMagma(pRandom, pLevel, blockpos$mutableblockpos);
                            if (this.properties.overgrown) {
                                this.maybeAddLeavesAbove(pRandom, pLevel, blockpos$mutableblockpos);
                            }
                            this.addNetherrackDripColumn(pRandom, pLevel, blockpos$mutableblockpos.below());
                        }
                    }
                }
                ++l1;
            }
            ++k1;
        }
    }

    private boolean canBlockBeReplacedByNetherrackOrMagma(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        return !blockstate.is(Blocks.AIR) && !blockstate.is(Blocks.OBSIDIAN) && !blockstate.is(BlockTags.FEATURES_CANNOT_REPLACE) && (this.verticalPlacement == VerticalPlacement.IN_NETHER || !blockstate.is(Blocks.LAVA));
    }

    private void placeNetherrackOrMagma(Random pRandom, LevelAccessor pLevel, BlockPos pPos) {
        if (!this.properties.cold && pRandom.nextFloat() < 0.07f) {
            pLevel.setBlock(pPos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else {
            pLevel.setBlock(pPos, Blocks.NETHERRACK.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor pLevel, int pX, int pZ, VerticalPlacement pPlacement) {
        return pLevel.getHeight(RuinedPortalPiece.getHeightMapType(pPlacement), pX, pZ) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement pPlacement) {
        return pPlacement == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
    }

    private static ProcessorRule getBlockReplaceRule(Block pBlock, float pProbability, Block pReplaceBlock) {
        return new ProcessorRule(new RandomBlockMatchTest(pBlock, pProbability), AlwaysTrueTest.INSTANCE, pReplaceBlock.defaultBlockState());
    }

    private static ProcessorRule getBlockReplaceRule(Block pBlock, Block pReplaceBlock) {
        return new ProcessorRule(new BlockMatchTest(pBlock), AlwaysTrueTest.INSTANCE, pReplaceBlock.defaultBlockState());
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(p_72752_ -> p_72752_.group((App)Codec.BOOL.fieldOf("cold").forGetter(p_163185_ -> p_163185_.cold), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(p_163183_ -> Float.valueOf(p_163183_.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(p_163181_ -> p_163181_.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(p_163179_ -> p_163179_.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(p_163177_ -> p_163177_.vines), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(p_163175_ -> p_163175_.replaceWithBlackstone)).apply((Applicative)p_72752_, Properties::new));
        public boolean cold;
        public float mossiness = 0.2f;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithBlackstone;

        public Properties() {
        }

        public Properties(boolean p_72745_, float p_72746_, boolean p_72747_, boolean p_72748_, boolean p_72749_, boolean p_72750_) {
            this.cold = p_72745_;
            this.mossiness = p_72746_;
            this.airPocket = p_72747_;
            this.overgrown = p_72748_;
            this.vines = p_72749_;
            this.replaceWithBlackstone = p_72750_;
        }
    }

    public static enum VerticalPlacement {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor"),
        IN_MOUNTAIN("in_mountain"),
        UNDERGROUND("underground"),
        IN_NETHER("in_nether");

        private static final Map<String, VerticalPlacement> BY_NAME;
        private final String name;

        static {
            BY_NAME = Arrays.stream(VerticalPlacement.values()).collect(Collectors.toMap(VerticalPlacement::getName, p_72781_ -> p_72781_));
        }

        private VerticalPlacement(String p_72778_) {
            this.name = p_72778_;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String pName) {
            return BY_NAME.get(pName);
        }
    }
}

