/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class ScatteredFeaturePiece
extends StructurePiece {
    protected final int width;
    protected final int height;
    protected final int depth;
    protected int heightPosition = -1;

    protected ScatteredFeaturePiece(StructurePieceType pType, int pX, int pY, int pZ, int pWidth, int pHeight, int pDepth, Direction pOrientation) {
        super(pType, 0, StructurePiece.makeBoundingBox(pX, pY, pZ, pOrientation, pWidth, pHeight, pDepth));
        this.width = pWidth;
        this.height = pHeight;
        this.depth = pDepth;
        this.setOrientation(pOrientation);
    }

    protected ScatteredFeaturePiece(StructurePieceType p_209929_, CompoundTag p_209930_) {
        super(p_209929_, p_209930_);
        this.width = p_209930_.getInt("Width");
        this.height = p_209930_.getInt("Height");
        this.depth = p_209930_.getInt("Depth");
        this.heightPosition = p_209930_.getInt("HPos");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext p_192471_, CompoundTag p_192472_) {
        p_192472_.putInt("Width", this.width);
        p_192472_.putInt("Height", this.height);
        p_192472_.putInt("Depth", this.depth);
        p_192472_.putInt("HPos", this.heightPosition);
    }

    protected boolean updateAverageGroundHeight(LevelAccessor pLevel, BoundingBox pBounds, int pHeight) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = this.boundingBox.minZ();
        while (k <= this.boundingBox.maxZ()) {
            int l = this.boundingBox.minX();
            while (l <= this.boundingBox.maxX()) {
                blockpos$mutableblockpos.set(l, 64, k);
                if (pBounds.isInside(blockpos$mutableblockpos)) {
                    i += pLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockpos$mutableblockpos).getY();
                    ++j;
                }
                ++l;
            }
            ++k;
        }
        if (j == 0) {
            return false;
        }
        this.heightPosition = i / j;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + pHeight, 0);
        return true;
    }

    protected boolean updateHeightPositionToLowestGroundHeight(LevelAccessor p_192468_, int p_192469_) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int i = p_192468_.getMaxBuildHeight();
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = this.boundingBox.minZ();
        while (j <= this.boundingBox.maxZ()) {
            int k = this.boundingBox.minX();
            while (k <= this.boundingBox.maxX()) {
                blockpos$mutableblockpos.set(k, 0, j);
                i = Math.min(i, p_192468_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockpos$mutableblockpos).getY());
                flag = true;
                ++k;
            }
            ++j;
        }
        if (!flag) {
            return false;
        }
        this.heightPosition = i;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + p_192469_, 0);
        return true;
    }
}

