/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class StrongholdPieces {
    private static final int SMALL_DOOR_WIDTH = 3;
    private static final int SMALL_DOOR_HEIGHT = 3;
    private static final int MAX_DEPTH = 50;
    private static final int LOWEST_Y_POSITION = 10;
    private static final boolean CHECK_AIR = true;
    public static final int MAGIC_START_Y = 64;
    private static final PieceWeight[] STRONGHOLD_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(PrisonHall.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StraightStairsDown.class, 5, 5), new PieceWeight(StairsDown.class, 5, 5), new PieceWeight(FiveCrossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean doPlace(int p_72903_) {
            return super.doPlace(p_72903_) && p_72903_ > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean doPlace(int p_72909_) {
            return super.doPlace(p_72909_) && p_72909_ > 5;
        }
    }};
    private static List<PieceWeight> currentPieces;
    static Class<? extends StrongholdPiece> imposedPiece;
    private static int totalWeight;
    static final SmoothStoneSelector SMOOTH_STONE_SELECTOR;

    static {
        SMOOTH_STONE_SELECTOR = new SmoothStoneSelector();
    }

    public static void resetPieces() {
        currentPieces = Lists.newArrayList();
        PieceWeight[] pieceWeightArray = STRONGHOLD_PIECE_WEIGHTS;
        int n = STRONGHOLD_PIECE_WEIGHTS.length;
        int n2 = 0;
        while (n2 < n) {
            PieceWeight strongholdpieces$pieceweight = pieceWeightArray[n2];
            strongholdpieces$pieceweight.placeCount = 0;
            currentPieces.add(strongholdpieces$pieceweight);
            ++n2;
        }
        imposedPiece = null;
    }

    private static boolean updatePieceWeight() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight strongholdpieces$pieceweight : currentPieces) {
            if (strongholdpieces$pieceweight.maxPlaceCount > 0 && strongholdpieces$pieceweight.placeCount < strongholdpieces$pieceweight.maxPlaceCount) {
                flag = true;
            }
            totalWeight += strongholdpieces$pieceweight.weight;
        }
        return flag;
    }

    private static StrongholdPiece findAndCreatePieceFactory(Class<? extends StrongholdPiece> pPieceClass, StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, @Nullable Direction pDirection, int pGenDepth) {
        StrongholdPiece strongholdpieces$strongholdpiece = null;
        if (pPieceClass == Straight.class) {
            strongholdpieces$strongholdpiece = Straight.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == PrisonHall.class) {
            strongholdpieces$strongholdpiece = PrisonHall.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == LeftTurn.class) {
            strongholdpieces$strongholdpiece = LeftTurn.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == RightTurn.class) {
            strongholdpieces$strongholdpiece = RightTurn.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == RoomCrossing.class) {
            strongholdpieces$strongholdpiece = RoomCrossing.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == StraightStairsDown.class) {
            strongholdpieces$strongholdpiece = StraightStairsDown.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == StairsDown.class) {
            strongholdpieces$strongholdpiece = StairsDown.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == FiveCrossing.class) {
            strongholdpieces$strongholdpiece = FiveCrossing.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == ChestCorridor.class) {
            strongholdpieces$strongholdpiece = ChestCorridor.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == Library.class) {
            strongholdpieces$strongholdpiece = Library.createPiece(pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
        } else if (pPieceClass == PortalRoom.class) {
            strongholdpieces$strongholdpiece = PortalRoom.createPiece(pPieces, pX, pY, pZ, pDirection, pGenDepth);
        }
        return strongholdpieces$strongholdpiece;
    }

    private static StrongholdPiece generatePieceFromSmallDoor(StartPiece pPiece, StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pDirection, int pGenDepth) {
        if (!StrongholdPieces.updatePieceWeight()) {
            return null;
        }
        if (imposedPiece != null) {
            StrongholdPiece strongholdpieces$strongholdpiece = StrongholdPieces.findAndCreatePieceFactory(imposedPiece, pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
            imposedPiece = null;
            if (strongholdpieces$strongholdpiece != null) {
                return strongholdpieces$strongholdpiece;
            }
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int i = pRandom.nextInt(totalWeight);
            for (PieceWeight strongholdpieces$pieceweight : currentPieces) {
                if ((i -= strongholdpieces$pieceweight.weight) >= 0) continue;
                if (!strongholdpieces$pieceweight.doPlace(pGenDepth) || strongholdpieces$pieceweight == pPiece.previousPiece) continue block0;
                StrongholdPiece strongholdpieces$strongholdpiece1 = StrongholdPieces.findAndCreatePieceFactory(strongholdpieces$pieceweight.pieceClass, pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth);
                if (strongholdpieces$strongholdpiece1 == null) continue;
                ++strongholdpieces$pieceweight.placeCount;
                pPiece.previousPiece = strongholdpieces$pieceweight;
                if (!strongholdpieces$pieceweight.isValid()) {
                    currentPieces.remove(strongholdpieces$pieceweight);
                }
                return strongholdpieces$strongholdpiece1;
            }
        }
        BoundingBox boundingbox = FillerCorridor.findPieceBox(pPieces, pRandom, pX, pY, pZ, pDirection);
        return boundingbox != null && boundingbox.minY() > 1 ? new FillerCorridor(pGenDepth, boundingbox, pDirection) : null;
    }

    static StructurePiece generateAndAddPiece(StartPiece pPiece, StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, @Nullable Direction pDirection, int pGenDepth) {
        if (pGenDepth > 50) {
            return null;
        }
        if (Math.abs(pX - pPiece.getBoundingBox().minX()) <= 112 && Math.abs(pZ - pPiece.getBoundingBox().minZ()) <= 112) {
            StrongholdPiece structurepiece = StrongholdPieces.generatePieceFromSmallDoor(pPiece, pPieces, pRandom, pX, pY, pZ, pDirection, pGenDepth + 1);
            if (structurepiece != null) {
                pPieces.addPiece(structurepiece);
                pPiece.pendingChildren.add(structurepiece);
            }
            return structurepiece;
        }
        return null;
    }

    public static class ChestCorridor
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private boolean hasPlacedChest;

        public ChestCorridor(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public ChestCorridor(CompoundTag p_192489_) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, p_192489_);
            this.hasPlacedChest = p_192489_.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192499_, CompoundTag p_192500_) {
            super.addAdditionalSaveData(p_192499_, p_192500_);
            p_192500_.putBoolean("Chest", this.hasPlacedChest);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 1, 1);
        }

        public static ChestCorridor createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, 7, pOrientation);
            return ChestCorridor.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new ChestCorridor(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192491_, StructureFeatureManager p_192492_, ChunkGenerator p_192493_, Random p_192494_, BoundingBox p_192495_, ChunkPos p_192496_, BlockPos p_192497_) {
            this.generateBox(p_192491_, p_192495_, 0, 0, 0, 4, 4, 6, true, p_192494_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192491_, p_192494_, p_192495_, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(p_192491_, p_192494_, p_192495_, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            this.generateBox(p_192491_, p_192495_, 3, 1, 2, 3, 1, 4, Blocks.STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), false);
            this.placeBlock(p_192491_, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 1, p_192495_);
            this.placeBlock(p_192491_, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 5, p_192495_);
            this.placeBlock(p_192491_, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 2, p_192495_);
            this.placeBlock(p_192491_, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 4, p_192495_);
            int i = 2;
            while (i <= 4) {
                this.placeBlock(p_192491_, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2, 1, i, p_192495_);
                ++i;
            }
            if (!this.hasPlacedChest && p_192495_.isInside(this.getWorldPos(3, 2, 3))) {
                this.hasPlacedChest = true;
                this.createChest(p_192491_, p_192495_, p_192494_, 3, 2, 3, BuiltInLootTables.STRONGHOLD_CORRIDOR);
            }
        }
    }

    public static class FillerCorridor
    extends StrongholdPiece {
        private final int steps;

        public FillerCorridor(int pGenDepth, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.steps = pOrientation != Direction.NORTH && pOrientation != Direction.SOUTH ? pBox.getXSpan() : pBox.getZSpan();
        }

        public FillerCorridor(CompoundTag p_192502_) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, p_192502_);
            this.steps = p_192502_.getInt("Steps");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192512_, CompoundTag p_192513_) {
            super.addAdditionalSaveData(p_192512_, p_192513_);
            p_192513_.putInt("Steps", this.steps);
        }

        public static BoundingBox findPieceBox(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation) {
            int i = 3;
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, 4, pOrientation);
            StructurePiece structurepiece = pPieces.findCollisionPiece(boundingbox);
            if (structurepiece == null) {
                return null;
            }
            if (structurepiece.getBoundingBox().minY() == boundingbox.minY()) {
                int j = 2;
                while (j >= 1) {
                    boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, j, pOrientation);
                    if (!structurepiece.getBoundingBox().intersects(boundingbox)) {
                        return BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, j + 1, pOrientation);
                    }
                    --j;
                }
            }
            return null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192504_, StructureFeatureManager p_192505_, ChunkGenerator p_192506_, Random p_192507_, BoundingBox p_192508_, ChunkPos p_192509_, BlockPos p_192510_) {
            int i = 0;
            while (i < this.steps) {
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 0, 0, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 0, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 0, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 0, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 4, 0, i, p_192508_);
                int j = 1;
                while (j <= 3) {
                    this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 0, j, i, p_192508_);
                    this.placeBlock(p_192504_, Blocks.CAVE_AIR.defaultBlockState(), 1, j, i, p_192508_);
                    this.placeBlock(p_192504_, Blocks.CAVE_AIR.defaultBlockState(), 2, j, i, p_192508_);
                    this.placeBlock(p_192504_, Blocks.CAVE_AIR.defaultBlockState(), 3, j, i, p_192508_);
                    this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 4, j, i, p_192508_);
                    ++j;
                }
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 0, 4, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 4, i, p_192508_);
                this.placeBlock(p_192504_, Blocks.STONE_BRICKS.defaultBlockState(), 4, 4, i, p_192508_);
                ++i;
            }
        }
    }

    public static class FiveCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 10;
        protected static final int HEIGHT = 9;
        protected static final int DEPTH = 11;
        private final boolean leftLow;
        private final boolean leftHigh;
        private final boolean rightLow;
        private final boolean rightHigh;

        public FiveCrossing(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
            this.leftLow = pRandom.nextBoolean();
            this.leftHigh = pRandom.nextBoolean();
            this.rightLow = pRandom.nextBoolean();
            this.rightHigh = pRandom.nextInt(3) > 0;
        }

        public FiveCrossing(CompoundTag p_192515_) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, p_192515_);
            this.leftLow = p_192515_.getBoolean("leftLow");
            this.leftHigh = p_192515_.getBoolean("leftHigh");
            this.rightLow = p_192515_.getBoolean("rightLow");
            this.rightHigh = p_192515_.getBoolean("rightHigh");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192525_, CompoundTag p_192526_) {
            super.addAdditionalSaveData(p_192525_, p_192526_);
            p_192526_.putBoolean("leftLow", this.leftLow);
            p_192526_.putBoolean("leftHigh", this.leftHigh);
            p_192526_.putBoolean("rightLow", this.rightLow);
            p_192526_.putBoolean("rightHigh", this.rightHigh);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            int i = 3;
            int j = 5;
            Direction direction = this.getOrientation();
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                i = 8 - i;
                j = 8 - j;
            }
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 5, 1);
            if (this.leftLow) {
                this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, i, 1);
            }
            if (this.leftHigh) {
                this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, j, 7);
            }
            if (this.rightLow) {
                this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, i, 1);
            }
            if (this.rightHigh) {
                this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, j, 7);
            }
        }

        public static FiveCrossing createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -4, -3, 0, 10, 9, 11, pOrientation);
            return FiveCrossing.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new FiveCrossing(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192517_, StructureFeatureManager p_192518_, ChunkGenerator p_192519_, Random p_192520_, BoundingBox p_192521_, ChunkPos p_192522_, BlockPos p_192523_) {
            this.generateBox(p_192517_, p_192521_, 0, 0, 0, 9, 8, 10, true, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192517_, p_192520_, p_192521_, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.generateBox(p_192517_, p_192521_, 0, 3, 1, 0, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightLow) {
                this.generateBox(p_192517_, p_192521_, 9, 3, 1, 9, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.leftHigh) {
                this.generateBox(p_192517_, p_192521_, 0, 5, 7, 0, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightHigh) {
                this.generateBox(p_192517_, p_192521_, 9, 5, 7, 9, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            this.generateBox(p_192517_, p_192521_, 5, 1, 10, 7, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(p_192517_, p_192521_, 1, 2, 1, 8, 2, 6, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 4, 1, 5, 4, 4, 9, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 8, 1, 5, 8, 4, 9, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 1, 4, 7, 3, 4, 9, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 1, 3, 5, 3, 3, 6, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 1, 3, 4, 3, 3, 4, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 1, 4, 6, 3, 4, 6, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 5, 1, 7, 7, 1, 8, false, p_192520_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192517_, p_192521_, 5, 1, 9, 7, 1, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 5, 2, 7, 7, 2, 7, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 4, 5, 7, 4, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 8, 5, 7, 8, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(p_192517_, p_192521_, 5, 5, 7, 7, 5, 9, (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), false);
            this.placeBlock(p_192517_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 6, 5, 6, p_192521_);
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public LeftTurn(CompoundTag p_192528_) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, p_192528_);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            Direction direction = this.getOrientation();
            if (direction != Direction.NORTH && direction != Direction.EAST) {
                this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, 1, 1);
            } else {
                this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, 1, 1);
            }
        }

        public static LeftTurn createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, 5, pOrientation);
            return LeftTurn.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new LeftTurn(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192530_, StructureFeatureManager p_192531_, ChunkGenerator p_192532_, Random p_192533_, BoundingBox p_192534_, ChunkPos p_192535_, BlockPos p_192536_) {
            this.generateBox(p_192530_, p_192534_, 0, 0, 0, 4, 4, 4, true, p_192533_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192530_, p_192533_, p_192534_, this.entryDoor, 1, 1, 0);
            Direction direction = this.getOrientation();
            if (direction != Direction.NORTH && direction != Direction.EAST) {
                this.generateBox(p_192530_, p_192534_, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(p_192530_, p_192534_, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class Library
    extends StrongholdPiece {
        protected static final int WIDTH = 14;
        protected static final int HEIGHT = 6;
        protected static final int TALL_HEIGHT = 11;
        protected static final int DEPTH = 15;
        private final boolean isTall;

        public Library(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
            this.isTall = pBox.getYSpan() > 6;
        }

        public Library(CompoundTag p_192538_) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, p_192538_);
            this.isTall = p_192538_.getBoolean("Tall");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192548_, CompoundTag p_192549_) {
            super.addAdditionalSaveData(p_192548_, p_192549_);
            p_192549_.putBoolean("Tall", this.isTall);
        }

        public static Library createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -4, -1, 0, 14, 11, 15, pOrientation);
            if (!(Library.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null || Library.isOkBox(boundingbox = BoundingBox.orientBox(pX, pY, pZ, -4, -1, 0, 14, 6, 15, pOrientation)) && pPieces.findCollisionPiece(boundingbox) == null)) {
                return null;
            }
            return new Library(pGenDepth, pRandom, boundingbox, pOrientation);
        }

        @Override
        public void postProcess(WorldGenLevel p_192540_, StructureFeatureManager p_192541_, ChunkGenerator p_192542_, Random p_192543_, BoundingBox p_192544_, ChunkPos p_192545_, BlockPos p_192546_) {
            int i = 11;
            if (!this.isTall) {
                i = 6;
            }
            this.generateBox(p_192540_, p_192544_, 0, 0, 0, 13, i - 1, 14, true, p_192543_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192540_, p_192543_, p_192544_, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(p_192540_, p_192544_, p_192543_, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.COBWEB.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), false, false);
            boolean j = true;
            int k = 12;
            int l = 1;
            while (l <= 13) {
                if ((l - 1) % 4 == 0) {
                    this.generateBox(p_192540_, p_192544_, 1, 1, l, 1, 4, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(p_192540_, p_192544_, 12, 1, l, 12, 4, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.placeBlock(p_192540_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 2, 3, l, p_192544_);
                    this.placeBlock(p_192540_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 11, 3, l, p_192544_);
                    if (this.isTall) {
                        this.generateBox(p_192540_, p_192544_, 1, 6, l, 1, 9, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                        this.generateBox(p_192540_, p_192544_, 12, 6, l, 12, 9, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    }
                } else {
                    this.generateBox(p_192540_, p_192544_, 1, 1, l, 1, 4, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                    this.generateBox(p_192540_, p_192544_, 12, 1, l, 12, 4, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                    if (this.isTall) {
                        this.generateBox(p_192540_, p_192544_, 1, 6, l, 1, 9, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                        this.generateBox(p_192540_, p_192544_, 12, 6, l, 12, 9, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                    }
                }
                ++l;
            }
            int l1 = 3;
            while (l1 < 12) {
                this.generateBox(p_192540_, p_192544_, 3, 1, l1, 4, 3, l1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(p_192540_, p_192544_, 6, 1, l1, 7, 3, l1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(p_192540_, p_192544_, 9, 1, l1, 10, 3, l1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                l1 += 2;
            }
            if (this.isTall) {
                this.generateBox(p_192540_, p_192544_, 1, 5, 1, 3, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(p_192540_, p_192544_, 10, 5, 1, 12, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(p_192540_, p_192544_, 4, 5, 1, 9, 5, 2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(p_192540_, p_192544_, 4, 5, 12, 9, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.placeBlock(p_192540_, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 11, p_192544_);
                this.placeBlock(p_192540_, Blocks.OAK_PLANKS.defaultBlockState(), 8, 5, 11, p_192544_);
                this.placeBlock(p_192540_, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 10, p_192544_);
                BlockState blockstate5 = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                BlockState blockstate = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
                this.generateBox(p_192540_, p_192544_, 3, 6, 3, 3, 6, 11, blockstate, blockstate, false);
                this.generateBox(p_192540_, p_192544_, 10, 6, 3, 10, 6, 9, blockstate, blockstate, false);
                this.generateBox(p_192540_, p_192544_, 4, 6, 2, 9, 6, 2, blockstate5, blockstate5, false);
                this.generateBox(p_192540_, p_192544_, 4, 6, 12, 7, 6, 12, blockstate5, blockstate5, false);
                this.placeBlock(p_192540_, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 2, p_192544_);
                this.placeBlock(p_192540_, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 12, p_192544_);
                this.placeBlock(p_192540_, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 10, 6, 2, p_192544_);
                int i1 = 0;
                while (i1 <= 2) {
                    this.placeBlock(p_192540_, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 8 + i1, 6, 12 - i1, p_192544_);
                    if (i1 != 2) {
                        this.placeBlock(p_192540_, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 8 + i1, 6, 11 - i1, p_192544_);
                    }
                    ++i1;
                }
                BlockState blockstate6 = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.SOUTH);
                this.placeBlock(p_192540_, blockstate6, 10, 1, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 2, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 3, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 4, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 5, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 6, 13, p_192544_);
                this.placeBlock(p_192540_, blockstate6, 10, 7, 13, p_192544_);
                int j1 = 7;
                int k1 = 7;
                BlockState blockstate1 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true);
                this.placeBlock(p_192540_, blockstate1, 6, 9, 7, p_192544_);
                BlockState blockstate2 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true);
                this.placeBlock(p_192540_, blockstate2, 7, 9, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate1, 6, 8, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate2, 7, 8, 7, p_192544_);
                BlockState blockstate3 = (BlockState)((BlockState)blockstate.setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                this.placeBlock(p_192540_, blockstate3, 6, 7, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate3, 7, 7, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate1, 5, 7, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate2, 8, 7, 7, p_192544_);
                this.placeBlock(p_192540_, (BlockState)blockstate1.setValue(FenceBlock.NORTH, true), 6, 7, 6, p_192544_);
                this.placeBlock(p_192540_, (BlockState)blockstate1.setValue(FenceBlock.SOUTH, true), 6, 7, 8, p_192544_);
                this.placeBlock(p_192540_, (BlockState)blockstate2.setValue(FenceBlock.NORTH, true), 7, 7, 6, p_192544_);
                this.placeBlock(p_192540_, (BlockState)blockstate2.setValue(FenceBlock.SOUTH, true), 7, 7, 8, p_192544_);
                BlockState blockstate4 = Blocks.TORCH.defaultBlockState();
                this.placeBlock(p_192540_, blockstate4, 5, 8, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate4, 8, 8, 7, p_192544_);
                this.placeBlock(p_192540_, blockstate4, 6, 8, 6, p_192544_);
                this.placeBlock(p_192540_, blockstate4, 6, 8, 8, p_192544_);
                this.placeBlock(p_192540_, blockstate4, 7, 8, 6, p_192544_);
                this.placeBlock(p_192540_, blockstate4, 7, 8, 8, p_192544_);
            }
            this.createChest(p_192540_, p_192544_, p_192543_, 3, 3, 5, BuiltInLootTables.STRONGHOLD_LIBRARY);
            if (this.isTall) {
                this.placeBlock(p_192540_, CAVE_AIR, 12, 9, 1, p_192544_);
                this.createChest(p_192540_, p_192544_, p_192543_, 12, 8, 1, BuiltInLootTables.STRONGHOLD_LIBRARY);
            }
        }
    }

    static class PieceWeight {
        public final Class<? extends StrongholdPiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;

        public PieceWeight(Class<? extends StrongholdPiece> pPieceClass, int pWeight, int pMaxPlaceCount) {
            this.pieceClass = pPieceClass;
            this.weight = pWeight;
            this.maxPlaceCount = pMaxPlaceCount;
        }

        public boolean doPlace(int p_73067_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class PortalRoom
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 8;
        protected static final int DEPTH = 16;
        private boolean hasPlacedSpawner;

        public PortalRoom(int pGenDepth, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, pGenDepth, pBox);
            this.setOrientation(pOrientation);
        }

        public PortalRoom(CompoundTag p_192551_) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, p_192551_);
            this.hasPlacedSpawner = p_192551_.getBoolean("Mob");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192561_, CompoundTag p_192562_) {
            super.addAdditionalSaveData(p_192561_, p_192562_);
            p_192562_.putBoolean("Mob", this.hasPlacedSpawner);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            if (pPiece != null) {
                ((StartPiece)pPiece).portalRoomPiece = this;
            }
        }

        public static PortalRoom createPiece(StructurePieceAccessor pPieces, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -4, -1, 0, 11, 8, 16, pOrientation);
            return PortalRoom.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new PortalRoom(pGenDepth, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192553_, StructureFeatureManager p_192554_, ChunkGenerator p_192555_, Random p_192556_, BoundingBox p_192557_, ChunkPos p_192558_, BlockPos p_192559_) {
            BlockPos.MutableBlockPos blockpos;
            this.generateBox(p_192553_, p_192557_, 0, 0, 0, 10, 7, 15, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192553_, p_192556_, p_192557_, StrongholdPiece.SmallDoorType.GRATES, 4, 1, 0);
            int i = 6;
            this.generateBox(p_192553_, p_192557_, 1, i, 1, 1, i, 14, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 9, i, 1, 9, i, 14, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 2, i, 1, 8, i, 2, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 2, i, 14, 8, i, 14, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 1, 1, 1, 2, 1, 4, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 8, 1, 1, 9, 1, 4, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 1, 1, 1, 1, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(p_192553_, p_192557_, 9, 1, 1, 9, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(p_192553_, p_192557_, 3, 1, 8, 7, 1, 12, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 4, 1, 9, 6, 1, 11, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            BlockState blockstate = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true);
            BlockState blockstate1 = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true);
            int j = 3;
            while (j < 14) {
                this.generateBox(p_192553_, p_192557_, 0, 3, j, 0, 4, j, blockstate, blockstate, false);
                this.generateBox(p_192553_, p_192557_, 10, 3, j, 10, 4, j, blockstate, blockstate, false);
                j += 2;
            }
            int i1 = 2;
            while (i1 < 9) {
                this.generateBox(p_192553_, p_192557_, i1, 3, 15, i1, 4, 15, blockstate1, blockstate1, false);
                i1 += 2;
            }
            BlockState blockstate5 = (BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            this.generateBox(p_192553_, p_192557_, 4, 1, 5, 6, 1, 7, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 4, 2, 6, 6, 2, 7, false, p_192556_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192553_, p_192557_, 4, 3, 7, 6, 3, 7, false, p_192556_, SMOOTH_STONE_SELECTOR);
            int k = 4;
            while (k <= 6) {
                this.placeBlock(p_192553_, blockstate5, k, 1, 4, p_192557_);
                this.placeBlock(p_192553_, blockstate5, k, 2, 5, p_192557_);
                this.placeBlock(p_192553_, blockstate5, k, 3, 6, p_192557_);
                ++k;
            }
            BlockState blockstate6 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.NORTH);
            BlockState blockstate2 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.SOUTH);
            BlockState blockstate3 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.EAST);
            BlockState blockstate4 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.WEST);
            boolean flag = true;
            boolean[] aboolean = new boolean[12];
            int l = 0;
            while (l < aboolean.length) {
                aboolean[l] = p_192556_.nextFloat() > 0.9f;
                flag &= aboolean[l];
                ++l;
            }
            this.placeBlock(p_192553_, (BlockState)blockstate6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[0]), 4, 3, 8, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[1]), 5, 3, 8, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[2]), 6, 3, 8, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate2.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[3]), 4, 3, 12, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate2.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[4]), 5, 3, 12, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate2.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[5]), 6, 3, 12, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[6]), 3, 3, 9, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[7]), 3, 3, 10, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[8]), 3, 3, 11, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[9]), 7, 3, 9, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[10]), 7, 3, 10, p_192557_);
            this.placeBlock(p_192553_, (BlockState)blockstate4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[11]), 7, 3, 11, p_192557_);
            if (flag) {
                BlockState blockstate7 = Blocks.END_PORTAL.defaultBlockState();
                this.placeBlock(p_192553_, blockstate7, 4, 3, 9, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 5, 3, 9, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 6, 3, 9, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 4, 3, 10, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 5, 3, 10, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 6, 3, 10, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 4, 3, 11, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 5, 3, 11, p_192557_);
                this.placeBlock(p_192553_, blockstate7, 6, 3, 11, p_192557_);
            }
            if (!this.hasPlacedSpawner && p_192557_.isInside(blockpos = this.getWorldPos(5, 3, 6))) {
                this.hasPlacedSpawner = true;
                p_192553_.setBlock(blockpos, Blocks.SPAWNER.defaultBlockState(), 2);
                BlockEntity blockentity = p_192553_.getBlockEntity(blockpos);
                if (blockentity instanceof SpawnerBlockEntity) {
                    ((SpawnerBlockEntity)blockentity).getSpawner().setEntityId(EntityType.SILVERFISH);
                }
            }
        }
    }

    public static class PrisonHall
    extends StrongholdPiece {
        protected static final int WIDTH = 9;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 11;

        public PrisonHall(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public PrisonHall(CompoundTag p_192564_) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, p_192564_);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 1, 1);
        }

        public static PrisonHall createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 9, 5, 11, pOrientation);
            return PrisonHall.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new PrisonHall(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192566_, StructureFeatureManager p_192567_, ChunkGenerator p_192568_, Random p_192569_, BoundingBox p_192570_, ChunkPos p_192571_, BlockPos p_192572_) {
            this.generateBox(p_192566_, p_192570_, 0, 0, 0, 8, 4, 10, true, p_192569_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192566_, p_192569_, p_192570_, this.entryDoor, 1, 1, 0);
            this.generateBox(p_192566_, p_192570_, 1, 1, 10, 3, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(p_192566_, p_192570_, 4, 1, 1, 4, 3, 1, false, p_192569_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192566_, p_192570_, 4, 1, 3, 4, 3, 3, false, p_192569_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192566_, p_192570_, 4, 1, 7, 4, 3, 7, false, p_192569_, SMOOTH_STONE_SELECTOR);
            this.generateBox(p_192566_, p_192570_, 4, 1, 9, 4, 3, 9, false, p_192569_, SMOOTH_STONE_SELECTOR);
            int i = 1;
            while (i <= 3) {
                this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 4, p_192570_);
                this.placeBlock(p_192566_, (BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)).setValue(IronBarsBlock.EAST, true), 4, i, 5, p_192570_);
                this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 6, p_192570_);
                this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 5, i, 5, p_192570_);
                this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 6, i, 5, p_192570_);
                this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 7, i, 5, p_192570_);
                ++i;
            }
            this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 2, p_192570_);
            this.placeBlock(p_192566_, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 8, p_192570_);
            BlockState blockstate1 = (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST);
            BlockState blockstate = (BlockState)((BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST)).setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER);
            this.placeBlock(p_192566_, blockstate1, 4, 1, 2, p_192570_);
            this.placeBlock(p_192566_, blockstate, 4, 2, 2, p_192570_);
            this.placeBlock(p_192566_, blockstate1, 4, 1, 8, p_192570_);
            this.placeBlock(p_192566_, blockstate, 4, 2, 8, p_192570_);
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public RightTurn(CompoundTag p_192574_) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, p_192574_);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            Direction direction = this.getOrientation();
            if (direction != Direction.NORTH && direction != Direction.EAST) {
                this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, 1, 1);
            } else {
                this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, 1, 1);
            }
        }

        public static RightTurn createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, 5, pOrientation);
            return RightTurn.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new RightTurn(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192576_, StructureFeatureManager p_192577_, ChunkGenerator p_192578_, Random p_192579_, BoundingBox p_192580_, ChunkPos p_192581_, BlockPos p_192582_) {
            this.generateBox(p_192576_, p_192580_, 0, 0, 0, 4, 4, 4, true, p_192579_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192576_, p_192579_, p_192580_, this.entryDoor, 1, 1, 0);
            Direction direction = this.getOrientation();
            if (direction != Direction.NORTH && direction != Direction.EAST) {
                this.generateBox(p_192576_, p_192580_, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(p_192576_, p_192580_, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class RoomCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 7;
        protected static final int DEPTH = 11;
        protected final int type;

        public RoomCrossing(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
            this.type = pRandom.nextInt(5);
        }

        public RoomCrossing(CompoundTag p_192584_) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, p_192584_);
            this.type = p_192584_.getInt("Type");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192594_, CompoundTag p_192595_) {
            super.addAdditionalSaveData(p_192594_, p_192595_);
            p_192595_.putInt("Type", this.type);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 4, 1);
            this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, 1, 4);
            this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, 1, 4);
        }

        public static RoomCrossing createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -4, -1, 0, 11, 7, 11, pOrientation);
            return RoomCrossing.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new RoomCrossing(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192586_, StructureFeatureManager p_192587_, ChunkGenerator p_192588_, Random p_192589_, BoundingBox p_192590_, ChunkPos p_192591_, BlockPos p_192592_) {
            this.generateBox(p_192586_, p_192590_, 0, 0, 0, 10, 6, 10, true, p_192589_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192586_, p_192589_, p_192590_, this.entryDoor, 4, 1, 0);
            this.generateBox(p_192586_, p_192590_, 4, 1, 10, 6, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(p_192586_, p_192590_, 0, 1, 4, 0, 3, 6, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(p_192586_, p_192590_, 10, 1, 4, 10, 3, 6, CAVE_AIR, CAVE_AIR, false);
            switch (this.type) {
                case 0: {
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, p_192590_);
                    this.placeBlock(p_192586_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 4, 3, 5, p_192590_);
                    this.placeBlock(p_192586_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 6, 3, 5, p_192590_);
                    this.placeBlock(p_192586_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 5, 3, 4, p_192590_);
                    this.placeBlock(p_192586_, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.NORTH), 5, 3, 6, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 4, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 6, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 4, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 6, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 4, p_192590_);
                    this.placeBlock(p_192586_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 6, p_192590_);
                    break;
                }
                case 1: {
                    int i1 = 0;
                    while (i1 < 5) {
                        this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 1, 3 + i1, p_192590_);
                        this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 7, 1, 3 + i1, p_192590_);
                        this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i1, 1, 3, p_192590_);
                        this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i1, 1, 7, p_192590_);
                        ++i1;
                    }
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.WATER.defaultBlockState(), 5, 4, 5, p_192590_);
                    break;
                }
                case 2: {
                    int i = 1;
                    while (i <= 9) {
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 1, 3, i, p_192590_);
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 9, 3, i, p_192590_);
                        ++i;
                    }
                    int j = 1;
                    while (j <= 9) {
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), j, 3, 1, p_192590_);
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), j, 3, 9, p_192590_);
                        ++j;
                    }
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 4, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 6, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 4, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 6, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 4, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 6, 1, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 4, 3, 5, p_192590_);
                    this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 6, 3, 5, p_192590_);
                    int k = 1;
                    while (k <= 3) {
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 4, k, 4, p_192590_);
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 6, k, 4, p_192590_);
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 4, k, 6, p_192590_);
                        this.placeBlock(p_192586_, Blocks.COBBLESTONE.defaultBlockState(), 6, k, 6, p_192590_);
                        ++k;
                    }
                    this.placeBlock(p_192586_, Blocks.TORCH.defaultBlockState(), 5, 3, 5, p_192590_);
                    int l = 2;
                    while (l <= 8) {
                        this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 2, 3, l, p_192590_);
                        this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 3, 3, l, p_192590_);
                        if (l <= 3 || l >= 7) {
                            this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 4, 3, l, p_192590_);
                            this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 5, 3, l, p_192590_);
                            this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 6, 3, l, p_192590_);
                        }
                        this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 7, 3, l, p_192590_);
                        this.placeBlock(p_192586_, Blocks.OAK_PLANKS.defaultBlockState(), 8, 3, l, p_192590_);
                        ++l;
                    }
                    BlockState blockstate = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.WEST);
                    this.placeBlock(p_192586_, blockstate, 9, 1, 3, p_192590_);
                    this.placeBlock(p_192586_, blockstate, 9, 2, 3, p_192590_);
                    this.placeBlock(p_192586_, blockstate, 9, 3, 3, p_192590_);
                    this.createChest(p_192586_, p_192590_, p_192589_, 3, 4, 8, BuiltInLootTables.STRONGHOLD_CROSSING);
                }
            }
        }
    }

    static class SmoothStoneSelector
    extends StructurePiece.BlockSelector {
        SmoothStoneSelector() {
        }

        @Override
        public void next(Random p_73188_, int p_73189_, int p_73190_, int p_73191_, boolean p_73192_) {
            float f;
            this.next = p_73192_ ? ((f = p_73188_.nextFloat()) < 0.2f ? Blocks.CRACKED_STONE_BRICKS.defaultBlockState() : (f < 0.5f ? Blocks.MOSSY_STONE_BRICKS.defaultBlockState() : (f < 0.55f ? Blocks.INFESTED_STONE_BRICKS.defaultBlockState() : Blocks.STONE_BRICKS.defaultBlockState()))) : Blocks.CAVE_AIR.defaultBlockState();
        }
    }

    public static class StairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 5;
        private final boolean isSource;

        public StairsDown(StructurePieceType pType, int pGenDepth, int pX, int pZ, Direction pOrientation) {
            super(pType, pGenDepth, StairsDown.makeBoundingBox(pX, 64, pZ, pOrientation, 5, 11, 5));
            this.isSource = true;
            this.setOrientation(pOrientation);
            this.entryDoor = StrongholdPiece.SmallDoorType.OPENING;
        }

        public StairsDown(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_STAIRS_DOWN, pGenDepth, pBox);
            this.isSource = false;
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public StairsDown(StructurePieceType p_209938_, CompoundTag p_209939_) {
            super(p_209938_, p_209939_);
            this.isSource = p_209939_.getBoolean("Source");
        }

        public StairsDown(CompoundTag p_192597_) {
            this(StructurePieceType.STRONGHOLD_STAIRS_DOWN, p_192597_);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192607_, CompoundTag p_192608_) {
            super.addAdditionalSaveData(p_192607_, p_192608_);
            p_192608_.putBoolean("Source", this.isSource);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            if (this.isSource) {
                imposedPiece = FiveCrossing.class;
            }
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 1, 1);
        }

        public static StairsDown createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -7, 0, 5, 11, 5, pOrientation);
            return StairsDown.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new StairsDown(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192599_, StructureFeatureManager p_192600_, ChunkGenerator p_192601_, Random p_192602_, BoundingBox p_192603_, ChunkPos p_192604_, BlockPos p_192605_) {
            this.generateBox(p_192599_, p_192603_, 0, 0, 0, 4, 10, 4, true, p_192602_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192599_, p_192602_, p_192603_, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(p_192599_, p_192602_, p_192603_, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 4);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 6, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 6, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 2, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, 3, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 5, 3, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, 3, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 3, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 4, 3, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 2, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 2, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 3, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 2, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 2, 1, p_192603_);
            this.placeBlock(p_192599_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 2, p_192603_);
            this.placeBlock(p_192599_, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 1, 3, p_192603_);
        }
    }

    public static class StartPiece
    extends StairsDown {
        public PieceWeight previousPiece;
        @Nullable
        public PortalRoom portalRoomPiece;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public StartPiece(Random pRandom, int pX, int pZ) {
            super(StructurePieceType.STRONGHOLD_START, 0, pX, pZ, StartPiece.getRandomHorizontalDirection(pRandom));
        }

        public StartPiece(CompoundTag p_192610_) {
            super(StructurePieceType.STRONGHOLD_START, p_192610_);
        }

        @Override
        public BlockPos getLocatorPosition() {
            return this.portalRoomPiece != null ? this.portalRoomPiece.getLocatorPosition() : super.getLocatorPosition();
        }
    }

    public static class Straight
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private final boolean leftChild;
        private final boolean rightChild;

        public Straight(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
            this.leftChild = pRandom.nextInt(2) == 0;
            this.rightChild = pRandom.nextInt(2) == 0;
        }

        public Straight(CompoundTag p_192612_) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, p_192612_);
            this.leftChild = p_192612_.getBoolean("Left");
            this.rightChild = p_192612_.getBoolean("Right");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192622_, CompoundTag p_192623_) {
            super.addAdditionalSaveData(p_192622_, p_192623_);
            p_192623_.putBoolean("Left", this.leftChild);
            p_192623_.putBoolean("Right", this.rightChild);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 1, 1);
            if (this.leftChild) {
                this.generateSmallDoorChildLeft((StartPiece)pPiece, pPieces, pRandom, 1, 2);
            }
            if (this.rightChild) {
                this.generateSmallDoorChildRight((StartPiece)pPiece, pPieces, pRandom, 1, 2);
            }
        }

        public static Straight createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pDirection, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -1, 0, 5, 5, 7, pDirection);
            return Straight.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new Straight(pGenDepth, pRandom, boundingbox, pDirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192614_, StructureFeatureManager p_192615_, ChunkGenerator p_192616_, Random p_192617_, BoundingBox p_192618_, ChunkPos p_192619_, BlockPos p_192620_) {
            this.generateBox(p_192614_, p_192618_, 0, 0, 0, 4, 4, 6, true, p_192617_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192614_, p_192617_, p_192618_, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(p_192614_, p_192617_, p_192618_, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            BlockState blockstate = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST);
            BlockState blockstate1 = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST);
            this.maybeGenerateBlock(p_192614_, p_192618_, p_192617_, 0.1f, 1, 2, 1, blockstate);
            this.maybeGenerateBlock(p_192614_, p_192618_, p_192617_, 0.1f, 3, 2, 1, blockstate1);
            this.maybeGenerateBlock(p_192614_, p_192618_, p_192617_, 0.1f, 1, 2, 5, blockstate);
            this.maybeGenerateBlock(p_192614_, p_192618_, p_192617_, 0.1f, 3, 2, 5, blockstate1);
            if (this.leftChild) {
                this.generateBox(p_192614_, p_192618_, 0, 1, 2, 0, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightChild) {
                this.generateBox(p_192614_, p_192618_, 4, 1, 2, 4, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class StraightStairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 8;

        public StraightStairsDown(int pGenDepth, Random pRandom, BoundingBox pBox, Direction pOrientation) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, pGenDepth, pBox);
            this.setOrientation(pOrientation);
            this.entryDoor = this.randomSmallDoor(pRandom);
        }

        public StraightStairsDown(CompoundTag p_192625_) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, p_192625_);
        }

        @Override
        public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
            this.generateSmallDoorChildForward((StartPiece)pPiece, pPieces, pRandom, 1, 1);
        }

        public static StraightStairsDown createPiece(StructurePieceAccessor pPieces, Random pRandom, int pX, int pY, int pZ, Direction pOrientation, int pGenDepth) {
            BoundingBox boundingbox = BoundingBox.orientBox(pX, pY, pZ, -1, -7, 0, 5, 11, 8, pOrientation);
            return StraightStairsDown.isOkBox(boundingbox) && pPieces.findCollisionPiece(boundingbox) == null ? new StraightStairsDown(pGenDepth, pRandom, boundingbox, pOrientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel p_192627_, StructureFeatureManager p_192628_, ChunkGenerator p_192629_, Random p_192630_, BoundingBox p_192631_, ChunkPos p_192632_, BlockPos p_192633_) {
            this.generateBox(p_192627_, p_192631_, 0, 0, 0, 4, 10, 7, true, p_192630_, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(p_192627_, p_192630_, p_192631_, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(p_192627_, p_192630_, p_192631_, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 7);
            BlockState blockstate = (BlockState)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            int i = 0;
            while (i < 6) {
                this.placeBlock(p_192627_, blockstate, 1, 6 - i, 1 + i, p_192631_);
                this.placeBlock(p_192627_, blockstate, 2, 6 - i, 1 + i, p_192631_);
                this.placeBlock(p_192627_, blockstate, 3, 6 - i, 1 + i, p_192631_);
                if (i < 5) {
                    this.placeBlock(p_192627_, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5 - i, 1 + i, p_192631_);
                    this.placeBlock(p_192627_, Blocks.STONE_BRICKS.defaultBlockState(), 2, 5 - i, 1 + i, p_192631_);
                    this.placeBlock(p_192627_, Blocks.STONE_BRICKS.defaultBlockState(), 3, 5 - i, 1 + i, p_192631_);
                }
                ++i;
            }
        }
    }

    static abstract class StrongholdPiece
    extends StructurePiece {
        protected SmallDoorType entryDoor = SmallDoorType.OPENING;

        protected StrongholdPiece(StructurePieceType p_209941_, int p_209942_, BoundingBox p_209943_) {
            super(p_209941_, p_209942_, p_209943_);
        }

        public StrongholdPiece(StructurePieceType p_209945_, CompoundTag p_209946_) {
            super(p_209945_, p_209946_);
            this.entryDoor = SmallDoorType.valueOf(p_209946_.getString("EntryDoor"));
        }

        @Override
        public NoiseEffect getNoiseEffect() {
            return NoiseEffect.BURY;
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_192635_, CompoundTag p_192636_) {
            p_192636_.putString("EntryDoor", this.entryDoor.name());
        }

        protected void generateSmallDoor(WorldGenLevel pLevel, Random pRandom, BoundingBox pBox, SmallDoorType pType, int pX, int pY, int pZ) {
            switch (pType) {
                case OPENING: {
                    this.generateBox(pLevel, pBox, pX, pY, pZ, pX + 3 - 1, pY + 3 - 1, pZ, CAVE_AIR, CAVE_AIR, false);
                    break;
                }
                case WOOD_DOOR: {
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 1, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.OAK_DOOR.defaultBlockState(), pX + 1, pY, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.OAK_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), pX + 1, pY + 1, pZ, pBox);
                    break;
                }
                case GRATES: {
                    this.placeBlock(pLevel, Blocks.CAVE_AIR.defaultBlockState(), pX + 1, pY, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.CAVE_AIR.defaultBlockState(), pX + 1, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), pX, pY, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), pX, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), pX, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), pX + 1, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), pX + 2, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), pX + 2, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), pX + 2, pY, pZ, pBox);
                    break;
                }
                case IRON_DOOR: {
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 1, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY + 2, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.STONE_BRICKS.defaultBlockState(), pX + 2, pY, pZ, pBox);
                    this.placeBlock(pLevel, Blocks.IRON_DOOR.defaultBlockState(), pX + 1, pY, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), pX + 1, pY + 1, pZ, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.NORTH), pX + 2, pY + 1, pZ + 1, pBox);
                    this.placeBlock(pLevel, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.SOUTH), pX + 2, pY + 1, pZ - 1, pBox);
                }
            }
        }

        protected SmallDoorType randomSmallDoor(Random pRandom) {
            int i = pRandom.nextInt(5);
            switch (i) {
                default: {
                    return SmallDoorType.OPENING;
                }
                case 2: {
                    return SmallDoorType.WOOD_DOOR;
                }
                case 3: {
                    return SmallDoorType.GRATES;
                }
                case 4: 
            }
            return SmallDoorType.IRON_DOOR;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildForward(StartPiece pStartPiece, StructurePieceAccessor pPieces, Random pRandom, int pOffsetX, int pOffsetY) {
            Direction direction = this.getOrientation();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() - 1, direction, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.maxZ() + 1, direction, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() - 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, direction, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.maxX() + 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, direction, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildLeft(StartPiece pStartPiece, StructurePieceAccessor pPieces, Random pRandom, int pOffsetY, int pOffsetX) {
            Direction direction = this.getOrientation();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() - 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, Direction.WEST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() - 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, Direction.WEST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildRight(StartPiece pStartPiece, StructurePieceAccessor pPieces, Random pRandom, int pOffsetY, int pOffsetX) {
            Direction direction = this.getOrientation();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.maxX() + 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, Direction.EAST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.maxX() + 1, this.boundingBox.minY() + pOffsetY, this.boundingBox.minZ() + pOffsetX, Direction.EAST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(pStartPiece, pPieces, pRandom, this.boundingBox.minX() + pOffsetX, this.boundingBox.minY() + pOffsetY, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(BoundingBox pBox) {
            return pBox != null && pBox.minY() > 10;
        }

        protected static enum SmallDoorType {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static abstract class Turn
    extends StrongholdPiece {
        protected static final int WIDTH = 5;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 5;

        protected Turn(StructurePieceType p_209948_, int p_209949_, BoundingBox p_209950_) {
            super(p_209948_, p_209949_, p_209950_);
        }

        public Turn(StructurePieceType p_209952_, CompoundTag p_209953_) {
            super(p_209952_, p_209953_);
        }
    }
}

