/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;

public class StructureFeatureIndexSavedData
extends SavedData {
    private static final String TAG_REMAINING_INDEXES = "Remaining";
    private static final String TAG_All_INDEXES = "All";
    private final LongSet all;
    private final LongSet remaining;

    private StructureFeatureIndexSavedData(LongSet pAll, LongSet pRemaining) {
        this.all = pAll;
        this.remaining = pRemaining;
    }

    public StructureFeatureIndexSavedData() {
        this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
    }

    public static StructureFeatureIndexSavedData load(CompoundTag pTag) {
        return new StructureFeatureIndexSavedData((LongSet)new LongOpenHashSet(pTag.getLongArray(TAG_All_INDEXES)), (LongSet)new LongOpenHashSet(pTag.getLongArray(TAG_REMAINING_INDEXES)));
    }

    @Override
    public CompoundTag save(CompoundTag pCompoundTag) {
        pCompoundTag.a(TAG_All_INDEXES, this.all.toLongArray());
        pCompoundTag.a(TAG_REMAINING_INDEXES, this.remaining.toLongArray());
        return pCompoundTag;
    }

    public void addIndex(long pIndex) {
        this.all.add(pIndex);
        this.remaining.add(pIndex);
    }

    public boolean hasStartIndex(long pIndex) {
        return this.all.contains(pIndex);
    }

    public boolean hasUnhandledIndex(long pIndex) {
        return this.remaining.contains(pIndex);
    }

    public void removeIndex(long pIndex) {
        this.remaining.remove(pIndex);
    }

    public LongSet getAll() {
        return this.all;
    }
}

