/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected BoundingBox boundingBox;
    @Nullable
    private Direction orientation;
    private Mirror mirror;
    private Rotation rotation;
    protected int genDepth;
    private final StructurePieceType type;
    private static final Set<Block> SHAPE_CHECK_BLOCKS = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).build();

    protected StructurePiece(StructurePieceType pType, int pGenDepth, BoundingBox pBoundingBox) {
        this.type = pType;
        this.genDepth = pGenDepth;
        this.boundingBox = pBoundingBox;
    }

    public StructurePiece(StructurePieceType pType, CompoundTag pTag) {
        this(pType, pTag.getInt("GD"), (BoundingBox)BoundingBox.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("BB")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int i = pTag.getInt("O");
        this.setOrientation(i == -1 ? null : Direction.from2DDataValue(i));
    }

    protected static BoundingBox makeBoundingBox(int pX, int pY, int pZ, Direction pDirection, int pOffsetX, int pOffsetY, int pOffsetZ) {
        return pDirection.getAxis() == Direction.Axis.Z ? new BoundingBox(pX, pY, pZ, pX + pOffsetX - 1, pY + pOffsetY - 1, pZ + pOffsetZ - 1) : new BoundingBox(pX, pY, pZ, pX + pOffsetZ - 1, pY + pOffsetY - 1, pZ + pOffsetX - 1);
    }

    protected static Direction getRandomHorizontalDirection(Random pRandom) {
        return Direction.Plane.HORIZONTAL.getRandomDirection(pRandom);
    }

    public final CompoundTag createTag(StructurePieceSerializationContext p_192645_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("id", Registry.STRUCTURE_PIECE.getKey(this.getType()).toString());
        BoundingBox.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.boundingBox).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_163579_ -> compoundtag.put("BB", (Tag)p_163579_));
        Direction direction = this.getOrientation();
        compoundtag.putInt("O", direction == null ? -1 : direction.get2DDataValue());
        compoundtag.putInt("GD", this.genDepth);
        this.addAdditionalSaveData(p_192645_, compoundtag);
        return compoundtag;
    }

    protected abstract void addAdditionalSaveData(StructurePieceSerializationContext var1, CompoundTag var2);

    public NoiseEffect getNoiseEffect() {
        return NoiseEffect.BEARD;
    }

    public void addChildren(StructurePiece pPiece, StructurePieceAccessor pPieces, Random pRandom) {
    }

    public abstract void postProcess(WorldGenLevel var1, StructureFeatureManager var2, ChunkGenerator var3, Random var4, BoundingBox var5, ChunkPos var6, BlockPos var7);

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getGenDepth() {
        return this.genDepth;
    }

    public boolean isCloseToChunk(ChunkPos pChunkPos, int pDistance) {
        int i = pChunkPos.getMinBlockX();
        int j = pChunkPos.getMinBlockZ();
        return this.boundingBox.intersects(i - pDistance, j - pDistance, i + 15 + pDistance, j + 15 + pDistance);
    }

    public BlockPos getLocatorPosition() {
        return new BlockPos(this.boundingBox.getCenter());
    }

    protected BlockPos.MutableBlockPos getWorldPos(int pX, int pY, int pZ) {
        return new BlockPos.MutableBlockPos(this.getWorldX(pX, pZ), this.getWorldY(pY), this.getWorldZ(pX, pZ));
    }

    protected int getWorldX(int pX, int pZ) {
        Direction direction = this.getOrientation();
        if (direction == null) {
            return pX;
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX() + pX;
            }
            case WEST: {
                return this.boundingBox.maxX() - pZ;
            }
            case EAST: {
                return this.boundingBox.minX() + pZ;
            }
        }
        return pX;
    }

    protected int getWorldY(int pY) {
        return this.getOrientation() == null ? pY : pY + this.boundingBox.minY();
    }

    protected int getWorldZ(int pX, int pZ) {
        Direction direction = this.getOrientation();
        if (direction == null) {
            return pZ;
        }
        switch (direction) {
            case NORTH: {
                return this.boundingBox.maxZ() - pZ;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + pZ;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ() + pX;
            }
        }
        return pZ;
    }

    protected void placeBlock(WorldGenLevel pLevel, BlockState pBlockstate, int pX, int pY, int pZ, BoundingBox pBoundingbox) {
        BlockPos.MutableBlockPos blockpos = this.getWorldPos(pX, pY, pZ);
        if (pBoundingbox.isInside(blockpos) && this.canBeReplaced(pLevel, pX, pY, pZ, pBoundingbox)) {
            if (this.mirror != Mirror.NONE) {
                pBlockstate = pBlockstate.mirror(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                pBlockstate = pBlockstate.rotate(this.rotation);
            }
            pLevel.setBlock(blockpos, pBlockstate, 2);
            FluidState fluidstate = pLevel.getFluidState(blockpos);
            if (!fluidstate.isEmpty()) {
                pLevel.scheduleTick((BlockPos)blockpos, fluidstate.getType(), 0);
            }
            if (SHAPE_CHECK_BLOCKS.contains(pBlockstate.getBlock())) {
                pLevel.getChunk(blockpos).markPosForPostprocessing(blockpos);
            }
        }
    }

    protected boolean canBeReplaced(LevelReader pLevel, int pX, int pY, int pZ, BoundingBox pBox) {
        return true;
    }

    protected BlockState getBlock(BlockGetter pLevel, int pX, int pY, int pZ, BoundingBox pBox) {
        BlockPos.MutableBlockPos blockpos = this.getWorldPos(pX, pY, pZ);
        return !pBox.isInside(blockpos) ? Blocks.AIR.defaultBlockState() : pLevel.getBlockState(blockpos);
    }

    protected boolean isInterior(LevelReader pLevel, int pX, int pY, int pZ, BoundingBox pBox) {
        BlockPos.MutableBlockPos blockpos = this.getWorldPos(pX, pY + 1, pZ);
        if (!pBox.isInside(blockpos)) {
            return false;
        }
        return blockpos.getY() < pLevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockpos.getX(), blockpos.getZ());
    }

    protected void generateAirBox(WorldGenLevel pLevel, BoundingBox pBox, int pMinX, int pMinY, int pMinZ, int pMaxX, int pMaxY, int pMaxZ) {
        int i = pMinY;
        while (i <= pMaxY) {
            int j = pMinX;
            while (j <= pMaxX) {
                int k = pMinZ;
                while (k <= pMaxZ) {
                    this.placeBlock(pLevel, Blocks.AIR.defaultBlockState(), j, i, k, pBox);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void generateBox(WorldGenLevel pLevel, BoundingBox pBox, int pXMin, int pYMin, int pZMin, int pXMax, int pYMax, int pZMax, BlockState pBoundaryBlockState, BlockState pInsideBlockState, boolean pExistingOnly) {
        int i = pYMin;
        while (i <= pYMax) {
            int j = pXMin;
            while (j <= pXMax) {
                int k = pZMin;
                while (k <= pZMax) {
                    if (!pExistingOnly || !this.getBlock(pLevel, j, i, k, pBox).isAir()) {
                        if (i != pYMin && i != pYMax && j != pXMin && j != pXMax && k != pZMin && k != pZMax) {
                            this.placeBlock(pLevel, pInsideBlockState, j, i, k, pBox);
                        } else {
                            this.placeBlock(pLevel, pBoundaryBlockState, j, i, k, pBox);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void generateBox(WorldGenLevel pLevel, BoundingBox pBoundingBox, BoundingBox pBox, BlockState pBoundaryBlockState, BlockState pInsideBlockState, boolean pExistingOnly) {
        this.generateBox(pLevel, pBoundingBox, pBox.minX(), pBox.minY(), pBox.minZ(), pBox.maxX(), pBox.maxY(), pBox.maxZ(), pBoundaryBlockState, pInsideBlockState, pExistingOnly);
    }

    protected void generateBox(WorldGenLevel pLevel, BoundingBox pBox, int pXMin, int pYMin, int pZMin, int pXMax, int pYMax, int pZMax, boolean pBoundaryBlockState, Random pInsideBlockState, BlockSelector pExistingOnly) {
        int i = pYMin;
        while (i <= pYMax) {
            int j = pXMin;
            while (j <= pXMax) {
                int k = pZMin;
                while (k <= pZMax) {
                    if (!pBoundaryBlockState || !this.getBlock(pLevel, j, i, k, pBox).isAir()) {
                        pExistingOnly.next(pInsideBlockState, j, i, k, i == pYMin || i == pYMax || j == pXMin || j == pXMax || k == pZMin || k == pZMax);
                        this.placeBlock(pLevel, pExistingOnly.getNext(), j, i, k, pBox);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void generateBox(WorldGenLevel pLevel, BoundingBox pBoundingBox, BoundingBox pBox, boolean pBoundaryBlockState, Random pInsideBlockState, BlockSelector pExistingOnly) {
        this.generateBox(pLevel, pBoundingBox, pBox.minX(), pBox.minY(), pBox.minZ(), pBox.maxX(), pBox.maxY(), pBox.maxZ(), pBoundaryBlockState, pInsideBlockState, pExistingOnly);
    }

    protected void generateMaybeBox(WorldGenLevel pLevel, BoundingBox pSbb, Random pRandom, float pChance, int pX1, int pY1, int pZ1, int pX2, int pY2, int pZ2, BlockState pEdgeState, BlockState pState, boolean pRequireNonAir, boolean pRequiredSkylight) {
        int i = pY1;
        while (i <= pY2) {
            int j = pX1;
            while (j <= pX2) {
                int k = pZ1;
                while (k <= pZ2) {
                    if (!(pRandom.nextFloat() > pChance || pRequireNonAir && this.getBlock(pLevel, j, i, k, pSbb).isAir() || pRequiredSkylight && !this.isInterior(pLevel, j, i, k, pSbb))) {
                        if (i != pY1 && i != pY2 && j != pX1 && j != pX2 && k != pZ1 && k != pZ2) {
                            this.placeBlock(pLevel, pState, j, i, k, pSbb);
                        } else {
                            this.placeBlock(pLevel, pEdgeState, j, i, k, pSbb);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void maybeGenerateBlock(WorldGenLevel pLevel, BoundingBox pBox, Random pRandom, float pChance, int pX, int pY, int pZ, BlockState pState) {
        if (pRandom.nextFloat() < pChance) {
            this.placeBlock(pLevel, pState, pX, pY, pZ, pBox);
        }
    }

    protected void generateUpperHalfSphere(WorldGenLevel pLevel, BoundingBox pBox, int pMinX, int pMinY, int pMinZ, int pMaxX, int pMaxY, int pMaxZ, BlockState pState, boolean pExcludeAir) {
        float f = pMaxX - pMinX + 1;
        float f1 = pMaxY - pMinY + 1;
        float f2 = pMaxZ - pMinZ + 1;
        float f3 = (float)pMinX + f / 2.0f;
        float f4 = (float)pMinZ + f2 / 2.0f;
        int i = pMinY;
        while (i <= pMaxY) {
            float f5 = (float)(i - pMinY) / f1;
            int j = pMinX;
            while (j <= pMaxX) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                int k = pMinZ;
                while (k <= pMaxZ) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (!(pExcludeAir && this.getBlock(pLevel, j, i, k, pBox).isAir() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f))) {
                        this.placeBlock(pLevel, pState, j, i, k, pBox);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void fillColumnDown(WorldGenLevel pLevel, BlockState pState, int pX, int pY, int pZ, BoundingBox pBox) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = this.getWorldPos(pX, pY, pZ);
        if (pBox.isInside(blockpos$mutableblockpos)) {
            while (this.isReplaceableByStructures(pLevel.getBlockState(blockpos$mutableblockpos)) && blockpos$mutableblockpos.getY() > pLevel.getMinBuildHeight() + 1) {
                pLevel.setBlock(blockpos$mutableblockpos, pState, 2);
                blockpos$mutableblockpos.move(Direction.DOWN);
            }
        }
    }

    protected boolean isReplaceableByStructures(BlockState pState) {
        return pState.isAir() || pState.getMaterial().isLiquid() || pState.is(Blocks.GLOW_LICHEN) || pState.is(Blocks.SEAGRASS) || pState.is(Blocks.TALL_SEAGRASS);
    }

    protected boolean createChest(WorldGenLevel pLevel, BoundingBox pBox, Random pRandom, int pX, int pY, int pZ, ResourceLocation pLoot) {
        return this.createChest(pLevel, pBox, pRandom, this.getWorldPos(pX, pY, pZ), pLoot, null);
    }

    public static BlockState reorient(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = null;
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.relative(direction1);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (blockstate.is(Blocks.CHEST)) {
                return pState;
            }
            if (!blockstate.isSolidRender(pLevel, blockpos)) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = direction1;
        }
        if (direction != null) {
            return (BlockState)pState.setValue(HorizontalDirectionalBlock.FACING, direction.getOpposite());
        }
        Direction direction2 = pState.getValue(HorizontalDirectionalBlock.FACING);
        BlockPos blockpos1 = pPos.relative(direction2);
        if (pLevel.getBlockState(blockpos1).isSolidRender(pLevel, blockpos1)) {
            direction2 = direction2.getOpposite();
            blockpos1 = pPos.relative(direction2);
        }
        if (pLevel.getBlockState(blockpos1).isSolidRender(pLevel, blockpos1)) {
            direction2 = direction2.getClockWise();
            blockpos1 = pPos.relative(direction2);
        }
        if (pLevel.getBlockState(blockpos1).isSolidRender(pLevel, blockpos1)) {
            direction2 = direction2.getOpposite();
            pPos.relative(direction2);
        }
        return (BlockState)pState.setValue(HorizontalDirectionalBlock.FACING, direction2);
    }

    protected boolean createChest(ServerLevelAccessor pLevel, BoundingBox pBox, Random pRandom, BlockPos pPos, ResourceLocation pLootTable, @Nullable BlockState pState) {
        if (pBox.isInside(pPos) && !pLevel.getBlockState(pPos).is(Blocks.CHEST)) {
            if (pState == null) {
                pState = StructurePiece.reorient(pLevel, pPos, Blocks.CHEST.defaultBlockState());
            }
            pLevel.setBlock(pPos, pState, 2);
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof ChestBlockEntity) {
                ((ChestBlockEntity)blockentity).setLootTable(pLootTable, pRandom.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean createDispenser(WorldGenLevel pLevel, BoundingBox pBox, Random pRandom, int pX, int pY, int pZ, Direction pFacing, ResourceLocation pLootTable) {
        BlockPos.MutableBlockPos blockpos = this.getWorldPos(pX, pY, pZ);
        if (pBox.isInside(blockpos) && !pLevel.getBlockState(blockpos).is(Blocks.DISPENSER)) {
            this.placeBlock(pLevel, (BlockState)Blocks.DISPENSER.defaultBlockState().setValue(DispenserBlock.FACING, pFacing), pX, pY, pZ, pBox);
            BlockEntity blockentity = pLevel.getBlockEntity(blockpos);
            if (blockentity instanceof DispenserBlockEntity) {
                ((DispenserBlockEntity)blockentity).setLootTable(pLootTable, pRandom.nextLong());
            }
            return true;
        }
        return false;
    }

    public void move(int pX, int pY, int pZ) {
        this.boundingBox.move(pX, pY, pZ);
    }

    public static BoundingBox createBoundingBox(Stream<StructurePiece> p_192652_) {
        return BoundingBox.encapsulatingBoxes(p_192652_.map(StructurePiece::getBoundingBox)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> p_192649_, BoundingBox p_192650_) {
        for (StructurePiece structurepiece : p_192649_) {
            if (!structurepiece.getBoundingBox().intersects(p_192650_)) continue;
            return structurepiece;
        }
        return null;
    }

    @Nullable
    public Direction getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@Nullable Direction pOrientation) {
        this.orientation = pOrientation;
        if (pOrientation == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (pOrientation) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public StructurePieceType getType() {
        return this.type;
    }

    protected static abstract class BlockSelector {
        protected BlockState next = Blocks.AIR.defaultBlockState();

        protected BlockSelector() {
        }

        public abstract void next(Random var1, int var2, int var3, int var4, boolean var5);

        public BlockState getNext() {
            return this.next;
        }
    }
}

