/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public final class StructureSet
extends Record {
    private final List<StructureSelectionEntry> structures;
    private final StructurePlacement placement;
    public static final Codec<StructureSet> DIRECT_CODEC = RecordCodecBuilder.create(p_210014_ -> p_210014_.group((App)StructureSelectionEntry.CODEC.listOf().fieldOf("structures").forGetter(StructureSet::structures), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(StructureSet::placement)).apply((Applicative)p_210014_, StructureSet::new));
    public static final Codec<Holder<StructureSet>> CODEC = RegistryFileCodec.create(Registry.STRUCTURE_SET_REGISTRY, DIRECT_CODEC);

    public StructureSet(Holder<ConfiguredStructureFeature<?, ?>> p_210007_, StructurePlacement p_210008_) {
        this(List.of(new StructureSelectionEntry(p_210007_, 1)), p_210008_);
    }

    public static StructureSelectionEntry entry(Holder<ConfiguredStructureFeature<?, ?>> p_210018_, int p_210019_) {
        return new StructureSelectionEntry(p_210018_, p_210019_);
    }

    public static StructureSelectionEntry entry(Holder<ConfiguredStructureFeature<?, ?>> p_210016_) {
        return new StructureSelectionEntry(p_210016_, 1);
    }

    public List<StructureSelectionEntry> structures() {
        return this.structures;
    }

    public StructurePlacement placement() {
        return this.placement;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{StructureSet.class, "structures;placement", "structures", "placement"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StructureSet.class, "structures;placement", "structures", "placement"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StructureSet.class, "structures;placement", "structures", "placement"}, this, object);
    }

    public StructureSet(List list, StructurePlacement structurePlacement) {
        this.structures = list;
        this.placement = structurePlacement;
    }

    public record StructureSelectionEntry(Holder<ConfiguredStructureFeature<?, ?>> structure, int weight) {
        public static final Codec<StructureSelectionEntry> CODEC = RecordCodecBuilder.create(p_210034_ -> p_210034_.group((App)ConfiguredStructureFeature.CODEC.fieldOf("structure").forGetter(StructureSelectionEntry::structure), (App)ExtraCodecs.POSITIVE_INT.fieldOf("weight").forGetter(StructureSelectionEntry::weight)).apply((Applicative)p_210034_, StructureSelectionEntry::new));

        public boolean generatesInMatchingBiome(Predicate<Holder<Biome>> p_210036_) {
            HolderSet<Biome> holderset = this.structure().value().biomes();
            return holderset.stream().anyMatch(p_210036_);
        }
    }
}

