/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.RandomSource;

public enum RandomSpreadType implements StringRepresentable
{
    LINEAR("linear"),
    TRIANGULAR("triangular");

    private static final RandomSpreadType[] VALUES;
    public static final Codec<RandomSpreadType> CODEC;
    private final String id;

    static {
        VALUES = RandomSpreadType.values();
        CODEC = StringRepresentable.fromEnum(() -> VALUES, RandomSpreadType::byName);
    }

    private RandomSpreadType(String p_205022_) {
        this.id = p_205022_;
    }

    public static RandomSpreadType byName(String p_205028_) {
        RandomSpreadType[] randomSpreadTypeArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            RandomSpreadType randomspreadtype = randomSpreadTypeArray[n2];
            if (randomspreadtype.getSerializedName().equals(p_205028_)) {
                return randomspreadtype;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown Random Spread type: " + p_205028_);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    public int evaluate(RandomSource p_205025_, int p_205026_) {
        return switch (this) {
            case LINEAR -> p_205025_.nextInt(p_205026_);
            case TRIANGULAR -> (p_205025_.nextInt(p_205026_) + p_205025_.nextInt(p_205026_)) / 2;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

