/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class StructurePoolElement {
    public static final Codec<StructurePoolElement> CODEC = Registry.STRUCTURE_POOL_ELEMENT.byNameCodec().dispatch("element_type", StructurePoolElement::getType, StructurePoolElementType::codec);
    @Nullable
    private volatile StructureTemplatePool.Projection projection;

    protected static <E extends StructurePoolElement> RecordCodecBuilder<E, StructureTemplatePool.Projection> projectionCodec() {
        return StructureTemplatePool.Projection.CODEC.fieldOf("projection").forGetter(StructurePoolElement::getProjection);
    }

    protected StructurePoolElement(StructureTemplatePool.Projection p_210471_) {
        this.projection = p_210471_;
    }

    public abstract Vec3i getSize(StructureManager var1, Rotation var2);

    public abstract List<StructureTemplate.StructureBlockInfo> getShuffledJigsawBlocks(StructureManager var1, BlockPos var2, Rotation var3, Random var4);

    public abstract BoundingBox getBoundingBox(StructureManager var1, BlockPos var2, Rotation var3);

    public abstract boolean place(StructureManager var1, WorldGenLevel var2, StructureFeatureManager var3, ChunkGenerator var4, BlockPos var5, BlockPos var6, Rotation var7, BoundingBox var8, Random var9, boolean var10);

    public abstract StructurePoolElementType<?> getType();

    public void handleDataMarker(LevelAccessor p_210473_, StructureTemplate.StructureBlockInfo p_210474_, BlockPos p_210475_, Rotation p_210476_, Random p_210477_, BoundingBox p_210478_) {
    }

    public StructurePoolElement setProjection(StructureTemplatePool.Projection p_210479_) {
        this.projection = p_210479_;
        return this;
    }

    public StructureTemplatePool.Projection getProjection() {
        StructureTemplatePool.Projection structuretemplatepool$projection = this.projection;
        if (structuretemplatepool$projection == null) {
            throw new IllegalStateException();
        }
        return structuretemplatepool$projection;
    }

    public int getGroundLevelDelta() {
        return 1;
    }

    public static Function<StructureTemplatePool.Projection, EmptyPoolElement> empty() {
        return p_210525_ -> EmptyPoolElement.INSTANCE;
    }

    public static Function<StructureTemplatePool.Projection, LegacySinglePoolElement> legacy(String p_210508_) {
        return p_210530_ -> new LegacySinglePoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(p_210508_)), ProcessorLists.EMPTY, (StructureTemplatePool.Projection)p_210530_);
    }

    public static Function<StructureTemplatePool.Projection, LegacySinglePoolElement> legacy(String p_210513_, Holder<StructureProcessorList> p_210514_) {
        return p_210537_ -> new LegacySinglePoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(p_210513_)), p_210514_, (StructureTemplatePool.Projection)p_210537_);
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String p_210527_) {
        return p_210511_ -> new SinglePoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(p_210527_)), ProcessorLists.EMPTY, (StructureTemplatePool.Projection)p_210511_);
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String p_210532_, Holder<StructureProcessorList> p_210533_) {
        return p_210518_ -> new SinglePoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(p_210532_)), p_210533_, (StructureTemplatePool.Projection)p_210518_);
    }

    public static Function<StructureTemplatePool.Projection, FeaturePoolElement> feature(Holder<PlacedFeature> p_210503_) {
        return p_210506_ -> new FeaturePoolElement(p_210503_, (StructureTemplatePool.Projection)p_210506_);
    }

    public static Function<StructureTemplatePool.Projection, ListPoolElement> list(List<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>> p_210520_) {
        return p_210523_ -> new ListPoolElement(p_210520_.stream().map(p_210482_ -> (StructurePoolElement)p_210482_.apply(p_210523_)).collect(Collectors.toList()), (StructureTemplatePool.Projection)p_210523_);
    }
}

