/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class AxisAlignedLinearPosTest
extends PosRuleTest {
    public static final Codec<AxisAlignedLinearPosTest> CODEC = RecordCodecBuilder.create(p_73977_ -> p_73977_.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(p_163719_ -> Float.valueOf(p_163719_.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(p_163717_ -> Float.valueOf(p_163717_.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(p_163715_ -> p_163715_.minDist), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(p_163713_ -> p_163713_.maxDist), (App)Direction.Axis.CODEC.fieldOf("axis").orElse((Object)Direction.Axis.Y).forGetter(p_163711_ -> p_163711_.axis)).apply((Applicative)p_73977_, AxisAlignedLinearPosTest::new));
    private final float minChance;
    private final float maxChance;
    private final int minDist;
    private final int maxDist;
    private final Direction.Axis axis;

    public AxisAlignedLinearPosTest(float p_73970_, float p_73971_, int p_73972_, int p_73973_, Direction.Axis p_73974_) {
        if (p_73972_ >= p_73973_) {
            throw new IllegalArgumentException("Invalid range: [" + p_73972_ + "," + p_73973_ + "]");
        }
        this.minChance = p_73970_;
        this.maxChance = p_73971_;
        this.minDist = p_73972_;
        this.maxDist = p_73973_;
        this.axis = p_73974_;
    }

    @Override
    public boolean test(BlockPos p_73981_, BlockPos p_73982_, BlockPos p_73983_, Random p_73984_) {
        Direction direction = Direction.get(Direction.AxisDirection.POSITIVE, this.axis);
        float f = Math.abs((p_73982_.getX() - p_73983_.getX()) * direction.getStepX());
        float f1 = Math.abs((p_73982_.getY() - p_73983_.getY()) * direction.getStepY());
        float f2 = Math.abs((p_73982_.getZ() - p_73983_.getZ()) * direction.getStepZ());
        int i = (int)(f + f1 + f2);
        float f3 = p_73984_.nextFloat();
        return f3 <= Mth.clampedLerp(this.minChance, this.maxChance, Mth.inverseLerp(i, this.minDist, this.maxDist));
    }

    @Override
    protected PosRuleTestType<?> getType() {
        return PosRuleTestType.AXIS_ALIGNED_LINEAR_POS_TEST;
    }
}

