/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GravityProcessor
extends StructureProcessor {
    public static final Codec<GravityProcessor> CODEC = RecordCodecBuilder.create(p_74116_ -> p_74116_.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").orElse((Object)Heightmap.Types.WORLD_SURFACE_WG).forGetter(p_163729_ -> p_163729_.heightmap), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(p_163727_ -> p_163727_.offset)).apply((Applicative)p_74116_, GravityProcessor::new));
    private final Heightmap.Types heightmap;
    private final int offset;

    public GravityProcessor(Heightmap.Types p_74105_, int p_74106_) {
        this.heightmap = p_74105_;
        this.offset = p_74106_;
    }

    @Override
    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader p_74109_, BlockPos p_74110_, BlockPos p_74111_, StructureTemplate.StructureBlockInfo p_74112_, StructureTemplate.StructureBlockInfo p_74113_, StructurePlaceSettings p_74114_) {
        Heightmap.Types heightmap$types = p_74109_ instanceof ServerLevel ? (this.heightmap == Heightmap.Types.WORLD_SURFACE_WG ? Heightmap.Types.WORLD_SURFACE : (this.heightmap == Heightmap.Types.OCEAN_FLOOR_WG ? Heightmap.Types.OCEAN_FLOOR : this.heightmap)) : this.heightmap;
        int i = p_74109_.getHeight(heightmap$types, p_74113_.pos.getX(), p_74113_.pos.getZ()) + this.offset;
        int j = p_74112_.pos.getY();
        return new StructureTemplate.StructureBlockInfo(new BlockPos(p_74113_.pos.getX(), i + j, p_74113_.pos.getZ()), p_74113_.state, p_74113_.nbt);
    }

    @Override
    protected StructureProcessorType<?> getType() {
        return StructureProcessorType.GRAVITY;
    }
}

