/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class ProcessorRule {
    public static final Codec<ProcessorRule> CODEC = RecordCodecBuilder.create(p_74246_ -> p_74246_.group((App)RuleTest.CODEC.fieldOf("input_predicate").forGetter(p_163747_ -> p_163747_.inputPredicate), (App)RuleTest.CODEC.fieldOf("location_predicate").forGetter(p_163745_ -> p_163745_.locPredicate), (App)PosRuleTest.CODEC.optionalFieldOf("position_predicate", (Object)PosAlwaysTrueTest.INSTANCE).forGetter(p_163743_ -> p_163743_.posPredicate), (App)BlockState.CODEC.fieldOf("output_state").forGetter(p_163741_ -> p_163741_.outputState), (App)CompoundTag.CODEC.optionalFieldOf("output_nbt").forGetter(p_163739_ -> Optional.ofNullable(p_163739_.outputTag))).apply((Applicative)p_74246_, ProcessorRule::new));
    private final RuleTest inputPredicate;
    private final RuleTest locPredicate;
    private final PosRuleTest posPredicate;
    private final BlockState outputState;
    @Nullable
    private final CompoundTag outputTag;

    public ProcessorRule(RuleTest pInputPredicate, RuleTest pLocPredicate, BlockState pOutputState) {
        this(pInputPredicate, pLocPredicate, PosAlwaysTrueTest.INSTANCE, pOutputState, Optional.empty());
    }

    public ProcessorRule(RuleTest pInputPredicate, RuleTest pLocPredicate, PosRuleTest pPosPredicate, BlockState pOutputState) {
        this(pInputPredicate, pLocPredicate, pPosPredicate, pOutputState, Optional.empty());
    }

    public ProcessorRule(RuleTest p_74232_, RuleTest p_74233_, PosRuleTest p_74234_, BlockState p_74235_, Optional<CompoundTag> p_74236_) {
        this.inputPredicate = p_74232_;
        this.locPredicate = p_74233_;
        this.posPredicate = p_74234_;
        this.outputState = p_74235_;
        this.outputTag = p_74236_.orElse(null);
    }

    public boolean test(BlockState pInputState, BlockState pExistingState, BlockPos pLocalPos, BlockPos pRelativePos, BlockPos pStructurePos, Random pRandom) {
        return this.inputPredicate.test(pInputState, pRandom) && this.locPredicate.test(pExistingState, pRandom) && this.posPredicate.test(pLocalPos, pRelativePos, pStructurePos, pRandom);
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    @Nullable
    public CompoundTag getOutputTag() {
        return this.outputTag;
    }
}

