/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public final class ImprovedNoise {
    private static final float SHIFT_UP_EPSILON = 1.0E-7f;
    private final byte[] p;
    public final double xo;
    public final double yo;
    public final double zo;

    public ImprovedNoise(RandomSource pRandomSource) {
        this.xo = pRandomSource.nextDouble() * 256.0;
        this.yo = pRandomSource.nextDouble() * 256.0;
        this.zo = pRandomSource.nextDouble() * 256.0;
        this.p = new byte[256];
        int i = 0;
        while (i < 256) {
            this.p[i] = (byte)i;
            ++i;
        }
        int k = 0;
        while (k < 256) {
            int j = pRandomSource.nextInt(256 - k);
            byte b0 = this.p[k];
            this.p[k] = this.p[k + j];
            this.p[k + j] = b0;
            ++k;
        }
    }

    public double noise(double pX, double p_164310_, double pY) {
        return this.noise(pX, p_164310_, pY, 0.0, 0.0);
    }

    @Deprecated
    public double noise(double pX, double p_75329_, double pY, double p_75331_, double pZ) {
        double d6;
        double d0 = pX + this.xo;
        double d1 = p_75329_ + this.yo;
        double d2 = pY + this.zo;
        int i = Mth.floor(d0);
        int j = Mth.floor(d1);
        int k = Mth.floor(d2);
        double d3 = d0 - (double)i;
        double d4 = d1 - (double)j;
        double d5 = d2 - (double)k;
        if (p_75331_ != 0.0) {
            double d7 = pZ >= 0.0 && pZ < d4 ? pZ : d4;
            d6 = (double)Mth.floor(d7 / p_75331_ + (double)1.0E-7f) * p_75331_;
        } else {
            d6 = 0.0;
        }
        return this.sampleAndLerp(i, j, k, d3, d4 - d6, d5, d4);
    }

    public double a(double p_164313_, double p_164314_, double p_164315_, double[] p_164316_) {
        double d0 = p_164313_ + this.xo;
        double d1 = p_164314_ + this.yo;
        double d2 = p_164315_ + this.zo;
        int i = Mth.floor(d0);
        int j = Mth.floor(d1);
        int k = Mth.floor(d2);
        double d3 = d0 - (double)i;
        double d4 = d1 - (double)j;
        double d5 = d2 - (double)k;
        return this.a(i, j, k, d3, d4, d5, p_164316_);
    }

    private static double gradDot(int pGradIndex, double pXFactor, double p_75338_, double pYFactor) {
        return SimplexNoise.a(SimplexNoise.GRADIENT[pGradIndex & 0xF], pXFactor, p_75338_, pYFactor);
    }

    private int p(int pIndex) {
        return this.p[pIndex & 0xFF] & 0xFF;
    }

    private double sampleAndLerp(int pGridX, int pGridY, int pGridZ, double pDeltaX, double p_164322_, double pWeirdDeltaY, double p_164324_) {
        int i = this.p(pGridX);
        int j = this.p(pGridX + 1);
        int k = this.p(i + pGridY);
        int l = this.p(i + pGridY + 1);
        int i1 = this.p(j + pGridY);
        int j1 = this.p(j + pGridY + 1);
        double d0 = ImprovedNoise.gradDot(this.p(k + pGridZ), pDeltaX, p_164322_, pWeirdDeltaY);
        double d1 = ImprovedNoise.gradDot(this.p(i1 + pGridZ), pDeltaX - 1.0, p_164322_, pWeirdDeltaY);
        double d2 = ImprovedNoise.gradDot(this.p(l + pGridZ), pDeltaX, p_164322_ - 1.0, pWeirdDeltaY);
        double d3 = ImprovedNoise.gradDot(this.p(j1 + pGridZ), pDeltaX - 1.0, p_164322_ - 1.0, pWeirdDeltaY);
        double d4 = ImprovedNoise.gradDot(this.p(k + pGridZ + 1), pDeltaX, p_164322_, pWeirdDeltaY - 1.0);
        double d5 = ImprovedNoise.gradDot(this.p(i1 + pGridZ + 1), pDeltaX - 1.0, p_164322_, pWeirdDeltaY - 1.0);
        double d6 = ImprovedNoise.gradDot(this.p(l + pGridZ + 1), pDeltaX, p_164322_ - 1.0, pWeirdDeltaY - 1.0);
        double d7 = ImprovedNoise.gradDot(this.p(j1 + pGridZ + 1), pDeltaX - 1.0, p_164322_ - 1.0, pWeirdDeltaY - 1.0);
        double d8 = Mth.smoothstep(pDeltaX);
        double d9 = Mth.smoothstep(p_164324_);
        double d10 = Mth.smoothstep(pWeirdDeltaY);
        return Mth.lerp3(d8, d9, d10, d0, d1, d2, d3, d4, d5, d6, d7);
    }

    private double a(int p_164326_, int p_164327_, int p_164328_, double p_164329_, double p_164330_, double p_164331_, double[] p_164332_) {
        int i = this.p(p_164326_);
        int j = this.p(p_164326_ + 1);
        int k = this.p(i + p_164327_);
        int l = this.p(i + p_164327_ + 1);
        int i1 = this.p(j + p_164327_);
        int j1 = this.p(j + p_164327_ + 1);
        int k1 = this.p(k + p_164328_);
        int l1 = this.p(i1 + p_164328_);
        int i2 = this.p(l + p_164328_);
        int j2 = this.p(j1 + p_164328_);
        int k2 = this.p(k + p_164328_ + 1);
        int l2 = this.p(i1 + p_164328_ + 1);
        int i3 = this.p(l + p_164328_ + 1);
        int j3 = this.p(j1 + p_164328_ + 1);
        int[] aint = SimplexNoise.GRADIENT[k1 & 0xF];
        int[] aint1 = SimplexNoise.GRADIENT[l1 & 0xF];
        int[] aint2 = SimplexNoise.GRADIENT[i2 & 0xF];
        int[] aint3 = SimplexNoise.GRADIENT[j2 & 0xF];
        int[] aint4 = SimplexNoise.GRADIENT[k2 & 0xF];
        int[] aint5 = SimplexNoise.GRADIENT[l2 & 0xF];
        int[] aint6 = SimplexNoise.GRADIENT[i3 & 0xF];
        int[] aint7 = SimplexNoise.GRADIENT[j3 & 0xF];
        double d0 = SimplexNoise.a(aint, p_164329_, p_164330_, p_164331_);
        double d1 = SimplexNoise.a(aint1, p_164329_ - 1.0, p_164330_, p_164331_);
        double d2 = SimplexNoise.a(aint2, p_164329_, p_164330_ - 1.0, p_164331_);
        double d3 = SimplexNoise.a(aint3, p_164329_ - 1.0, p_164330_ - 1.0, p_164331_);
        double d4 = SimplexNoise.a(aint4, p_164329_, p_164330_, p_164331_ - 1.0);
        double d5 = SimplexNoise.a(aint5, p_164329_ - 1.0, p_164330_, p_164331_ - 1.0);
        double d6 = SimplexNoise.a(aint6, p_164329_, p_164330_ - 1.0, p_164331_ - 1.0);
        double d7 = SimplexNoise.a(aint7, p_164329_ - 1.0, p_164330_ - 1.0, p_164331_ - 1.0);
        double d8 = Mth.smoothstep(p_164329_);
        double d9 = Mth.smoothstep(p_164330_);
        double d10 = Mth.smoothstep(p_164331_);
        double d11 = Mth.lerp3(d8, d9, d10, aint[0], aint1[0], aint2[0], aint3[0], aint4[0], aint5[0], aint6[0], aint7[0]);
        double d12 = Mth.lerp3(d8, d9, d10, aint[1], aint1[1], aint2[1], aint3[1], aint4[1], aint5[1], aint6[1], aint7[1]);
        double d13 = Mth.lerp3(d8, d9, d10, aint[2], aint1[2], aint2[2], aint3[2], aint4[2], aint5[2], aint6[2], aint7[2]);
        double d14 = Mth.lerp2(d9, d10, d1 - d0, d3 - d2, d5 - d4, d7 - d6);
        double d15 = Mth.lerp2(d10, d8, d2 - d0, d6 - d4, d3 - d1, d7 - d5);
        double d16 = Mth.lerp2(d8, d9, d4 - d0, d5 - d1, d6 - d2, d7 - d3);
        double d17 = Mth.smoothstepDerivative(p_164329_);
        double d18 = Mth.smoothstepDerivative(p_164330_);
        double d19 = Mth.smoothstepDerivative(p_164331_);
        double d20 = d11 + d17 * d14;
        double d21 = d12 + d18 * d15;
        double d22 = d13 + d19 * d16;
        p_164332_[0] = p_164332_[0] + d20;
        p_164332_[1] = p_164332_[1] + d21;
        p_164332_[2] = p_164332_[2] + d22;
        return Mth.lerp3(d8, d9, d10, d0, d1, d2, d3, d4, d5, d6, d7);
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder p_192824_) {
        NoiseUtils.a(p_192824_, this.xo, this.yo, this.zo, this.p);
    }
}

