/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public class PerlinNoise {
    private static final int ROUND_OFF = 0x2000000;
    private final ImprovedNoise[] noiseLevels;
    private final int firstOctave;
    private final DoubleList amplitudes;
    private final double lowestFreqValueFactor;
    private final double lowestFreqInputFactor;
    private final double maxValue;

    @Deprecated
    public static PerlinNoise createLegacyForBlendedNoise(RandomSource p_192886_, IntStream p_192887_) {
        return new PerlinNoise(p_192886_, PerlinNoise.makeAmplitudes((IntSortedSet)new IntRBTreeSet((Collection)p_192887_.boxed().collect(ImmutableList.toImmutableList()))), false);
    }

    @Deprecated
    public static PerlinNoise createLegacyForLegacyNetherBiome(RandomSource p_210646_, int p_210647_, DoubleList p_210648_) {
        return new PerlinNoise(p_210646_, (Pair<Integer, DoubleList>)Pair.of((Object)p_210647_, (Object)p_210648_), false);
    }

    public static PerlinNoise create(RandomSource p_192894_, IntStream p_192895_) {
        return PerlinNoise.create(p_192894_, (List)p_192895_.boxed().collect(ImmutableList.toImmutableList()));
    }

    public static PerlinNoise create(RandomSource p_192883_, List<Integer> p_192884_) {
        return new PerlinNoise(p_192883_, PerlinNoise.makeAmplitudes((IntSortedSet)new IntRBTreeSet(p_192884_)), true);
    }

    public static PerlinNoise a(RandomSource p_192874_, int p_192875_, double p_192876_, double ... p_192877_) {
        DoubleArrayList doublearraylist = new DoubleArrayList(p_192877_);
        doublearraylist.add(0, p_192876_);
        return new PerlinNoise(p_192874_, (Pair<Integer, DoubleList>)Pair.of((Object)p_192875_, (Object)doublearraylist), true);
    }

    public static PerlinNoise create(RandomSource pRandomSource, int pOctaves, DoubleList pAmplitudes) {
        return new PerlinNoise(pRandomSource, (Pair<Integer, DoubleList>)Pair.of((Object)pOctaves, (Object)pAmplitudes), true);
    }

    private static Pair<Integer, DoubleList> makeAmplitudes(IntSortedSet pOctaves) {
        int j;
        if (pOctaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -pOctaves.firstInt();
        int k = i + (j = pOctaves.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList doublelist = new DoubleArrayList(new double[k]);
        IntBidirectionalIterator intbidirectionaliterator = pOctaves.iterator();
        while (intbidirectionaliterator.hasNext()) {
            int l = intbidirectionaliterator.nextInt();
            doublelist.set(l + i, 1.0);
        }
        return Pair.of((Object)(-i), (Object)doublelist);
    }

    protected PerlinNoise(RandomSource p_192869_, Pair<Integer, DoubleList> p_192870_, boolean p_192871_) {
        this.firstOctave = (Integer)p_192870_.getFirst();
        this.amplitudes = (DoubleList)p_192870_.getSecond();
        int i = this.amplitudes.size();
        int j = -this.firstOctave;
        this.noiseLevels = new ImprovedNoise[i];
        if (p_192871_) {
            PositionalRandomFactory positionalrandomfactory = p_192869_.forkPositional();
            int k = 0;
            while (k < i) {
                if (this.amplitudes.getDouble(k) != 0.0) {
                    int l = this.firstOctave + k;
                    this.noiseLevels[k] = new ImprovedNoise(positionalrandomfactory.fromHashOf("octave_" + l));
                }
                ++k;
            }
        } else {
            double d0;
            ImprovedNoise improvednoise = new ImprovedNoise(p_192869_);
            if (j >= 0 && j < i && (d0 = this.amplitudes.getDouble(j)) != 0.0) {
                this.noiseLevels[j] = improvednoise;
            }
            int i1 = j - 1;
            while (i1 >= 0) {
                if (i1 < i) {
                    double d1 = this.amplitudes.getDouble(i1);
                    if (d1 != 0.0) {
                        this.noiseLevels[i1] = new ImprovedNoise(p_192869_);
                    } else {
                        PerlinNoise.skipOctave(p_192869_);
                    }
                } else {
                    PerlinNoise.skipOctave(p_192869_);
                }
                --i1;
            }
            if (Arrays.stream(this.noiseLevels).filter(Objects::nonNull).count() != this.amplitudes.stream().filter(p_192897_ -> p_192897_ != 0.0).count()) {
                throw new IllegalStateException("Failed to create correct number of noise levels for given non-zero amplitudes");
            }
            if (j < i - 1) {
                throw new IllegalArgumentException("Positive octaves are temporarily disabled");
            }
        }
        this.lowestFreqInputFactor = Math.pow(2.0, -j);
        this.lowestFreqValueFactor = Math.pow(2.0, i - 1) / (Math.pow(2.0, i) - 1.0);
        this.maxValue = this.edgeValue(2.0);
    }

    protected double maxValue() {
        return this.maxValue;
    }

    private static void skipOctave(RandomSource pRandomSource) {
        pRandomSource.consumeCount(262);
    }

    public double getValue(double pX, double p_75410_, double pY) {
        return this.getValue(pX, p_75410_, pY, 0.0, 0.0, false);
    }

    @Deprecated
    public double getValue(double pX, double p_75419_, double pY, double p_75421_, double pZ, boolean p_75423_) {
        double d0 = 0.0;
        double d1 = this.lowestFreqInputFactor;
        double d2 = this.lowestFreqValueFactor;
        int i = 0;
        while (i < this.noiseLevels.length) {
            ImprovedNoise improvednoise = this.noiseLevels[i];
            if (improvednoise != null) {
                double d3 = improvednoise.noise(PerlinNoise.wrap(pX * d1), p_75423_ ? -improvednoise.yo : PerlinNoise.wrap(p_75419_ * d1), PerlinNoise.wrap(pY * d1), p_75421_ * d1, pZ * d1);
                d0 += this.amplitudes.getDouble(i) * d3 * d2;
            }
            d1 *= 2.0;
            d2 /= 2.0;
            ++i;
        }
        return d0;
    }

    public double maxBrokenValue(double p_210644_) {
        return this.edgeValue(p_210644_ + 2.0);
    }

    private double edgeValue(double p_210650_) {
        double d0 = 0.0;
        double d1 = this.lowestFreqValueFactor;
        int i = 0;
        while (i < this.noiseLevels.length) {
            ImprovedNoise improvednoise = this.noiseLevels[i];
            if (improvednoise != null) {
                d0 += this.amplitudes.getDouble(i) * p_210650_ * d1;
            }
            d1 /= 2.0;
            ++i;
        }
        return d0;
    }

    @Nullable
    public ImprovedNoise getOctaveNoise(int pOctave) {
        return this.noiseLevels[this.noiseLevels.length - 1 - pOctave];
    }

    public static double wrap(double pValue) {
        return pValue - (double)Mth.lfloor(pValue / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    protected int firstOctave() {
        return this.firstOctave;
    }

    protected DoubleList amplitudes() {
        return this.amplitudes;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder p_192891_) {
        p_192891_.append("PerlinNoise{");
        List<String> list = this.amplitudes.stream().map(p_192889_ -> String.format("%.2f", p_192889_)).toList();
        p_192891_.append("first octave: ").append(this.firstOctave).append(", amplitudes: ").append(list).append(", noise levels: [");
        int i = 0;
        while (i < this.noiseLevels.length) {
            p_192891_.append(i).append(": ");
            ImprovedNoise improvednoise = this.noiseLevels[i];
            if (improvednoise == null) {
                p_192891_.append("null");
            } else {
                improvednoise.parityConfigString(p_192891_);
            }
            p_192891_.append(", ");
            ++i;
        }
        p_192891_.append("]");
        p_192891_.append("}");
    }
}

