/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class PerlinSimplexNoise {
    private final SimplexNoise[] noiseLevels;
    private final double highestFreqValueFactor;
    private final double highestFreqInputFactor;

    public PerlinSimplexNoise(RandomSource pRandomSource, List<Integer> pOctaves) {
        this(pRandomSource, (IntSortedSet)new IntRBTreeSet(pOctaves));
    }

    private PerlinSimplexNoise(RandomSource pRandomSource, IntSortedSet pOctaves) {
        int j;
        if (pOctaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -pOctaves.firstInt();
        int k = i + (j = pOctaves.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoise simplexnoise = new SimplexNoise(pRandomSource);
        int l = j;
        this.noiseLevels = new SimplexNoise[k];
        if (j >= 0 && j < k && pOctaves.contains(0)) {
            this.noiseLevels[j] = simplexnoise;
        }
        int i1 = j + 1;
        while (i1 < k) {
            if (i1 >= 0 && pOctaves.contains(l - i1)) {
                this.noiseLevels[i1] = new SimplexNoise(pRandomSource);
            } else {
                pRandomSource.consumeCount(262);
            }
            ++i1;
        }
        if (j > 0) {
            long k1 = (long)(simplexnoise.getValue(simplexnoise.xo, simplexnoise.yo, simplexnoise.zo) * 9.223372036854776E18);
            WorldgenRandom randomsource = new WorldgenRandom(new LegacyRandomSource(k1));
            int j1 = l - 1;
            while (j1 >= 0) {
                if (j1 < k && pOctaves.contains(l - j1)) {
                    this.noiseLevels[j1] = new SimplexNoise(randomsource);
                } else {
                    randomsource.consumeCount(262);
                }
                --j1;
            }
        }
        this.highestFreqInputFactor = Math.pow(2.0, j);
        this.highestFreqValueFactor = 1.0 / (Math.pow(2.0, k) - 1.0);
    }

    public double getValue(double pX, double p_75451_, boolean pY) {
        double d0 = 0.0;
        double d1 = this.highestFreqInputFactor;
        double d2 = this.highestFreqValueFactor;
        SimplexNoise[] simplexNoiseArray = this.noiseLevels;
        int n = this.noiseLevels.length;
        int n2 = 0;
        while (n2 < n) {
            SimplexNoise simplexnoise = simplexNoiseArray[n2];
            if (simplexnoise != null) {
                d0 += simplexnoise.getValue(pX * d1 + (pY ? simplexnoise.xo : 0.0), p_75451_ * d1 + (pY ? simplexnoise.yo : 0.0)) * d2;
            }
            d1 /= 2.0;
            d2 *= 2.0;
            ++n2;
        }
        return d0;
    }
}

