/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.level.chunk.DataLayer;

public abstract class DataLayerStorageMap<M extends DataLayerStorageMap<M>> {
    private static final int CACHE_SIZE = 2;
    private final long[] lastSectionKeys = new long[2];
    private final DataLayer[] lastSections = new DataLayer[2];
    private boolean cacheEnabled;
    protected final Long2ObjectOpenHashMap<DataLayer> map;

    protected DataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> p_75523_) {
        this.map = p_75523_;
        this.clearCache();
        this.cacheEnabled = true;
    }

    public abstract M copy();

    public void copyDataLayer(long pSectionPos) {
        this.map.put(pSectionPos, (Object)((DataLayer)this.map.get(pSectionPos)).copy());
        this.clearCache();
    }

    public boolean hasLayer(long pSectionPos) {
        return this.map.containsKey(pSectionPos);
    }

    @Nullable
    public DataLayer getLayer(long pSectionPos) {
        DataLayer datalayer;
        if (this.cacheEnabled) {
            int i = 0;
            while (i < 2) {
                if (pSectionPos == this.lastSectionKeys[i]) {
                    return this.lastSections[i];
                }
                ++i;
            }
        }
        if ((datalayer = (DataLayer)this.map.get(pSectionPos)) == null) {
            return null;
        }
        if (this.cacheEnabled) {
            int j = 1;
            while (j > 0) {
                this.lastSectionKeys[j] = this.lastSectionKeys[j - 1];
                this.lastSections[j] = this.lastSections[j - 1];
                --j;
            }
            this.lastSectionKeys[0] = pSectionPos;
            this.lastSections[0] = datalayer;
        }
        return datalayer;
    }

    @Nullable
    public DataLayer removeLayer(long pSectionPos) {
        return (DataLayer)this.map.remove(pSectionPos);
    }

    public void setLayer(long pSectionPos, DataLayer p_75528_) {
        this.map.put(pSectionPos, (Object)p_75528_);
    }

    public void clearCache() {
        int i = 0;
        while (i < 2) {
            this.lastSectionKeys[i] = Long.MAX_VALUE;
            this.lastSections[i] = null;
            ++i;
        }
    }

    public void disableCache() {
        this.cacheEnabled = false;
    }
}

