/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LayerLightEngine<M extends DataLayerStorageMap<M>, S extends LayerLightSectionStorage<M>>
extends DynamicGraphMinFixedPoint
implements LayerLightEventListener {
    public static final long SELF_SOURCE = Long.MAX_VALUE;
    private static final Direction[] DIRECTIONS = Direction.values();
    protected final LightChunkGetter chunkSource;
    protected final LightLayer layer;
    protected final S storage;
    private boolean runningLightUpdates;
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private static final int CACHE_SIZE = 2;
    private final long[] lastChunkPos = new long[2];
    private final BlockGetter[] lastChunk = new BlockGetter[2];

    public LayerLightEngine(LightChunkGetter p_75640_, LightLayer p_75641_, S p_75642_) {
        super(16, 256, 8192);
        this.chunkSource = p_75640_;
        this.layer = p_75641_;
        this.storage = p_75642_;
        this.clearCache();
    }

    @Override
    protected void checkNode(long pLevelPos) {
        ((LayerLightSectionStorage)this.storage).runAllUpdates();
        if (((LayerLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(pLevelPos))) {
            super.checkNode(pLevelPos);
        }
    }

    @Nullable
    private BlockGetter getChunk(int pChunkX, int pChunkZ) {
        long i = ChunkPos.asLong(pChunkX, pChunkZ);
        int j = 0;
        while (j < 2) {
            if (i == this.lastChunkPos[j]) {
                return this.lastChunk[j];
            }
            ++j;
        }
        BlockGetter blockgetter = this.chunkSource.getChunkForLighting(pChunkX, pChunkZ);
        int k = 1;
        while (k > 0) {
            this.lastChunkPos[k] = this.lastChunkPos[k - 1];
            this.lastChunk[k] = this.lastChunk[k - 1];
            --k;
        }
        this.lastChunkPos[0] = i;
        this.lastChunk[0] = blockgetter;
        return blockgetter;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunk, null);
    }

    protected BlockState getStateAndOpacity(long pPos, @Nullable MutableInt p_75666_) {
        boolean flag;
        int j;
        if (pPos == Long.MAX_VALUE) {
            if (p_75666_ != null) {
                p_75666_.setValue(0);
            }
            return Blocks.AIR.defaultBlockState();
        }
        int i = SectionPos.blockToSectionCoord(BlockPos.getX(pPos));
        BlockGetter blockgetter = this.getChunk(i, j = SectionPos.blockToSectionCoord(BlockPos.getZ(pPos)));
        if (blockgetter == null) {
            if (p_75666_ != null) {
                p_75666_.setValue(16);
            }
            return Blocks.BEDROCK.defaultBlockState();
        }
        this.pos.set(pPos);
        BlockState blockstate = blockgetter.getBlockState(this.pos);
        boolean bl = flag = blockstate.canOcclude() && blockstate.useShapeForLightOcclusion();
        if (p_75666_ != null) {
            p_75666_.setValue(blockstate.getLightBlock(this.chunkSource.getLevel(), this.pos));
        }
        return flag ? blockstate : Blocks.AIR.defaultBlockState();
    }

    protected VoxelShape getShape(BlockState pBlockState, long pLevelPos, Direction p_75681_) {
        return pBlockState.canOcclude() ? pBlockState.getFaceOcclusionShape(this.chunkSource.getLevel(), this.pos.set(pLevelPos), p_75681_) : Shapes.empty();
    }

    public static int getLightBlockInto(BlockGetter p_75668_, BlockState p_75669_, BlockPos p_75670_, BlockState p_75671_, BlockPos p_75672_, Direction p_75673_, int p_75674_) {
        boolean flag1;
        boolean flag = p_75669_.canOcclude() && p_75669_.useShapeForLightOcclusion();
        boolean bl = flag1 = p_75671_.canOcclude() && p_75671_.useShapeForLightOcclusion();
        if (!flag && !flag1) {
            return p_75674_;
        }
        VoxelShape voxelshape = flag ? p_75669_.getOcclusionShape(p_75668_, p_75670_) : Shapes.empty();
        VoxelShape voxelshape1 = flag1 ? p_75671_.getOcclusionShape(p_75668_, p_75672_) : Shapes.empty();
        return Shapes.mergedFaceOccludes(voxelshape, voxelshape1, p_75673_) ? 16 : p_75674_;
    }

    @Override
    protected boolean isSource(long pPos) {
        return pPos == Long.MAX_VALUE;
    }

    @Override
    protected int getComputedLevel(long pPos, long p_75658_, int pExcludedSourcePos) {
        return 0;
    }

    @Override
    protected int getLevel(long pSectionPos) {
        return pSectionPos == Long.MAX_VALUE ? 0 : 15 - ((LayerLightSectionStorage)this.storage).getStoredLevel(pSectionPos);
    }

    protected int getLevel(DataLayer pArray, long pLevelPos) {
        return 15 - pArray.get(SectionPos.sectionRelative(BlockPos.getX(pLevelPos)), SectionPos.sectionRelative(BlockPos.getY(pLevelPos)), SectionPos.sectionRelative(BlockPos.getZ(pLevelPos)));
    }

    @Override
    protected void setLevel(long pSectionPos, int p_75655_) {
        ((LayerLightSectionStorage)this.storage).setStoredLevel(pSectionPos, Math.min(15, 15 - p_75655_));
    }

    @Override
    protected int computeLevelFromNeighbor(long pStartPos, long p_75697_, int pEndPos) {
        return 0;
    }

    @Override
    public boolean hasLightWork() {
        return this.hasWork() || ((DynamicGraphMinFixedPoint)this.storage).hasWork() || ((LayerLightSectionStorage)this.storage).hasInconsistencies();
    }

    @Override
    public int runUpdates(int p_75648_, boolean p_75649_, boolean p_75650_) {
        if (!this.runningLightUpdates) {
            if (((DynamicGraphMinFixedPoint)this.storage).hasWork() && (p_75648_ = ((DynamicGraphMinFixedPoint)this.storage).runUpdates(p_75648_)) == 0) {
                return p_75648_;
            }
            ((LayerLightSectionStorage)this.storage).markNewInconsistencies(this, p_75649_, p_75650_);
        }
        this.runningLightUpdates = true;
        if (this.hasWork()) {
            p_75648_ = this.runUpdates(p_75648_);
            this.clearCache();
            if (p_75648_ == 0) {
                return p_75648_;
            }
        }
        this.runningLightUpdates = false;
        ((LayerLightSectionStorage)this.storage).swapSectionMap();
        return p_75648_;
    }

    protected void queueSectionData(long p_75661_, @Nullable DataLayer p_75662_, boolean p_75663_) {
        ((LayerLightSectionStorage)this.storage).queueSectionData(p_75661_, p_75662_, p_75663_);
    }

    @Override
    @Nullable
    public DataLayer getDataLayerData(SectionPos p_75690_) {
        return ((LayerLightSectionStorage)this.storage).getDataLayerData(p_75690_.asLong());
    }

    @Override
    public int getLightValue(BlockPos pLevelPos) {
        return ((LayerLightSectionStorage)this.storage).getLightValue(pLevelPos.asLong());
    }

    public String getDebugData(long pSectionPos) {
        return "" + ((LayerLightSectionStorage)this.storage).getLevel(pSectionPos);
    }

    @Override
    public void checkBlock(BlockPos p_75686_) {
        long i = p_75686_.asLong();
        this.checkNode(i);
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            this.checkNode(BlockPos.offset(i, direction));
            ++n2;
        }
    }

    @Override
    public void onBlockEmissionIncrease(BlockPos p_75687_, int p_75688_) {
    }

    @Override
    public void updateSectionStatus(SectionPos pPos, boolean pIsEmpty) {
        ((LayerLightSectionStorage)this.storage).updateSectionStatus(pPos.asLong(), pIsEmpty);
    }

    @Override
    public void enableLightSources(ChunkPos p_75676_, boolean p_75677_) {
        long i = SectionPos.getZeroNode(SectionPos.asLong(p_75676_.x, 0, p_75676_.z));
        ((LayerLightSectionStorage)this.storage).enableLightSources(i, p_75677_);
    }

    public void retainData(ChunkPos pPos, boolean pRetain) {
        long i = SectionPos.getZeroNode(SectionPos.asLong(pPos.x, 0, pPos.z));
        ((LayerLightSectionStorage)this.storage).retainData(i, pRetain);
    }
}

