/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.SectionTracker;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEngine;

public abstract class LayerLightSectionStorage<M extends DataLayerStorageMap<M>>
extends SectionTracker {
    protected static final int LIGHT_AND_DATA = 0;
    protected static final int LIGHT_ONLY = 1;
    protected static final int EMPTY = 2;
    protected static final DataLayer EMPTY_DATA = new DataLayer();
    private static final Direction[] DIRECTIONS = Direction.values();
    private final LightLayer layer;
    private final LightChunkGetter chunkSource;
    protected final LongSet dataSectionSet = new LongOpenHashSet();
    protected final LongSet toMarkNoData = new LongOpenHashSet();
    protected final LongSet toMarkData = new LongOpenHashSet();
    protected volatile M visibleSectionData;
    protected final M updatingSectionData;
    protected final LongSet changedSections = new LongOpenHashSet();
    protected final LongSet sectionsAffectedByLightUpdates = new LongOpenHashSet();
    protected final Long2ObjectMap<DataLayer> queuedSections = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet untrustedSections = new LongOpenHashSet();
    private final LongSet columnsToRetainQueuedDataFor = new LongOpenHashSet();
    private final LongSet toRemove = new LongOpenHashSet();
    protected volatile boolean hasToRemove;

    protected LayerLightSectionStorage(LightLayer p_75745_, LightChunkGetter p_75746_, M p_75747_) {
        super(3, 16, 256);
        this.layer = p_75745_;
        this.chunkSource = p_75746_;
        this.updatingSectionData = p_75747_;
        this.visibleSectionData = ((DataLayerStorageMap)p_75747_).copy();
        ((DataLayerStorageMap)this.visibleSectionData).disableCache();
    }

    protected boolean storingLightForSection(long pSectionPos) {
        return this.getDataLayer(pSectionPos, true) != null;
    }

    @Nullable
    protected DataLayer getDataLayer(long pSectionPos, boolean p_75760_) {
        return this.getDataLayer(p_75760_ ? this.updatingSectionData : this.visibleSectionData, pSectionPos);
    }

    @Nullable
    protected DataLayer getDataLayer(M pSectionPos, long p_75763_) {
        return ((DataLayerStorageMap)pSectionPos).getLayer(p_75763_);
    }

    @Nullable
    public DataLayer getDataLayerData(long pSectionPos) {
        DataLayer datalayer = (DataLayer)this.queuedSections.get(pSectionPos);
        return datalayer != null ? datalayer : this.getDataLayer(pSectionPos, false);
    }

    protected abstract int getLightValue(long var1);

    protected int getStoredLevel(long pLevelPos) {
        long i = SectionPos.blockToSection(pLevelPos);
        DataLayer datalayer = this.getDataLayer(i, true);
        return datalayer.get(SectionPos.sectionRelative(BlockPos.getX(pLevelPos)), SectionPos.sectionRelative(BlockPos.getY(pLevelPos)), SectionPos.sectionRelative(BlockPos.getZ(pLevelPos)));
    }

    protected void setStoredLevel(long pLevelPos, int p_75774_) {
        long i = SectionPos.blockToSection(pLevelPos);
        if (this.changedSections.add(i)) {
            ((DataLayerStorageMap)this.updatingSectionData).copyDataLayer(i);
        }
        DataLayer datalayer = this.getDataLayer(i, true);
        datalayer.set(SectionPos.sectionRelative(BlockPos.getX(pLevelPos)), SectionPos.sectionRelative(BlockPos.getY(pLevelPos)), SectionPos.sectionRelative(BlockPos.getZ(pLevelPos)), p_75774_);
        SectionPos.aroundAndAtBlockPos(pLevelPos, arg_0 -> ((LongSet)this.sectionsAffectedByLightUpdates).add(arg_0));
    }

    @Override
    protected int getLevel(long pSectionPos) {
        if (pSectionPos == Long.MAX_VALUE) {
            return 2;
        }
        if (this.dataSectionSet.contains(pSectionPos)) {
            return 0;
        }
        return !this.toRemove.contains(pSectionPos) && ((DataLayerStorageMap)this.updatingSectionData).hasLayer(pSectionPos) ? 1 : 2;
    }

    @Override
    protected int getLevelFromSource(long pPos) {
        if (this.toMarkNoData.contains(pPos)) {
            return 2;
        }
        return !this.dataSectionSet.contains(pPos) && !this.toMarkData.contains(pPos) ? 2 : 0;
    }

    @Override
    protected void setLevel(long pSectionPos, int p_75750_) {
        int i = this.getLevel(pSectionPos);
        if (i != 0 && p_75750_ == 0) {
            this.dataSectionSet.add(pSectionPos);
            this.toMarkData.remove(pSectionPos);
        }
        if (i == 0 && p_75750_ != 0) {
            this.dataSectionSet.remove(pSectionPos);
            this.toMarkNoData.remove(pSectionPos);
        }
        if (i >= 2 && p_75750_ != 2) {
            if (this.toRemove.contains(pSectionPos)) {
                this.toRemove.remove(pSectionPos);
            } else {
                ((DataLayerStorageMap)this.updatingSectionData).setLayer(pSectionPos, this.createDataLayer(pSectionPos));
                this.changedSections.add(pSectionPos);
                this.onNodeAdded(pSectionPos);
                int j = SectionPos.x(pSectionPos);
                int k = SectionPos.y(pSectionPos);
                int l = SectionPos.z(pSectionPos);
                int i1 = -1;
                while (i1 <= 1) {
                    int j1 = -1;
                    while (j1 <= 1) {
                        int k1 = -1;
                        while (k1 <= 1) {
                            this.sectionsAffectedByLightUpdates.add(SectionPos.asLong(j + j1, k + k1, l + i1));
                            ++k1;
                        }
                        ++j1;
                    }
                    ++i1;
                }
            }
        }
        if (i != 2 && p_75750_ >= 2) {
            this.toRemove.add(pSectionPos);
        }
        this.hasToRemove = !this.toRemove.isEmpty();
    }

    protected DataLayer createDataLayer(long pSectionPos) {
        DataLayer datalayer = (DataLayer)this.queuedSections.get(pSectionPos);
        return datalayer != null ? datalayer : new DataLayer();
    }

    protected void clearQueuedSectionBlocks(LayerLightEngine<?, ?> pEngine, long pSectionPos) {
        if (pEngine.getQueueSize() != 0) {
            if (pEngine.getQueueSize() < 8192) {
                pEngine.removeIf(p_75753_ -> SectionPos.blockToSection(p_75753_) == pSectionPos);
            } else {
                int i = SectionPos.sectionToBlockCoord(SectionPos.x(pSectionPos));
                int j = SectionPos.sectionToBlockCoord(SectionPos.y(pSectionPos));
                int k = SectionPos.sectionToBlockCoord(SectionPos.z(pSectionPos));
                int l = 0;
                while (l < 16) {
                    int i1 = 0;
                    while (i1 < 16) {
                        int j1 = 0;
                        while (j1 < 16) {
                            long k1 = BlockPos.asLong(i + l, j + i1, k + j1);
                            pEngine.removeFromQueue(k1);
                            ++j1;
                        }
                        ++i1;
                    }
                    ++l;
                }
            }
        }
    }

    protected boolean hasInconsistencies() {
        return this.hasToRemove;
    }

    protected void markNewInconsistencies(LayerLightEngine<M, ?> pEngine, boolean pUpdateSkyLight, boolean pUpdateBlockLight) {
        if (this.hasInconsistencies() || !this.queuedSections.isEmpty()) {
            Iterator iterator = this.toRemove.iterator();
            while (iterator.hasNext()) {
                long i = (Long)iterator.next();
                this.clearQueuedSectionBlocks(pEngine, i);
                DataLayer datalayer = (DataLayer)this.queuedSections.remove(i);
                DataLayer datalayer1 = ((DataLayerStorageMap)this.updatingSectionData).removeLayer(i);
                if (!this.columnsToRetainQueuedDataFor.contains(SectionPos.getZeroNode(i))) continue;
                if (datalayer != null) {
                    this.queuedSections.put(i, (Object)datalayer);
                    continue;
                }
                if (datalayer1 == null) continue;
                this.queuedSections.put(i, (Object)datalayer1);
            }
            ((DataLayerStorageMap)this.updatingSectionData).clearCache();
            iterator = this.toRemove.iterator();
            while (iterator.hasNext()) {
                long k = (Long)iterator.next();
                this.onNodeRemoved(k);
            }
            this.toRemove.clear();
            this.hasToRemove = false;
            for (Long2ObjectMap.Entry entry : this.queuedSections.long2ObjectEntrySet()) {
                long j = entry.getLongKey();
                if (!this.storingLightForSection(j)) continue;
                DataLayer datalayer2 = (DataLayer)entry.getValue();
                if (((DataLayerStorageMap)this.updatingSectionData).getLayer(j) == datalayer2) continue;
                this.clearQueuedSectionBlocks(pEngine, j);
                ((DataLayerStorageMap)this.updatingSectionData).setLayer(j, datalayer2);
                this.changedSections.add(j);
            }
            ((DataLayerStorageMap)this.updatingSectionData).clearCache();
            if (!pUpdateBlockLight) {
                j = this.queuedSections.keySet().iterator();
                while (j.hasNext()) {
                    long l = (Long)j.next();
                    this.checkEdgesForSection(pEngine, l);
                }
            } else {
                j = this.untrustedSections.iterator();
                while (j.hasNext()) {
                    long i1 = (Long)j.next();
                    this.checkEdgesForSection(pEngine, i1);
                }
            }
            this.untrustedSections.clear();
            ObjectIterator objectiterator = this.queuedSections.long2ObjectEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Long2ObjectMap.Entry entry1 = (Long2ObjectMap.Entry)objectiterator.next();
                long j1 = entry1.getLongKey();
                if (!this.storingLightForSection(j1)) continue;
                objectiterator.remove();
            }
        }
    }

    private void checkEdgesForSection(LayerLightEngine<M, ?> p_75778_, long p_75779_) {
        if (this.storingLightForSection(p_75779_)) {
            int i = SectionPos.sectionToBlockCoord(SectionPos.x(p_75779_));
            int j = SectionPos.sectionToBlockCoord(SectionPos.y(p_75779_));
            int k = SectionPos.sectionToBlockCoord(SectionPos.z(p_75779_));
            Direction[] directionArray = DIRECTIONS;
            int n = DIRECTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                long l = SectionPos.offset(p_75779_, direction);
                if (!this.queuedSections.containsKey(l) && this.storingLightForSection(l)) {
                    int i1 = 0;
                    while (i1 < 16) {
                        int j1 = 0;
                        while (j1 < 16) {
                            long k1;
                            long l1 = switch (direction) {
                                case Direction.DOWN -> {
                                    k1 = BlockPos.asLong(i + j1, j, k + i1);
                                    yield BlockPos.asLong(i + j1, j - 1, k + i1);
                                }
                                case Direction.UP -> {
                                    k1 = BlockPos.asLong(i + j1, j + 16 - 1, k + i1);
                                    yield BlockPos.asLong(i + j1, j + 16, k + i1);
                                }
                                case Direction.NORTH -> {
                                    k1 = BlockPos.asLong(i + i1, j + j1, k);
                                    yield BlockPos.asLong(i + i1, j + j1, k - 1);
                                }
                                case Direction.SOUTH -> {
                                    k1 = BlockPos.asLong(i + i1, j + j1, k + 16 - 1);
                                    yield BlockPos.asLong(i + i1, j + j1, k + 16);
                                }
                                case Direction.WEST -> {
                                    k1 = BlockPos.asLong(i, j + i1, k + j1);
                                    yield BlockPos.asLong(i - 1, j + i1, k + j1);
                                }
                                default -> {
                                    k1 = BlockPos.asLong(i + 16 - 1, j + i1, k + j1);
                                    yield BlockPos.asLong(i + 16, j + i1, k + j1);
                                }
                            };
                            p_75778_.checkEdge(k1, l1, p_75778_.computeLevelFromNeighbor(k1, l1, p_75778_.getLevel(k1)), false);
                            p_75778_.checkEdge(l1, k1, p_75778_.computeLevelFromNeighbor(l1, k1, p_75778_.getLevel(l1)), false);
                            ++j1;
                        }
                        ++i1;
                    }
                }
                ++n2;
            }
        }
    }

    protected void onNodeAdded(long pSectionPos) {
    }

    protected void onNodeRemoved(long p_75799_) {
    }

    protected void enableLightSources(long p_75775_, boolean p_75776_) {
    }

    public void retainData(long pSectionColumnPos, boolean p_75784_) {
        if (p_75784_) {
            this.columnsToRetainQueuedDataFor.add(pSectionColumnPos);
        } else {
            this.columnsToRetainQueuedDataFor.remove(pSectionColumnPos);
        }
    }

    protected void queueSectionData(long p_75755_, @Nullable DataLayer p_75756_, boolean p_75757_) {
        if (p_75756_ != null) {
            this.queuedSections.put(p_75755_, (Object)p_75756_);
            if (!p_75757_) {
                this.untrustedSections.add(p_75755_);
            }
        } else {
            this.queuedSections.remove(p_75755_);
        }
    }

    protected void updateSectionStatus(long pSectionPos, boolean p_75789_) {
        boolean flag = this.dataSectionSet.contains(pSectionPos);
        if (!flag && !p_75789_) {
            this.toMarkData.add(pSectionPos);
            this.checkEdge(Long.MAX_VALUE, pSectionPos, 0, true);
        }
        if (flag && p_75789_) {
            this.toMarkNoData.add(pSectionPos);
            this.checkEdge(Long.MAX_VALUE, pSectionPos, 2, false);
        }
    }

    protected void runAllUpdates() {
        if (this.hasWork()) {
            this.runUpdates(Integer.MAX_VALUE);
        }
    }

    protected void swapSectionMap() {
        if (!this.changedSections.isEmpty()) {
            Object m = ((DataLayerStorageMap)this.updatingSectionData).copy();
            ((DataLayerStorageMap)m).disableCache();
            this.visibleSectionData = m;
            this.changedSections.clear();
        }
        if (!this.sectionsAffectedByLightUpdates.isEmpty()) {
            LongIterator longiterator = this.sectionsAffectedByLightUpdates.iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                this.chunkSource.onLightUpdate(this.layer, SectionPos.of(i));
            }
            this.sectionsAffectedByLightUpdates.clear();
        }
    }
}

