/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public final class SkyLightEngine
extends LayerLightEngine<SkyLightSectionStorage.SkyDataLayerStorageMap, SkyLightSectionStorage> {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public SkyLightEngine(LightChunkGetter p_75843_) {
        super(p_75843_, LightLayer.SKY, new SkyLightSectionStorage(p_75843_));
    }

    @Override
    protected int computeLevelFromNeighbor(long pStartPos, long p_75856_, int pEndPos) {
        if (p_75856_ != Long.MAX_VALUE && pStartPos != Long.MAX_VALUE) {
            VoxelShape voxelshape1;
            int i2;
            int l1;
            if (pEndPos >= 15) {
                return pEndPos;
            }
            MutableInt mutableint = new MutableInt();
            BlockState blockstate = this.getStateAndOpacity(p_75856_, mutableint);
            if (mutableint.getValue() >= 15) {
                return 15;
            }
            int i = BlockPos.getX(pStartPos);
            int j = BlockPos.getY(pStartPos);
            int k = BlockPos.getZ(pStartPos);
            int l = BlockPos.getX(p_75856_);
            int i1 = BlockPos.getY(p_75856_);
            int j1 = BlockPos.getZ(p_75856_);
            int k1 = Integer.signum(l - i);
            Direction direction = Direction.fromNormal(k1, l1 = Integer.signum(i1 - j), i2 = Integer.signum(j1 - k));
            if (direction == null) {
                throw new IllegalStateException(String.format("Light was spread in illegal direction %d, %d, %d", k1, l1, i2));
            }
            BlockState blockstate1 = this.getStateAndOpacity(pStartPos, null);
            VoxelShape voxelshape = this.getShape(blockstate1, pStartPos, direction);
            if (Shapes.faceShapeOccludes(voxelshape, voxelshape1 = this.getShape(blockstate, p_75856_, direction.getOpposite()))) {
                return 15;
            }
            boolean flag = i == l && k == j1;
            boolean flag1 = flag && j > i1;
            return flag1 && pEndPos == 0 && mutableint.getValue() == 0 ? 0 : pEndPos + Math.max(1, mutableint.getValue());
        }
        return 15;
    }

    @Override
    protected void checkNeighborsAfterUpdate(long pPos, int p_75846_, boolean pLevel) {
        long l1;
        long i2;
        int i1;
        long i = SectionPos.blockToSection(pPos);
        int j = BlockPos.getY(pPos);
        int k = SectionPos.sectionRelative(j);
        int l = SectionPos.blockToSectionCoord(j);
        if (k != 0) {
            i1 = 0;
        } else {
            int j1 = 0;
            while (!((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.offset(i, 0, -j1 - 1, 0)) && ((SkyLightSectionStorage)this.storage).hasSectionsBelow(l - j1 - 1)) {
                ++j1;
            }
            i1 = j1;
        }
        long j3 = BlockPos.offset(pPos, 0, -1 - i1 * 16, 0);
        long k1 = SectionPos.blockToSection(j3);
        if (i == k1 || ((SkyLightSectionStorage)this.storage).storingLightForSection(k1)) {
            this.checkNeighbor(pPos, j3, p_75846_, pLevel);
        }
        if (i == (i2 = SectionPos.blockToSection(l1 = BlockPos.offset(pPos, Direction.UP))) || ((SkyLightSectionStorage)this.storage).storingLightForSection(i2)) {
            this.checkNeighbor(pPos, l1, p_75846_, pLevel);
        }
        Direction[] directionArray = HORIZONTALS;
        int n = HORIZONTALS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            int j2 = 0;
            do {
                long k2;
                long l2;
                if (i == (l2 = SectionPos.blockToSection(k2 = BlockPos.offset(pPos, direction.getStepX(), -j2, direction.getStepZ())))) {
                    this.checkNeighbor(pPos, k2, p_75846_, pLevel);
                    break;
                }
                if (!((SkyLightSectionStorage)this.storage).storingLightForSection(l2)) continue;
                long i3 = BlockPos.offset(pPos, 0, -j2, 0);
                this.checkNeighbor(i3, k2, p_75846_, pLevel);
            } while (++j2 <= i1 * 16);
            ++n2;
        }
    }

    @Override
    protected int getComputedLevel(long pPos, long p_75850_, int pExcludedSourcePos) {
        int i = pExcludedSourcePos;
        long j = SectionPos.blockToSection(pPos);
        DataLayer datalayer = ((SkyLightSectionStorage)this.storage).getDataLayer(j, true);
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                int i1;
                long k;
                block8: {
                    Direction direction;
                    block7: {
                        direction = directionArray[n2];
                        k = BlockPos.offset(pPos, direction);
                        if (k == p_75850_) break block6;
                        long l = SectionPos.blockToSection(k);
                        DataLayer datalayer1 = j == l ? datalayer : ((SkyLightSectionStorage)this.storage).getDataLayer(l, true);
                        if (datalayer1 == null) break block7;
                        i1 = this.getLevel(datalayer1, k);
                        break block8;
                    }
                    if (direction == Direction.DOWN) break block6;
                    i1 = 15 - ((SkyLightSectionStorage)this.storage).getLightValue(k, true);
                }
                int j1 = this.computeLevelFromNeighbor(k, pPos, i1);
                if (i > j1) {
                    i = j1;
                }
                if (i == 0) {
                    return i;
                }
            }
            ++n2;
        }
        return i;
    }

    @Override
    protected void checkNode(long pLevelPos) {
        ((SkyLightSectionStorage)this.storage).runAllUpdates();
        long i = SectionPos.blockToSection(pLevelPos);
        if (((SkyLightSectionStorage)this.storage).storingLightForSection(i)) {
            super.checkNode(pLevelPos);
        } else {
            pLevelPos = BlockPos.getFlatIndex(pLevelPos);
            while (!((SkyLightSectionStorage)this.storage).storingLightForSection(i) && !((SkyLightSectionStorage)this.storage).isAboveData(i)) {
                i = SectionPos.offset(i, Direction.UP);
                pLevelPos = BlockPos.offset(pLevelPos, 0, 16, 0);
            }
            if (((SkyLightSectionStorage)this.storage).storingLightForSection(i)) {
                super.checkNode(pLevelPos);
            }
        }
    }

    @Override
    public String getDebugData(long pSectionPos) {
        return String.valueOf(super.getDebugData(pSectionPos)) + (((SkyLightSectionStorage)this.storage).isAboveData(pSectionPos) ? "*" : "");
    }
}

