/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;

public class SkyLightSectionStorage
extends LayerLightSectionStorage<SkyDataLayerStorageMap> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private final LongSet sectionsWithSources = new LongOpenHashSet();
    private final LongSet sectionsToAddSourcesTo = new LongOpenHashSet();
    private final LongSet sectionsToRemoveSourcesFrom = new LongOpenHashSet();
    private final LongSet columnsWithSkySources = new LongOpenHashSet();
    private volatile boolean hasSourceInconsistencies;

    protected SkyLightSectionStorage(LightChunkGetter p_75868_) {
        super(LightLayer.SKY, p_75868_, new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long pLevelPos) {
        return this.getLightValue(pLevelPos, false);
    }

    protected int getLightValue(long p_164458_, boolean p_164459_) {
        long i = SectionPos.blockToSection(p_164458_);
        int j = SectionPos.y(i);
        SkyDataLayerStorageMap skylightsectionstorage$skydatalayerstoragemap = p_164459_ ? (SkyDataLayerStorageMap)this.updatingSectionData : (SkyDataLayerStorageMap)this.visibleSectionData;
        int k = skylightsectionstorage$skydatalayerstoragemap.topSections.get(SectionPos.getZeroNode(i));
        if (k != skylightsectionstorage$skydatalayerstoragemap.currentLowestY && j < k) {
            DataLayer datalayer = this.getDataLayer(skylightsectionstorage$skydatalayerstoragemap, i);
            if (datalayer == null) {
                p_164458_ = BlockPos.getFlatIndex(p_164458_);
                while (datalayer == null) {
                    if (++j >= k) {
                        return 15;
                    }
                    p_164458_ = BlockPos.offset(p_164458_, 0, 16, 0);
                    i = SectionPos.offset(i, Direction.UP);
                    datalayer = this.getDataLayer(skylightsectionstorage$skydatalayerstoragemap, i);
                }
            }
            return datalayer.get(SectionPos.sectionRelative(BlockPos.getX(p_164458_)), SectionPos.sectionRelative(BlockPos.getY(p_164458_)), SectionPos.sectionRelative(BlockPos.getZ(p_164458_)));
        }
        return p_164459_ && !this.lightOnInSection(i) ? 0 : 15;
    }

    @Override
    protected void onNodeAdded(long pSectionPos) {
        long j;
        int k;
        int i = SectionPos.y(pSectionPos);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY > i) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY = i;
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.defaultReturnValue(((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY);
        }
        if ((k = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(j = SectionPos.getZeroNode(pSectionPos))) < i + 1) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(j, i + 1);
            if (this.columnsWithSkySources.contains(j)) {
                this.queueAddSource(pSectionPos);
                if (k > ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY) {
                    long l = SectionPos.asLong(SectionPos.x(pSectionPos), k - 1, SectionPos.z(pSectionPos));
                    this.queueRemoveSource(l);
                }
                this.recheckInconsistencyFlag();
            }
        }
    }

    private void queueRemoveSource(long p_75895_) {
        this.sectionsToRemoveSourcesFrom.add(p_75895_);
        this.sectionsToAddSourcesTo.remove(p_75895_);
    }

    private void queueAddSource(long p_75897_) {
        this.sectionsToAddSourcesTo.add(p_75897_);
        this.sectionsToRemoveSourcesFrom.remove(p_75897_);
    }

    private void recheckInconsistencyFlag() {
        this.hasSourceInconsistencies = !this.sectionsToAddSourcesTo.isEmpty() || !this.sectionsToRemoveSourcesFrom.isEmpty();
    }

    @Override
    protected void onNodeRemoved(long p_75887_) {
        long i = SectionPos.getZeroNode(p_75887_);
        boolean flag = this.columnsWithSkySources.contains(i);
        if (flag) {
            this.queueRemoveSource(p_75887_);
        }
        int j = SectionPos.y(p_75887_);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(i) == j + 1) {
            long k = p_75887_;
            while (!this.storingLightForSection(k) && this.hasSectionsBelow(j)) {
                --j;
                k = SectionPos.offset(k, Direction.DOWN);
            }
            if (this.storingLightForSection(k)) {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(i, j + 1);
                if (flag) {
                    this.queueAddSource(k);
                }
            } else {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.remove(i);
            }
        }
        if (flag) {
            this.recheckInconsistencyFlag();
        }
    }

    @Override
    protected void enableLightSources(long p_75877_, boolean p_75878_) {
        this.runAllUpdates();
        if (p_75878_ && this.columnsWithSkySources.add(p_75877_)) {
            int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(p_75877_);
            if (i != ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY) {
                long j = SectionPos.asLong(SectionPos.x(p_75877_), i - 1, SectionPos.z(p_75877_));
                this.queueAddSource(j);
                this.recheckInconsistencyFlag();
            }
        } else if (!p_75878_) {
            this.columnsWithSkySources.remove(p_75877_);
        }
    }

    @Override
    protected boolean hasInconsistencies() {
        return super.hasInconsistencies() || this.hasSourceInconsistencies;
    }

    @Override
    protected DataLayer createDataLayer(long pSectionPos) {
        DataLayer datalayer = (DataLayer)this.queuedSections.get(pSectionPos);
        if (datalayer != null) {
            return datalayer;
        }
        long i = SectionPos.offset(pSectionPos, Direction.UP);
        int j = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(SectionPos.getZeroNode(pSectionPos));
        if (j != ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY && SectionPos.y(i) < j) {
            DataLayer datalayer1;
            while ((datalayer1 = this.getDataLayer(i, true)) == null) {
                i = SectionPos.offset(i, Direction.UP);
            }
            return SkyLightSectionStorage.repeatFirstLayer(datalayer1);
        }
        return new DataLayer();
    }

    private static DataLayer repeatFirstLayer(DataLayer p_182513_) {
        if (p_182513_.isEmpty()) {
            return new DataLayer();
        }
        byte[] abyte = p_182513_.getData();
        byte[] abyte1 = new byte[2048];
        int i = 0;
        while (i < 16) {
            System.arraycopy(abyte, 0, abyte1, i * 128, 128);
            ++i;
        }
        return new DataLayer(abyte1);
    }

    @Override
    protected void markNewInconsistencies(LayerLightEngine<SkyDataLayerStorageMap, ?> pEngine, boolean pUpdateSkyLight, boolean pUpdateBlockLight) {
        super.markNewInconsistencies(pEngine, pUpdateSkyLight, pUpdateBlockLight);
        if (pUpdateSkyLight) {
            Iterator iterator;
            if (!this.sectionsToAddSourcesTo.isEmpty()) {
                iterator = this.sectionsToAddSourcesTo.iterator();
                while (iterator.hasNext()) {
                    long i = (Long)iterator.next();
                    int j = this.getLevel(i);
                    if (j == 2 || this.sectionsToRemoveSourcesFrom.contains(i) || !this.sectionsWithSources.add(i)) continue;
                    if (j == 1) {
                        this.clearQueuedSectionBlocks(pEngine, i);
                        if (this.changedSections.add(i)) {
                            ((SkyDataLayerStorageMap)this.updatingSectionData).copyDataLayer(i);
                        }
                        Arrays.fill(this.getDataLayer(i, true).getData(), (byte)-1);
                        int i3 = SectionPos.sectionToBlockCoord(SectionPos.x(i));
                        int k3 = SectionPos.sectionToBlockCoord(SectionPos.y(i));
                        int i4 = SectionPos.sectionToBlockCoord(SectionPos.z(i));
                        Direction[] directionArray = HORIZONTALS;
                        int n = HORIZONTALS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Direction direction = directionArray[n2];
                            long j1 = SectionPos.offset(i, direction);
                            if ((this.sectionsToRemoveSourcesFrom.contains(j1) || !this.sectionsWithSources.contains(j1) && !this.sectionsToAddSourcesTo.contains(j1)) && this.storingLightForSection(j1)) {
                                int k1 = 0;
                                while (k1 < 16) {
                                    int l1 = 0;
                                    while (l1 < 16) {
                                        long i2;
                                        long j2 = switch (direction) {
                                            case Direction.NORTH -> {
                                                i2 = BlockPos.asLong(i3 + k1, k3 + l1, i4);
                                                yield BlockPos.asLong(i3 + k1, k3 + l1, i4 - 1);
                                            }
                                            case Direction.SOUTH -> {
                                                i2 = BlockPos.asLong(i3 + k1, k3 + l1, i4 + 16 - 1);
                                                yield BlockPos.asLong(i3 + k1, k3 + l1, i4 + 16);
                                            }
                                            case Direction.WEST -> {
                                                i2 = BlockPos.asLong(i3, k3 + k1, i4 + l1);
                                                yield BlockPos.asLong(i3 - 1, k3 + k1, i4 + l1);
                                            }
                                            default -> {
                                                i2 = BlockPos.asLong(i3 + 16 - 1, k3 + k1, i4 + l1);
                                                yield BlockPos.asLong(i3 + 16, k3 + k1, i4 + l1);
                                            }
                                        };
                                        pEngine.checkEdge(i2, j2, pEngine.computeLevelFromNeighbor(i2, j2, 0), true);
                                        ++l1;
                                    }
                                    ++k1;
                                }
                            }
                            ++n2;
                        }
                        int j4 = 0;
                        while (j4 < 16) {
                            int k4 = 0;
                            while (k4 < 16) {
                                long l4 = BlockPos.asLong(SectionPos.sectionToBlockCoord(SectionPos.x(i), j4), SectionPos.sectionToBlockCoord(SectionPos.y(i)), SectionPos.sectionToBlockCoord(SectionPos.z(i), k4));
                                long i5 = BlockPos.asLong(SectionPos.sectionToBlockCoord(SectionPos.x(i), j4), SectionPos.sectionToBlockCoord(SectionPos.y(i)) - 1, SectionPos.sectionToBlockCoord(SectionPos.z(i), k4));
                                pEngine.checkEdge(l4, i5, pEngine.computeLevelFromNeighbor(l4, i5, 0), true);
                                ++k4;
                            }
                            ++j4;
                        }
                        continue;
                    }
                    int k = 0;
                    while (k < 16) {
                        int l = 0;
                        while (l < 16) {
                            long i1 = BlockPos.asLong(SectionPos.sectionToBlockCoord(SectionPos.x(i), k), SectionPos.sectionToBlockCoord(SectionPos.y(i), 15), SectionPos.sectionToBlockCoord(SectionPos.z(i), l));
                            pEngine.checkEdge(Long.MAX_VALUE, i1, 0, true);
                            ++l;
                        }
                        ++k;
                    }
                }
            }
            this.sectionsToAddSourcesTo.clear();
            if (!this.sectionsToRemoveSourcesFrom.isEmpty()) {
                iterator = this.sectionsToRemoveSourcesFrom.iterator();
                while (iterator.hasNext()) {
                    long k2 = (Long)iterator.next();
                    if (!this.sectionsWithSources.remove(k2) || !this.storingLightForSection(k2)) continue;
                    int l2 = 0;
                    while (l2 < 16) {
                        int j3 = 0;
                        while (j3 < 16) {
                            long l3 = BlockPos.asLong(SectionPos.sectionToBlockCoord(SectionPos.x(k2), l2), SectionPos.sectionToBlockCoord(SectionPos.y(k2), 15), SectionPos.sectionToBlockCoord(SectionPos.z(k2), j3));
                            pEngine.checkEdge(Long.MAX_VALUE, l3, 15, false);
                            ++j3;
                        }
                        ++l2;
                    }
                }
            }
            this.sectionsToRemoveSourcesFrom.clear();
            this.hasSourceInconsistencies = false;
        }
    }

    protected boolean hasSectionsBelow(int p_75871_) {
        return p_75871_ >= ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long p_75891_) {
        long i = SectionPos.getZeroNode(p_75891_);
        int j = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(i);
        return j == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(p_75891_) >= j;
    }

    protected boolean lightOnInSection(long p_75893_) {
        long i = SectionPos.getZeroNode(p_75893_);
        return this.columnsWithSkySources.contains(i);
    }

    protected static final class SkyDataLayerStorageMap
    extends DataLayerStorageMap<SkyDataLayerStorageMap> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public SkyDataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> p_75903_, Long2IntOpenHashMap p_75904_, int p_75905_) {
            super(p_75903_);
            this.topSections = p_75904_;
            p_75904_.defaultReturnValue(p_75905_);
            this.currentLowestY = p_75905_;
        }

        @Override
        public SkyDataLayerStorageMap copy() {
            return new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }
    }
}

