/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypeByPosCache = new Long2ObjectOpenHashMap();

    @Override
    public void prepare(PathNavigationRegion p_77261_, Mob p_77262_) {
        super.prepare(p_77261_, p_77262_);
        this.pathTypeByPosCache.clear();
        this.oldWaterCost = p_77262_.getPathfindingMalus(BlockPathTypes.WATER);
    }

    @Override
    public void done() {
        this.mob.setPathfindingMalus(BlockPathTypes.WATER, this.oldWaterCost);
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        int i;
        if (this.canFloat() && this.mob.isInWater()) {
            i = this.mob.getBlockY();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.mob.getX(), (double)i, this.mob.getZ());
            BlockState blockstate = this.level.getBlockState(blockpos$mutableblockpos);
            while (blockstate.is(Blocks.WATER)) {
                blockpos$mutableblockpos.set(this.mob.getX(), (double)(++i), this.mob.getZ());
                blockstate = this.level.getBlockState(blockpos$mutableblockpos);
            }
        } else {
            i = Mth.floor(this.mob.getY() + 0.5);
        }
        BlockPos blockpos1 = this.mob.blockPosition();
        BlockPathTypes blockpathtypes1 = this.getCachedBlockPathType(blockpos1.getX(), i, blockpos1.getZ());
        if (this.mob.getPathfindingMalus(blockpathtypes1) < 0.0f) {
            for (BlockPos blockpos : ImmutableSet.of((Object)new BlockPos(this.mob.getBoundingBox().minX, (double)i, this.mob.getBoundingBox().minZ), (Object)new BlockPos(this.mob.getBoundingBox().minX, (double)i, this.mob.getBoundingBox().maxZ), (Object)new BlockPos(this.mob.getBoundingBox().maxX, (double)i, this.mob.getBoundingBox().minZ), (Object)new BlockPos(this.mob.getBoundingBox().maxX, (double)i, this.mob.getBoundingBox().maxZ))) {
                BlockPathTypes blockpathtypes = this.getCachedBlockPathType(blockpos1.getX(), i, blockpos1.getZ());
                if (!(this.mob.getPathfindingMalus(blockpathtypes) >= 0.0f)) continue;
                return super.getNode(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            }
        }
        return super.getNode(blockpos1.getX(), i, blockpos1.getZ());
    }

    @Override
    public Target getGoal(double p_77229_, double p_77230_, double p_77231_) {
        return new Target(super.getNode(Mth.floor(p_77229_), Mth.floor(p_77230_), Mth.floor(p_77231_)));
    }

    @Override
    public int a(Node[] p_77266_, Node p_77267_) {
        Node node25;
        Node node24;
        Node node23;
        Node node22;
        Node node21;
        Node node20;
        Node node19;
        Node node18;
        Node node17;
        Node node16;
        Node node15;
        Node node14;
        Node node13;
        Node node12;
        Node node11;
        Node node10;
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        int i = 0;
        Node node = this.getNode(p_77267_.x, p_77267_.y, p_77267_.z + 1);
        if (this.isOpen(node)) {
            p_77266_[i++] = node;
        }
        if (this.isOpen(node1 = this.getNode(p_77267_.x - 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node1;
        }
        if (this.isOpen(node2 = this.getNode(p_77267_.x + 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node2;
        }
        if (this.isOpen(node3 = this.getNode(p_77267_.x, p_77267_.y, p_77267_.z - 1))) {
            p_77266_[i++] = node3;
        }
        if (this.isOpen(node4 = this.getNode(p_77267_.x, p_77267_.y + 1, p_77267_.z))) {
            p_77266_[i++] = node4;
        }
        if (this.isOpen(node5 = this.getNode(p_77267_.x, p_77267_.y - 1, p_77267_.z))) {
            p_77266_[i++] = node5;
        }
        if (this.isOpen(node6 = this.getNode(p_77267_.x, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node4)) {
            p_77266_[i++] = node6;
        }
        if (this.isOpen(node7 = this.getNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node4)) {
            p_77266_[i++] = node7;
        }
        if (this.isOpen(node8 = this.getNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node4)) {
            p_77266_[i++] = node8;
        }
        if (this.isOpen(node9 = this.getNode(p_77267_.x, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node4)) {
            p_77266_[i++] = node9;
        }
        if (this.isOpen(node10 = this.getNode(p_77267_.x, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node5)) {
            p_77266_[i++] = node10;
        }
        if (this.isOpen(node11 = this.getNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node5)) {
            p_77266_[i++] = node11;
        }
        if (this.isOpen(node12 = this.getNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node5)) {
            p_77266_[i++] = node12;
        }
        if (this.isOpen(node13 = this.getNode(p_77267_.x, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node5)) {
            p_77266_[i++] = node13;
        }
        if (this.isOpen(node14 = this.getNode(p_77267_.x + 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node2)) {
            p_77266_[i++] = node14;
        }
        if (this.isOpen(node15 = this.getNode(p_77267_.x + 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node2)) {
            p_77266_[i++] = node15;
        }
        if (this.isOpen(node16 = this.getNode(p_77267_.x - 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node1)) {
            p_77266_[i++] = node16;
        }
        if (this.isOpen(node17 = this.getNode(p_77267_.x - 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node1)) {
            p_77266_[i++] = node17;
        }
        if (this.isOpen(node18 = this.getNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node8)) {
            p_77266_[i++] = node18;
        }
        if (this.isOpen(node19 = this.getNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node8)) {
            p_77266_[i++] = node19;
        }
        if (this.isOpen(node20 = this.getNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node7)) {
            p_77266_[i++] = node20;
        }
        if (this.isOpen(node21 = this.getNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node7)) {
            p_77266_[i++] = node21;
        }
        if (this.isOpen(node22 = this.getNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node12)) {
            p_77266_[i++] = node22;
        }
        if (this.isOpen(node23 = this.getNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node12)) {
            p_77266_[i++] = node23;
        }
        if (this.isOpen(node24 = this.getNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node11)) {
            p_77266_[i++] = node24;
        }
        if (this.isOpen(node25 = this.getNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node11)) {
            p_77266_[i++] = node25;
        }
        return i;
    }

    private boolean hasMalus(@Nullable Node p_77264_) {
        return p_77264_ != null && p_77264_.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node p_77270_) {
        return p_77270_ != null && !p_77270_.closed;
    }

    @Override
    @Nullable
    protected Node getNode(int pX, int pY, int pZ) {
        Node node = null;
        BlockPathTypes blockpathtypes = this.getCachedBlockPathType(pX, pY, pZ);
        float f = this.mob.getPathfindingMalus(blockpathtypes);
        if (f >= 0.0f) {
            node = super.getNode(pX, pY, pZ);
            node.type = blockpathtypes;
            node.costMalus = Math.max(node.costMalus, f);
            if (blockpathtypes == BlockPathTypes.WALKABLE) {
                node.costMalus += 1.0f;
            }
        }
        return node;
    }

    private BlockPathTypes getCachedBlockPathType(int p_164694_, int p_164695_, int p_164696_) {
        return (BlockPathTypes)((Object)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(p_164694_, p_164695_, p_164696_), p_164692_ -> this.getBlockPathType(this.level, p_164694_, p_164695_, p_164696_, this.mob, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors())));
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter pBlockaccess, int pX, int pY, int pZ, Mob pEntityliving, int pXSize, int pYSize, int pZSize, boolean pCanBreakDoors, boolean pCanEnterDoors) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        BlockPos blockpos = pEntityliving.blockPosition();
        blockpathtypes = super.getBlockPathTypes(pBlockaccess, pX, pY, pZ, pXSize, pYSize, pZSize, pCanBreakDoors, pCanEnterDoors, enumset, blockpathtypes, blockpos);
        if (enumset.contains((Object)BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (pEntityliving.getPathfindingMalus(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(pEntityliving.getPathfindingMalus(blockpathtypes2) >= pEntityliving.getPathfindingMalus(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && pEntityliving.getPathfindingMalus(blockpathtypes1) == 0.0f ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter pLevel, int pX, int pY, int pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPathTypes blockpathtypes = FlyNodeEvaluator.getBlockPathTypeRaw(pLevel, blockpos$mutableblockpos.set(pX, pY, pZ));
        if (blockpathtypes == BlockPathTypes.OPEN && pY >= pLevel.getMinBuildHeight() + 1) {
            BlockPathTypes blockpathtypes1 = FlyNodeEvaluator.getBlockPathTypeRaw(pLevel, blockpos$mutableblockpos.set(pX, pY - 1, pZ));
            blockpathtypes = blockpathtypes1 != BlockPathTypes.DAMAGE_FIRE && blockpathtypes1 != BlockPathTypes.LAVA ? (blockpathtypes1 == BlockPathTypes.DAMAGE_CACTUS ? BlockPathTypes.DAMAGE_CACTUS : (blockpathtypes1 == BlockPathTypes.DAMAGE_OTHER ? BlockPathTypes.DAMAGE_OTHER : (blockpathtypes1 == BlockPathTypes.COCOA ? BlockPathTypes.COCOA : (blockpathtypes1 == BlockPathTypes.FENCE ? BlockPathTypes.FENCE : (blockpathtypes1 != BlockPathTypes.WALKABLE && blockpathtypes1 != BlockPathTypes.OPEN && blockpathtypes1 != BlockPathTypes.WATER ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN))))) : BlockPathTypes.DAMAGE_FIRE;
        }
        if (blockpathtypes == BlockPathTypes.WALKABLE || blockpathtypes == BlockPathTypes.OPEN) {
            blockpathtypes = FlyNodeEvaluator.checkNeighbourBlocks(pLevel, blockpos$mutableblockpos.set(pX, pY, pZ), blockpathtypes);
        }
        return blockpathtypes;
    }
}

