/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;

public class MapIndex
extends SavedData {
    public static final String FILE_NAME = "idcounts";
    private final Object2IntMap<String> usedAuxIds = new Object2IntOpenHashMap();

    public MapIndex() {
        this.usedAuxIds.defaultReturnValue(-1);
    }

    public static MapIndex load(CompoundTag pCompoundTag) {
        MapIndex mapindex = new MapIndex();
        for (String s : pCompoundTag.getAllKeys()) {
            if (!pCompoundTag.contains(s, 99)) continue;
            mapindex.usedAuxIds.put((Object)s, pCompoundTag.getInt(s));
        }
        return mapindex;
    }

    @Override
    public CompoundTag save(CompoundTag pCompound) {
        for (Object2IntMap.Entry entry : this.usedAuxIds.object2IntEntrySet()) {
            pCompound.putInt((String)entry.getKey(), entry.getIntValue());
        }
        return pCompound;
    }

    public int getFreeAuxValueForMap() {
        int i = this.usedAuxIds.getInt((Object)"map") + 1;
        this.usedAuxIds.put((Object)"map", i);
        this.setDirty();
        return i;
    }
}

