/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = Maps.newHashMap();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage p_78035_) {
        this.storage = p_78035_;
    }

    private Container newStorage(String p_164836_) {
        Container commandstorage$container = new Container();
        this.namespaces.put(p_164836_, commandstorage$container);
        return commandstorage$container;
    }

    public CompoundTag get(ResourceLocation pId) {
        String s = pId.getNamespace();
        Container commandstorage$container = this.storage.get(p_164844_ -> this.newStorage(s).load((CompoundTag)p_164844_), CommandStorage.createId(s));
        return commandstorage$container != null ? commandstorage$container.get(pId.getPath()) : new CompoundTag();
    }

    public void set(ResourceLocation pId, CompoundTag pNbt) {
        String s = pId.getNamespace();
        this.storage.computeIfAbsent(p_164839_ -> this.newStorage(s).load((CompoundTag)p_164839_), () -> this.newStorage(s), CommandStorage.createId(s)).put(pId.getPath(), pNbt);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap(p_164841_ -> ((Container)p_164841_.getValue()).getKeys((String)p_164841_.getKey()));
    }

    private static String createId(String pNamespace) {
        return ID_PREFIX + pNamespace;
    }

    static class Container
    extends SavedData {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, CompoundTag> storage = Maps.newHashMap();

        Container() {
        }

        Container load(CompoundTag p_164850_) {
            CompoundTag compoundtag = p_164850_.getCompound(TAG_CONTENTS);
            for (String s : compoundtag.getAllKeys()) {
                this.storage.put(s, compoundtag.getCompound(s));
            }
            return this;
        }

        @Override
        public CompoundTag save(CompoundTag pCompound) {
            CompoundTag compoundtag = new CompoundTag();
            this.storage.forEach((p_78070_, p_78071_) -> compoundtag.put((String)p_78070_, p_78071_.copy()));
            pCompound.put(TAG_CONTENTS, compoundtag);
            return pCompound;
        }

        public CompoundTag get(String pId) {
            CompoundTag compoundtag = this.storage.get(pId);
            return compoundtag != null ? compoundtag : new CompoundTag();
        }

        public void put(String pId, CompoundTag pNbt) {
            if (pNbt.isEmpty()) {
                this.storage.remove(pId);
            } else {
                this.storage.put(pId, pNbt);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String pNamespace) {
            return this.storage.keySet().stream().map(p_78062_ -> new ResourceLocation(pNamespace, (String)p_78062_));
        }
    }
}

