/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, SavedData> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final File dataFolder;

    public DimensionDataStorage(File p_78149_, DataFixer p_78150_) {
        this.fixerUpper = p_78150_;
        this.dataFolder = p_78149_;
    }

    private File getDataFile(String pName) {
        return new File(this.dataFolder, String.valueOf(pName) + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(Function<CompoundTag, T> p_164862_, Supplier<T> p_164863_, String p_164864_) {
        T t = this.get(p_164862_, p_164864_);
        if (t != null) {
            return t;
        }
        SavedData t1 = (SavedData)p_164863_.get();
        this.set(p_164864_, t1);
        return (T)t1;
    }

    @Nullable
    public <T extends SavedData> T get(Function<CompoundTag, T> p_164859_, String p_164860_) {
        SavedData saveddata = this.cache.get(p_164860_);
        if (saveddata == null && !this.cache.containsKey(p_164860_)) {
            saveddata = this.readSavedData(p_164859_, p_164860_);
            this.cache.put(p_164860_, saveddata);
        }
        return (T)saveddata;
    }

    @Nullable
    private <T extends SavedData> T readSavedData(Function<CompoundTag, T> p_164869_, String p_164870_) {
        try {
            File file1 = this.getDataFile(p_164870_);
            if (file1.exists()) {
                CompoundTag compoundtag = this.readTagFromDisk(p_164870_, SharedConstants.getCurrentVersion().getWorldVersion());
                return (T)((SavedData)p_164869_.apply(compoundtag.getCompound("data")));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error loading saved data: {}", (Object)p_164870_, (Object)exception);
        }
        return null;
    }

    public void set(String p_164856_, SavedData p_164857_) {
        this.cache.put(p_164856_, p_164857_);
    }

    public CompoundTag readTagFromDisk(String pName, int pLevelVersion) throws IOException {
        CompoundTag compoundtag1;
        File file1 = this.getDataFile(pName);
        try (FileInputStream fileinputstream = new FileInputStream(file1);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);){
            CompoundTag compoundtag;
            if (this.isGzip(pushbackinputstream)) {
                compoundtag = NbtIo.readCompressed(pushbackinputstream);
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundtag = NbtIo.read(datainputstream);
                }
            }
            int i = compoundtag.contains("DataVersion", 99) ? compoundtag.getInt("DataVersion") : 1343;
            compoundtag1 = NbtUtils.update(this.fixerUpper, DataFixTypes.SAVED_DATA, compoundtag, i, pLevelVersion);
        }
        return compoundtag1;
    }

    private boolean isGzip(PushbackInputStream pInputStream) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = pInputStream.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            pInputStream.unread(abyte, 0, i);
        }
        return flag;
    }

    public void save() {
        this.cache.forEach((p_164866_, p_164867_) -> {
            if (p_164867_ != null) {
                p_164867_.save(this.getDataFile((String)p_164866_));
            }
        });
    }
}

