/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String ICON_FILENAME = "icon.png";
    private static final ImmutableList<String> OLD_SETTINGS_KEYS = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String TAG_DATA = "Data";
    final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;

    public LevelStorageSource(Path p_78199_, Path p_78200_, DataFixer p_78201_) {
        this.fixerUpper = p_78201_;
        try {
            Files.createDirectories(Files.exists(p_78199_, new LinkOption[0]) ? p_78199_.toRealPath(new LinkOption[0]) : p_78199_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.baseDir = p_78199_;
        this.backupDir = p_78200_;
    }

    public static LevelStorageSource createDefault(Path pSavesDir) {
        return new LevelStorageSource(pSavesDir, pSavesDir.resolve("../backups"), DataFixers.getDataFixer());
    }

    private static <T> Pair<WorldGenSettings, Lifecycle> readWorldGenSettings(Dynamic<T> pNbt, DataFixer pFixer, int pVersion) {
        Dynamic dynamic = pNbt.get("WorldGenSettings").orElseEmptyMap();
        for (String s : OLD_SETTINGS_KEYS) {
            Optional optional = pNbt.get(s).result();
            if (!optional.isPresent()) continue;
            dynamic = dynamic.set(s, (Dynamic)optional.get());
        }
        Dynamic dynamic1 = pFixer.update(References.WORLD_GEN_SETTINGS, dynamic, pVersion, SharedConstants.getCurrentVersion().getWorldVersion());
        DataResult dataresult = WorldGenSettings.CODEC.parse(dynamic1);
        return Pair.of((Object)dataresult.resultOrPartial(Util.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElseGet(() -> {
            RegistryAccess registryaccess = RegistryAccess.readFromDisk(dynamic1);
            return WorldGenSettings.makeDefault(registryaccess);
        }), (Object)dataresult.lifecycle());
    }

    private static DataPackConfig readDataPackConfig(Dynamic<?> p_78203_) {
        return DataPackConfig.CODEC.parse(p_78203_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(DataPackConfig.DEFAULT);
    }

    public String getName() {
        return "Anvil";
    }

    public List<LevelSummary> getLevelList() throws LevelStorageException {
        File[] afile;
        if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new LevelStorageException(new TranslatableComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList list = Lists.newArrayList();
        File[] fileArray = afile = this.baseDir.toFile().listFiles();
        int n = afile.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                File file1 = fileArray[n2];
                if (file1.isDirectory()) {
                    boolean flag;
                    try {
                        flag = DirectoryLock.isLocked(file1.toPath());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Failed to read {} lock", (Object)file1, (Object)exception);
                        break block9;
                    }
                    try {
                        LevelSummary levelsummary = this.readLevelData(file1, this.levelSummaryReader(file1, flag));
                        if (levelsummary != null) {
                            list.add(levelsummary);
                        }
                    }
                    catch (OutOfMemoryError outofmemoryerror) {
                        MemoryReserve.release();
                        System.gc();
                        LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)file1);
                        throw outofmemoryerror;
                    }
                    catch (StackOverflowError stackoverflowerror) {
                        LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)file1);
                        File file2 = new File(file1, "level.dat");
                        File file3 = new File(file1, "level.dat_old");
                        File file4 = new File(file1, "level.dat_corrupted_" + LocalDateTime.now().format(FORMATTER));
                        Util.safeReplaceOrMoveFile(file2, file3, file4, true);
                        throw stackoverflowerror;
                    }
                }
            }
            ++n2;
        }
        return list;
    }

    private int getStorageVersion() {
        return 19133;
    }

    @Nullable
    <T> T readLevelData(File pSaveDir, BiFunction<File, DataFixer, T> pLevelDatReader) {
        T t;
        if (!pSaveDir.exists()) {
            return null;
        }
        File file1 = new File(pSaveDir, "level.dat");
        if (file1.exists() && (t = pLevelDatReader.apply(file1, this.fixerUpper)) != null) {
            return t;
        }
        file1 = new File(pSaveDir, "level.dat_old");
        return file1.exists() ? (T)pLevelDatReader.apply(file1, this.fixerUpper) : null;
    }

    @Nullable
    private static DataPackConfig getDataPacks(File pLevelDat, DataFixer pFixer) {
        try {
            Tag tag = LevelStorageSource.readLightweightData(pLevelDat);
            if (tag instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)tag;
                CompoundTag compoundtag1 = compoundtag.getCompound(TAG_DATA);
                int i = compoundtag1.contains("DataVersion", 99) ? compoundtag1.getInt("DataVersion") : -1;
                Dynamic dynamic = pFixer.update(DataFixTypes.LEVEL.getType(), new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1), i, SharedConstants.getCurrentVersion().getWorldVersion());
                return dynamic.get("DataPacks").result().map(LevelStorageSource::readDataPackConfig).orElse(DataPackConfig.DEFAULT);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception reading {}", (Object)pLevelDat, (Object)exception);
        }
        return null;
    }

    static BiFunction<File, DataFixer, PrimaryLevelData> getLevelData(DynamicOps<Tag> p_211738_, DataPackConfig p_211739_, Lifecycle p_211740_) {
        return (p_211745_, p_211746_) -> {
            try {
                CompoundTag compoundtag = NbtIo.readCompressed(p_211745_);
                CompoundTag compoundtag1 = compoundtag.getCompound(TAG_DATA);
                CompoundTag compoundtag2 = compoundtag1.contains("Player", 10) ? compoundtag1.getCompound("Player") : null;
                compoundtag1.remove("Player");
                int i = compoundtag1.contains("DataVersion", 99) ? compoundtag1.getInt("DataVersion") : -1;
                Dynamic dynamic = p_211746_.update(DataFixTypes.LEVEL.getType(), new Dynamic(p_211738_, (Object)compoundtag1), i, SharedConstants.getCurrentVersion().getWorldVersion());
                Pair<WorldGenSettings, Lifecycle> pair = LevelStorageSource.readWorldGenSettings(dynamic, p_211746_, i);
                LevelVersion levelversion = LevelVersion.parse(dynamic);
                LevelSettings levelsettings = LevelSettings.parse(dynamic, p_211739_);
                Lifecycle lifecycle2 = ((Lifecycle)pair.getSecond()).add(p_211740_);
                return PrimaryLevelData.parse((Dynamic<Tag>)dynamic, p_211746_, i, compoundtag2, levelsettings, levelversion, (WorldGenSettings)pair.getFirst(), lifecycle2);
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", p_211745_, (Object)exception);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, LevelSummary> levelSummaryReader(File pSaveDir, boolean pLocked) {
        return (p_193015_, p_193016_) -> {
            try {
                Tag tag = LevelStorageSource.readLightweightData(p_193015_);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.getCompound(TAG_DATA);
                    int i = compoundtag1.contains("DataVersion", 99) ? compoundtag1.getInt("DataVersion") : -1;
                    Dynamic dynamic = p_193016_.update(DataFixTypes.LEVEL.getType(), new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1), i, SharedConstants.getCurrentVersion().getWorldVersion());
                    LevelVersion levelversion = LevelVersion.parse(dynamic);
                    int j = levelversion.levelDataVersion();
                    if (j == 19132 || j == 19133) {
                        boolean flag = j != this.getStorageVersion();
                        File file1 = new File(pSaveDir, ICON_FILENAME);
                        DataPackConfig datapackconfig = dynamic.get("DataPacks").result().map(LevelStorageSource::readDataPackConfig).orElse(DataPackConfig.DEFAULT);
                        LevelSettings levelsettings = LevelSettings.parse(dynamic, datapackconfig);
                        return new LevelSummary(levelsettings, levelversion, pSaveDir.getName(), flag, pLocked, file1);
                    }
                } else {
                    LOGGER.warn("Invalid root tag in {}", p_193015_);
                }
                return null;
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", p_193015_, (Object)exception);
                return null;
            }
        };
    }

    @Nullable
    private static Tag readLightweightData(File p_202313_) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(TAG_DATA, CompoundTag.TYPE, "Player"), new FieldSelector(TAG_DATA, CompoundTag.TYPE, "WorldGenSettings"));
        NbtIo.parseCompressed(p_202313_, (StreamTagVisitor)skipfields);
        return skipfields.getResult();
    }

    public boolean isNewLevelIdAcceptable(String pSaveName) {
        try {
            Path path = this.baseDir.resolve(pSaveName);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean levelExists(String pSaveName) {
        return Files.isDirectory(this.baseDir.resolve(pSaveName), new LinkOption[0]);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public LevelStorageAccess createAccess(String pSaveName) throws IOException {
        return new LevelStorageAccess(pSaveName);
    }

    static /* synthetic */ DataPackConfig access$0(File file, DataFixer dataFixer) {
        return LevelStorageSource.getDataPacks(file, dataFixer);
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock lock;
        final Path levelPath;
        private final String levelId;
        private final Map<LevelResource, Path> resources = Maps.newHashMap();

        public LevelStorageAccess(String p_78276_) throws IOException {
            this.levelId = p_78276_;
            this.levelPath = LevelStorageSource.this.baseDir.resolve(p_78276_);
            this.lock = DirectoryLock.create(this.levelPath);
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(LevelResource pFolderName) {
            return this.resources.computeIfAbsent(pFolderName, p_78303_ -> this.levelPath.resolve(p_78303_.getId()));
        }

        public Path getDimensionPath(ResourceKey<Level> p_197395_) {
            return DimensionType.getStorageFolder(p_197395_, this.levelPath);
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage createPlayerStorage() {
            this.checkLock();
            return new PlayerDataStorage(this, LevelStorageSource.this.fixerUpper);
        }

        @Nullable
        public LevelSummary getSummary() {
            this.checkLock();
            return LevelStorageSource.this.readLevelData(this.levelPath.toFile(), LevelStorageSource.this.levelSummaryReader(this.levelPath.toFile(), false));
        }

        @Nullable
        public WorldData getDataTag(DynamicOps<Tag> p_211748_, DataPackConfig p_211749_, Lifecycle p_211750_) {
            this.checkLock();
            return LevelStorageSource.this.readLevelData(this.levelPath.toFile(), LevelStorageSource.getLevelData(p_211748_, p_211749_, p_211750_));
        }

        @Nullable
        public DataPackConfig getDataPacks() {
            this.checkLock();
            return LevelStorageSource.this.readLevelData(this.levelPath.toFile(), LevelStorageSource::access$0);
        }

        public void saveDataTag(RegistryAccess pRegistries, WorldData pServerConfiguration) {
            this.saveDataTag(pRegistries, pServerConfiguration, null);
        }

        public void saveDataTag(RegistryAccess pRegistries, WorldData pServerConfiguration, @Nullable CompoundTag pHostPlayerNBT) {
            File file1 = this.levelPath.toFile();
            CompoundTag compoundtag = pServerConfiguration.createTag(pRegistries, pHostPlayerNBT);
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.put(LevelStorageSource.TAG_DATA, compoundtag);
            try {
                File file2 = File.createTempFile("level", ".dat", file1);
                NbtIo.writeCompressed(compoundtag1, file2);
                File file3 = new File(file1, "level.dat_old");
                File file4 = new File(file1, "level.dat");
                Util.safeReplaceFile(file4, file2, file3);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to save level {}", (Object)file1, (Object)exception);
            }
        }

        public Optional<Path> getIconFile() {
            return !this.lock.isValid() ? Optional.empty() : Optional.of(this.levelPath.resolve(LevelStorageSource.ICON_FILENAME));
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path path = this.levelPath.resolve("session.lock");
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            int i = 1;
            while (i <= 5) {
                LOGGER.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                LOGGER.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.levelPath)) {
                                LevelStorageAccess.this.lock.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    LOGGER.warn("Failed to delete {}", (Object)this.levelPath, (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        public void renameLevel(String pSaveName) throws IOException {
            File file2;
            this.checkLock();
            File file1 = new File(LevelStorageSource.this.baseDir.toFile(), this.levelId);
            if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
                CompoundTag compoundtag = NbtIo.readCompressed(file2);
                CompoundTag compoundtag1 = compoundtag.getCompound(LevelStorageSource.TAG_DATA);
                compoundtag1.putString("LevelName", pSaveName);
                NbtIo.writeCompressed(compoundtag, file2);
            }
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String s = String.valueOf(LocalDateTime.now().format(FORMATTER)) + "_" + this.levelId;
            Path path = LevelStorageSource.this.getBackupPath();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.findAvailableName(path, s, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelStorageAccess.this.levelPath.relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }
    }
}

