/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SerializableUUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.TimerCallbacks;
import net.minecraft.world.level.timers.TimerQueue;
import org.slf4j.Logger;

public class PrimaryLevelData
implements ServerLevelData,
WorldData {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String PLAYER = "Player";
    protected static final String WORLD_GEN_SETTINGS = "WorldGenSettings";
    private LevelSettings settings;
    private final WorldGenSettings worldGenSettings;
    private final Lifecycle worldGenSettingsLifecycle;
    private int xSpawn;
    private int ySpawn;
    private int zSpawn;
    private float spawnAngle;
    private long gameTime;
    private long dayTime;
    @Nullable
    private final DataFixer fixerUpper;
    private final int playerDataVersion;
    private boolean upgradedPlayerTag;
    @Nullable
    private CompoundTag loadedPlayerTag;
    private final int version;
    private int clearWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private boolean initialized;
    private boolean difficultyLocked;
    private WorldBorder.Settings worldBorder;
    private CompoundTag endDragonFightData;
    @Nullable
    private CompoundTag customBossEvents;
    private int wanderingTraderSpawnDelay;
    private int wanderingTraderSpawnChance;
    @Nullable
    private UUID wanderingTraderId;
    private final Set<String> knownServerBrands;
    private boolean wasModded;
    private final TimerQueue<MinecraftServer> scheduledEvents;

    private PrimaryLevelData(@Nullable DataFixer p_164942_, int p_164943_, @Nullable CompoundTag p_164944_, boolean p_164945_, int p_164946_, int p_164947_, int p_164948_, float p_164949_, long p_164950_, long p_164951_, int p_164952_, int p_164953_, int p_164954_, boolean p_164955_, int p_164956_, boolean p_164957_, boolean p_164958_, boolean p_164959_, WorldBorder.Settings p_164960_, int p_164961_, int p_164962_, @Nullable UUID p_164963_, Set<String> p_164964_, TimerQueue<MinecraftServer> p_164965_, @Nullable CompoundTag p_164966_, CompoundTag p_164967_, LevelSettings p_164968_, WorldGenSettings p_164969_, Lifecycle p_164970_) {
        this.fixerUpper = p_164942_;
        this.wasModded = p_164945_;
        this.xSpawn = p_164946_;
        this.ySpawn = p_164947_;
        this.zSpawn = p_164948_;
        this.spawnAngle = p_164949_;
        this.gameTime = p_164950_;
        this.dayTime = p_164951_;
        this.version = p_164952_;
        this.clearWeatherTime = p_164953_;
        this.rainTime = p_164954_;
        this.raining = p_164955_;
        this.thunderTime = p_164956_;
        this.thundering = p_164957_;
        this.initialized = p_164958_;
        this.difficultyLocked = p_164959_;
        this.worldBorder = p_164960_;
        this.wanderingTraderSpawnDelay = p_164961_;
        this.wanderingTraderSpawnChance = p_164962_;
        this.wanderingTraderId = p_164963_;
        this.knownServerBrands = p_164964_;
        this.loadedPlayerTag = p_164944_;
        this.playerDataVersion = p_164943_;
        this.scheduledEvents = p_164965_;
        this.customBossEvents = p_164966_;
        this.endDragonFightData = p_164967_;
        this.settings = p_164968_;
        this.worldGenSettings = p_164969_;
        this.worldGenSettingsLifecycle = p_164970_;
    }

    public PrimaryLevelData(LevelSettings p_78470_, WorldGenSettings p_78471_, Lifecycle p_78472_) {
        this(null, SharedConstants.getCurrentVersion().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.DEFAULT_SETTINGS, 0, 0, null, Sets.newLinkedHashSet(), new TimerQueue<MinecraftServer>(TimerCallbacks.SERVER_CALLBACKS), null, new CompoundTag(), p_78470_.copy(), p_78471_, p_78472_);
    }

    public static PrimaryLevelData parse(Dynamic<Tag> pDynamic, DataFixer pDataFixer, int pVersion, @Nullable CompoundTag pPlayerNBT, LevelSettings pLevelSettings, LevelVersion pVersionData, WorldGenSettings pGeneratorSettings, Lifecycle pLifecycle) {
        long i = pDynamic.get("Time").asLong(0L);
        CompoundTag compoundtag = (CompoundTag)pDynamic.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (Tag)pDynamic.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new PrimaryLevelData(pDataFixer, pVersion, pPlayerNBT, pDynamic.get("WasModded").asBoolean(false), pDynamic.get("SpawnX").asInt(0), pDynamic.get("SpawnY").asInt(0), pDynamic.get("SpawnZ").asInt(0), pDynamic.get("SpawnAngle").asFloat(0.0f), i, pDynamic.get("DayTime").asLong(i), pVersionData.levelDataVersion(), pDynamic.get("clearWeatherTime").asInt(0), pDynamic.get("rainTime").asInt(0), pDynamic.get("raining").asBoolean(false), pDynamic.get("thunderTime").asInt(0), pDynamic.get("thundering").asBoolean(false), pDynamic.get("initialized").asBoolean(true), pDynamic.get("DifficultyLocked").asBoolean(false), WorldBorder.Settings.read(pDynamic, WorldBorder.DEFAULT_SETTINGS), pDynamic.get("WanderingTraderSpawnDelay").asInt(0), pDynamic.get("WanderingTraderSpawnChance").asInt(0), pDynamic.get("WanderingTraderId").read(SerializableUUID.CODEC).result().orElse(null), pDynamic.get("ServerBrands").asStream().flatMap(p_78529_ -> p_78529_.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new TimerQueue<MinecraftServer>(TimerCallbacks.SERVER_CALLBACKS, pDynamic.get("ScheduledEvents").asStream()), (CompoundTag)pDynamic.get("CustomBossEvents").orElseEmptyMap().getValue(), compoundtag, pLevelSettings, pGeneratorSettings, pLifecycle);
    }

    @Override
    public CompoundTag createTag(RegistryAccess pRegistries, @Nullable CompoundTag pHostPlayerNBT) {
        this.updatePlayerTag();
        if (pHostPlayerNBT == null) {
            pHostPlayerNBT = this.loadedPlayerTag;
        }
        CompoundTag compoundtag = new CompoundTag();
        this.setTagData(pRegistries, compoundtag, pHostPlayerNBT);
        return compoundtag;
    }

    private void setTagData(RegistryAccess pRegistry, CompoundTag pNbt, @Nullable CompoundTag pPlayerNBT) {
        ListTag listtag = new ListTag();
        this.knownServerBrands.stream().map(StringTag::valueOf).forEach(listtag::add);
        pNbt.put("ServerBrands", listtag);
        pNbt.putBoolean("WasModded", this.wasModded);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("Name", SharedConstants.getCurrentVersion().getName());
        compoundtag.putInt("Id", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        compoundtag.putBoolean("Snapshot", !SharedConstants.getCurrentVersion().isStable());
        compoundtag.putString("Series", SharedConstants.getCurrentVersion().getDataVersion().getSeries());
        pNbt.put("Version", compoundtag);
        pNbt.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        RegistryOps<Tag> dynamicops = RegistryOps.create(NbtOps.INSTANCE, pRegistry);
        WorldGenSettings.CODEC.encodeStart(dynamicops, (Object)this.worldGenSettings).resultOrPartial(Util.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_78574_ -> pNbt.put(WORLD_GEN_SETTINGS, (Tag)p_78574_));
        pNbt.putInt("GameType", this.settings.gameType().getId());
        pNbt.putInt("SpawnX", this.xSpawn);
        pNbt.putInt("SpawnY", this.ySpawn);
        pNbt.putInt("SpawnZ", this.zSpawn);
        pNbt.putFloat("SpawnAngle", this.spawnAngle);
        pNbt.putLong("Time", this.gameTime);
        pNbt.putLong("DayTime", this.dayTime);
        pNbt.putLong("LastPlayed", Util.getEpochMillis());
        pNbt.putString("LevelName", this.settings.levelName());
        pNbt.putInt("version", 19133);
        pNbt.putInt("clearWeatherTime", this.clearWeatherTime);
        pNbt.putInt("rainTime", this.rainTime);
        pNbt.putBoolean("raining", this.raining);
        pNbt.putInt("thunderTime", this.thunderTime);
        pNbt.putBoolean("thundering", this.thundering);
        pNbt.putBoolean("hardcore", this.settings.hardcore());
        pNbt.putBoolean("allowCommands", this.settings.allowCommands());
        pNbt.putBoolean("initialized", this.initialized);
        this.worldBorder.write(pNbt);
        pNbt.putByte("Difficulty", (byte)this.settings.difficulty().getId());
        pNbt.putBoolean("DifficultyLocked", this.difficultyLocked);
        pNbt.put("GameRules", this.settings.gameRules().createTag());
        pNbt.put("DragonFight", this.endDragonFightData);
        if (pPlayerNBT != null) {
            pNbt.put(PLAYER, pPlayerNBT);
        }
        DataPackConfig.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.settings.getDataPackConfig()).result().ifPresent(p_78560_ -> pNbt.put("DataPacks", (Tag)p_78560_));
        if (this.customBossEvents != null) {
            pNbt.put("CustomBossEvents", this.customBossEvents);
        }
        pNbt.put("ScheduledEvents", this.scheduledEvents.store());
        pNbt.putInt("WanderingTraderSpawnDelay", this.wanderingTraderSpawnDelay);
        pNbt.putInt("WanderingTraderSpawnChance", this.wanderingTraderSpawnChance);
        if (this.wanderingTraderId != null) {
            pNbt.putUUID("WanderingTraderId", this.wanderingTraderId);
        }
    }

    @Override
    public int getXSpawn() {
        return this.xSpawn;
    }

    @Override
    public int getYSpawn() {
        return this.ySpawn;
    }

    @Override
    public int getZSpawn() {
        return this.zSpawn;
    }

    @Override
    public float getSpawnAngle() {
        return this.spawnAngle;
    }

    @Override
    public long getGameTime() {
        return this.gameTime;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    private void updatePlayerTag() {
        if (!this.upgradedPlayerTag && this.loadedPlayerTag != null) {
            if (this.playerDataVersion < SharedConstants.getCurrentVersion().getWorldVersion()) {
                if (this.fixerUpper == null) {
                    throw Util.pauseInIde(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.loadedPlayerTag = NbtUtils.update(this.fixerUpper, DataFixTypes.PLAYER, this.loadedPlayerTag, this.playerDataVersion);
            }
            this.upgradedPlayerTag = true;
        }
    }

    @Override
    public CompoundTag getLoadedPlayerTag() {
        this.updatePlayerTag();
        return this.loadedPlayerTag;
    }

    @Override
    public void setXSpawn(int pX) {
        this.xSpawn = pX;
    }

    @Override
    public void setYSpawn(int pY) {
        this.ySpawn = pY;
    }

    @Override
    public void setZSpawn(int pZ) {
        this.zSpawn = pZ;
    }

    @Override
    public void setSpawnAngle(float pAngle) {
        this.spawnAngle = pAngle;
    }

    @Override
    public void setGameTime(long pTime) {
        this.gameTime = pTime;
    }

    @Override
    public void setDayTime(long pTime) {
        this.dayTime = pTime;
    }

    @Override
    public void setSpawn(BlockPos pSpawnPoint, float pAngle) {
        this.xSpawn = pSpawnPoint.getX();
        this.ySpawn = pSpawnPoint.getY();
        this.zSpawn = pSpawnPoint.getZ();
        this.spawnAngle = pAngle;
    }

    @Override
    public String getLevelName() {
        return this.settings.levelName();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    @Override
    public void setClearWeatherTime(int pTime) {
        this.clearWeatherTime = pTime;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean pThundering) {
        this.thundering = pThundering;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int pTime) {
        this.thunderTime = pTime;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean pIsRaining) {
        this.raining = pIsRaining;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int pTime) {
        this.rainTime = pTime;
    }

    @Override
    public GameType getGameType() {
        return this.settings.gameType();
    }

    @Override
    public void setGameType(GameType pType) {
        this.settings = this.settings.withGameType(pType);
    }

    @Override
    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    @Override
    public boolean getAllowCommands() {
        return this.settings.allowCommands();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean pInitialized) {
        this.initialized = pInitialized;
    }

    @Override
    public GameRules getGameRules() {
        return this.settings.gameRules();
    }

    @Override
    public WorldBorder.Settings getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorder.Settings pSerializer) {
        this.worldBorder = pSerializer;
    }

    @Override
    public Difficulty getDifficulty() {
        return this.settings.difficulty();
    }

    @Override
    public void setDifficulty(Difficulty pDifficulty) {
        this.settings = this.settings.withDifficulty(pDifficulty);
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean pLocked) {
        this.difficultyLocked = pLocked;
    }

    @Override
    public TimerQueue<MinecraftServer> getScheduledEvents() {
        return this.scheduledEvents;
    }

    @Override
    public void fillCrashReportCategory(CrashReportCategory pCrashReportCategory, LevelHeightAccessor pLevel) {
        ServerLevelData.super.fillCrashReportCategory(pCrashReportCategory, pLevel);
        WorldData.super.fillCrashReportCategory(pCrashReportCategory);
    }

    @Override
    public WorldGenSettings worldGenSettings() {
        return this.worldGenSettings;
    }

    @Override
    public Lifecycle worldGenSettingsLifecycle() {
        return this.worldGenSettingsLifecycle;
    }

    @Override
    public CompoundTag endDragonFightData() {
        return this.endDragonFightData;
    }

    @Override
    public void setEndDragonFightData(CompoundTag pNbt) {
        this.endDragonFightData = pNbt;
    }

    @Override
    public DataPackConfig getDataPackConfig() {
        return this.settings.getDataPackConfig();
    }

    @Override
    public void setDataPackConfig(DataPackConfig pCodec) {
        this.settings = this.settings.withDataPackConfig(pCodec);
    }

    @Override
    @Nullable
    public CompoundTag getCustomBossEvents() {
        return this.customBossEvents;
    }

    @Override
    public void setCustomBossEvents(@Nullable CompoundTag pNbt) {
        this.customBossEvents = pNbt;
    }

    @Override
    public int getWanderingTraderSpawnDelay() {
        return this.wanderingTraderSpawnDelay;
    }

    @Override
    public void setWanderingTraderSpawnDelay(int pDelay) {
        this.wanderingTraderSpawnDelay = pDelay;
    }

    @Override
    public int getWanderingTraderSpawnChance() {
        return this.wanderingTraderSpawnChance;
    }

    @Override
    public void setWanderingTraderSpawnChance(int pChance) {
        this.wanderingTraderSpawnChance = pChance;
    }

    @Override
    @Nullable
    public UUID getWanderingTraderId() {
        return this.wanderingTraderId;
    }

    @Override
    public void setWanderingTraderId(UUID pId) {
        this.wanderingTraderId = pId;
    }

    @Override
    public void setModdedInfo(String pName, boolean pIsModded) {
        this.knownServerBrands.add(pName);
        this.wasModded |= pIsModded;
    }

    @Override
    public boolean wasModded() {
        return this.wasModded;
    }

    @Override
    public Set<String> getKnownServerBrands() {
        return ImmutableSet.copyOf(this.knownServerBrands);
    }

    @Override
    public ServerLevelData overworldData() {
        return this;
    }

    @Override
    public LevelSettings getLevelSettings() {
        return this.settings.copy();
    }
}

