/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.SerializerType;

public class GsonAdapterFactory {
    public static <E, T extends SerializerType<E>> Builder<E, T> builder(Registry<T> pRegistry, String pId, String pName, Function<E, T> pTypeFunction) {
        return new Builder<E, T>(pRegistry, pId, pName, pTypeFunction);
    }

    public static class Builder<E, T extends SerializerType<E>> {
        private final Registry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private Pair<T, InlineSerializer<? extends E>> inlineType;
        @Nullable
        private T defaultType;

        Builder(Registry<T> pRegistry, String pElementName, String pTypeKey, Function<E, T> pTypeGetter) {
            this.registry = pRegistry;
            this.elementName = pElementName;
            this.typeKey = pTypeKey;
            this.typeGetter = pTypeGetter;
        }

        public Builder<E, T> withInlineSerializer(T pInlineType, InlineSerializer<? extends E> pInlineSerializer) {
            this.inlineType = Pair.of(pInlineType, pInlineSerializer);
            return this;
        }

        public Builder<E, T> withDefaultType(T pDefaultType) {
            this.defaultType = pDefaultType;
            return this;
        }

        public Object build() {
            return new JsonAdapter<E, T>(this.registry, this.elementName, this.typeKey, this.typeGetter, this.defaultType, this.inlineType);
        }
    }

    public static interface InlineSerializer<T> {
        public JsonElement serialize(T var1, JsonSerializationContext var2);

        public T deserialize(JsonElement var1, JsonDeserializationContext var2);
    }

    static class JsonAdapter<E, T extends SerializerType<E>>
    implements JsonDeserializer<E>,
    JsonSerializer<E> {
        private final Registry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private final T defaultType;
        @Nullable
        private final Pair<T, InlineSerializer<? extends E>> inlineType;

        JsonAdapter(Registry<T> pRegistry, String pElementName, String pTypeKey, Function<E, T> pTypeGetter, @Nullable T pDefaultType, @Nullable Pair<T, InlineSerializer<? extends E>> pInlineType) {
            this.registry = pRegistry;
            this.elementName = pElementName;
            this.typeKey = pTypeKey;
            this.typeGetter = pTypeGetter;
            this.defaultType = pDefaultType;
            this.inlineType = pInlineType;
        }

        public E deserialize(JsonElement p_78848_, Type p_78849_, JsonDeserializationContext p_78850_) throws JsonParseException {
            if (p_78848_.isJsonObject()) {
                Object t;
                JsonObject jsonobject = GsonHelper.convertToJsonObject(p_78848_, this.elementName);
                String s = GsonHelper.getAsString(jsonobject, this.typeKey, "");
                if (s.isEmpty()) {
                    t = this.defaultType;
                } else {
                    ResourceLocation resourcelocation = new ResourceLocation(s);
                    t = (SerializerType)this.registry.get(resourcelocation);
                }
                if (t == null) {
                    throw new JsonSyntaxException("Unknown type '" + s + "'");
                }
                return (E)((SerializerType)t).getSerializer().deserialize(jsonobject, p_78850_);
            }
            if (this.inlineType == null) {
                throw new UnsupportedOperationException("Object " + p_78848_ + " can't be deserialized");
            }
            return (E)((InlineSerializer)this.inlineType.getSecond()).deserialize(p_78848_, p_78850_);
        }

        public JsonElement serialize(E p_78852_, Type p_78853_, JsonSerializationContext p_78854_) {
            SerializerType t = (SerializerType)this.typeGetter.apply(p_78852_);
            if (this.inlineType != null && this.inlineType.getFirst() == t) {
                return ((InlineSerializer)this.inlineType.getSecond()).serialize(p_78852_, p_78854_);
            }
            if (t == null) {
                throw new JsonSyntaxException("Unknown type: " + p_78852_);
            }
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty(this.typeKey, this.registry.getKey(t).toString());
            t.getSerializer().serialize(jsonobject, p_78852_, p_78854_);
            return jsonobject;
        }
    }
}

